/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.AbstractFirepitBlockEntity;
import net.dries007.tfc.common.blockentities.BlastFurnaceBlockEntity;
import net.dries007.tfc.common.blockentities.BloomeryBlockEntity;
import net.dries007.tfc.common.blockentities.BowlBlockEntity;
import net.dries007.tfc.common.blockentities.CharcoalForgeBlockEntity;
import net.dries007.tfc.common.blockentities.CrucibleBlockEntity;
import net.dries007.tfc.common.blockentities.FireboxBlockEntity;
import net.dries007.tfc.common.blockentities.LampBlockEntity;
import net.dries007.tfc.common.blockentities.PitKilnBlockEntity;
import net.dries007.tfc.common.blockentities.PowderkegBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickCounterBlockEntity;
import net.dries007.tfc.common.blocks.CharcoalPileBlock;
import net.dries007.tfc.common.blocks.FireboxBlock;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.TFCCandleBlock;
import net.dries007.tfc.common.blocks.TFCCandleCakeBlock;
import net.dries007.tfc.common.blocks.devices.AnvilBlock;
import net.dries007.tfc.common.blocks.devices.BarrelBlock;
import net.dries007.tfc.common.blocks.devices.BlastFurnaceBlock;
import net.dries007.tfc.common.blocks.devices.BloomeryBlock;
import net.dries007.tfc.common.blocks.devices.BurningLogPileBlock;
import net.dries007.tfc.common.blocks.devices.CharcoalForgeBlock;
import net.dries007.tfc.common.blocks.devices.JackOLanternBlock;
import net.dries007.tfc.common.blocks.devices.LampBlock;
import net.dries007.tfc.common.blocks.devices.PitKilnBlock;
import net.dries007.tfc.common.blocks.devices.PowderkegBlock;
import net.dries007.tfc.common.blocks.devices.SluiceBlock;
import net.dries007.tfc.common.blocks.rock.AqueductBlock;
import net.dries007.tfc.common.blocks.rock.Rock;
import net.dries007.tfc.common.blocks.rock.RockAnvilBlock;
import net.dries007.tfc.common.blocks.wood.TFCLecternBlock;
import net.dries007.tfc.common.commands.TFCCommands;
import net.dries007.tfc.common.component.Bowl;
import net.dries007.tfc.common.component.TFCComponents;
import net.dries007.tfc.common.component.forge.ForgingBonus;
import net.dries007.tfc.common.component.forge.ForgingBonusComponent;
import net.dries007.tfc.common.component.glass.GlassWorking;
import net.dries007.tfc.common.component.heat.HeatCapability;
import net.dries007.tfc.common.component.heat.IHeat;
import net.dries007.tfc.common.component.item.ItemComponent;
import net.dries007.tfc.common.container.BlockEntityContainer;
import net.dries007.tfc.common.container.Container;
import net.dries007.tfc.common.container.PestContainer;
import net.dries007.tfc.common.effect.TFCEffects;
import net.dries007.tfc.common.entities.misc.HoldingMinecart;
import net.dries007.tfc.common.entities.predator.Predator;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.items.BlowpipeItem;
import net.dries007.tfc.common.items.TFCShieldItem;
import net.dries007.tfc.common.player.IPlayerInfo;
import net.dries007.tfc.common.recipes.CollapseRecipe;
import net.dries007.tfc.common.recipes.LandslideRecipe;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.network.DataManagerSyncPacket;
import net.dries007.tfc.network.EffectExpirePacket;
import net.dries007.tfc.network.PlayerDrinkPacket;
import net.dries007.tfc.network.UpdateClimateModelPacket;
import net.dries007.tfc.util.AxeLoggingHelper;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.InteractionManager;
import net.dries007.tfc.util.PhysicalDamageType;
import net.dries007.tfc.util.SelfTests;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.climate.ClimateModel;
import net.dries007.tfc.util.climate.OverworldClimateModel;
import net.dries007.tfc.util.data.DataManagers;
import net.dries007.tfc.util.data.Drinkable;
import net.dries007.tfc.util.data.Fertilizer;
import net.dries007.tfc.util.events.DouseFireEvent;
import net.dries007.tfc.util.events.LoggingEvent;
import net.dries007.tfc.util.events.SelectClimateModelEvent;
import net.dries007.tfc.util.events.StartFireEvent;
import net.dries007.tfc.util.tracker.WorldTracker;
import net.dries007.tfc.world.ChunkGeneratorExtension;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.PlayerRespawnLogic;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.LingeringPotionItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.ItemStackedOnOtherEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.ServerChatEvent;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityMountEvent;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.item.ItemExpireEvent;
import net.neoforged.neoforge.event.entity.living.AnimalTameEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingShieldBlockEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.BonemealEvent;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.entity.player.UseItemOnBlockEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ChunkWatchEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.level.block.CreateFluidSourceEvent;
import net.neoforged.neoforge.event.level.block.CropGrowEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class ForgeEventHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String ALPHABET = "abcdefghijklmnopqrstuvwxyz";
    private static final BlockHitResult FAKE_MISS = BlockHitResult.miss((Vec3)Vec3.ZERO, (Direction)Direction.UP, (BlockPos)BlockPos.ZERO);

    public static void init() {
        IEventBus bus = NeoForge.EVENT_BUS;
        bus.addListener(ForgeEventHandler::onCreateWorldSpawn);
        bus.addListener(ForgeEventHandler::onChunkWatch);
        bus.addListener(EventPriority.LOW, ForgeEventHandler::registerCommands);
        bus.addListener(ForgeEventHandler::onBlockBroken);
        bus.addListener(ForgeEventHandler::onBlockPlace);
        bus.addListener(ForgeEventHandler::onBreakSpeed);
        bus.addListener(ForgeEventHandler::onNeighborUpdate);
        bus.addListener(ForgeEventHandler::onExplosionDetonate);
        bus.addListener(ForgeEventHandler::onWorldTick);
        bus.addListener(ForgeEventHandler::onWorldLoad);
        bus.addListener(ForgeEventHandler::onCreateNetherPortal);
        bus.addListener(ForgeEventHandler::onFluidPlaceBlock);
        bus.addListener(ForgeEventHandler::onFluidCreateSource);
        bus.addListener(ForgeEventHandler::onFireStart);
        bus.addListener(ForgeEventHandler::onFireStop);
        bus.addListener(ForgeEventHandler::onProjectileImpact);
        bus.addListener(ForgeEventHandler::onPlayerTick);
        bus.addListener(ForgeEventHandler::onEffectRemove);
        bus.addListener(ForgeEventHandler::onEffectExpire);
        bus.addListener(ForgeEventHandler::onLivingJump);
        bus.addListener(ForgeEventHandler::onLivingHurt);
        bus.addListener(ForgeEventHandler::onShieldBlock);
        bus.addListener(ForgeEventHandler::onLivingSpawnCheck);
        bus.addListener(ForgeEventHandler::onItemStacked);
        bus.addListener(ForgeEventHandler::onEntityJoinLevel);
        bus.addListener(ForgeEventHandler::onItemExpire);
        bus.addListener(ForgeEventHandler::onPlayerLoggedIn);
        bus.addListener(ForgeEventHandler::onPlayerRespawn);
        bus.addListener(ForgeEventHandler::onPlayerDeath);
        bus.addListener(ForgeEventHandler::onPlayerChangeDimension);
        bus.addListener(ForgeEventHandler::onServerChat);
        bus.addListener(ForgeEventHandler::onPlayerRightClickBlock);
        bus.addListener(EventPriority.LOWEST, true, ForgeEventHandler::onPlayerRightClickBlockLowestPriority);
        bus.addListener(ForgeEventHandler::onPlayerRightClickItem);
        bus.addListener(ForgeEventHandler::onPlayerRightClickEmpty);
        bus.addListener(ForgeEventHandler::onUseItemOnBlock);
        bus.addListener(ForgeEventHandler::onItemUseFinish);
        bus.addListener(ForgeEventHandler::addReloadListeners);
        bus.addListener(ForgeEventHandler::onDataPackSync);
        bus.addListener(ForgeEventHandler::onTagsUpdated);
        bus.addListener(ForgeEventHandler::onBoneMeal);
        bus.addListener(EventPriority.HIGHEST, ForgeEventHandler::onSelectClimateModel);
        bus.addListener(ForgeEventHandler::onAnimalTame);
        bus.addListener(ForgeEventHandler::onContainerOpen);
        bus.addListener(ForgeEventHandler::onCropsGrow);
        bus.addListener(ForgeEventHandler::onMount);
        bus.addListener(ForgeEventHandler::onEntityInteract);
    }

    public static void onCreateWorldSpawn(LevelEvent.CreateSpawnPosition event) {
        ServerLevel level;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && (levelAccessor = (level = (ServerLevel)levelAccessor).getChunkSource().getGenerator()) instanceof ChunkGeneratorExtension) {
            ChunkGeneratorExtension extension = (ChunkGeneratorExtension)levelAccessor;
            ChunkGenerator generator = extension.self();
            ServerLevelData levelData = event.getSettings();
            XoroshiroRandomSource random = new XoroshiroRandomSource(level.getSeed());
            ChunkPos chunkPos = new ChunkPos(extension.findSpawnBiome((RandomSource)random));
            levelData.setSpawn(chunkPos.getWorldPosition().offset(8, generator.getSpawnHeight((LevelHeightAccessor)level), 8), 0.0f);
            boolean foundExactSpawn = false;
            int x = 0;
            int z = 0;
            int xStep = 0;
            int zStep = -1;
            for (int tries = 0; tries < 1024; ++tries) {
                BlockPos spawnPos;
                if (x > -16 && x <= 16 && z > -16 && z <= 16 && (spawnPos = PlayerRespawnLogic.getSpawnPosInChunk((ServerLevel)level, (ChunkPos)new ChunkPos(chunkPos.x + x, chunkPos.z + z))) != null) {
                    levelData.setSpawn(spawnPos, 0.0f);
                    foundExactSpawn = true;
                    break;
                }
                if (x == z || x < 0 && x == -z || x > 0 && x == 1 - z) {
                    int swap = xStep;
                    xStep = -zStep;
                    zStep = swap;
                }
                x += xStep;
                z += zStep;
            }
            if (!foundExactSpawn) {
                LOGGER.warn("Unable to find a suitable spawn location!");
            }
            if (level.getServer().getWorldData().worldGenOptions().generateBonusChest()) {
                LOGGER.warn("No bonus chest for you, you cheaty cheater!");
            }
            event.setCanceled(true);
        }
    }

    public static void onChunkWatch(ChunkWatchEvent.Sent event) {
        ChunkData chunkData = ChunkData.get((ChunkAccess)event.getChunk());
        if (chunkData.status() == ChunkData.Status.FULL) {
            PacketDistributor.sendToPlayer((ServerPlayer)event.getPlayer(), (CustomPacketPayload)chunkData.getUpdatePacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void registerCommands(RegisterCommandsEvent event) {
        LOGGER.debug("Registering TFC Commands");
        TFCCommands.registerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    public static void onBlockBroken(BlockEvent.BreakEvent event) {
        BlockPos pos;
        LevelAccessor levelAccess = event.getLevel();
        BlockState state = levelAccess.getBlockState(pos = event.getPos());
        if (Helpers.isBlock(state, TFCTags.Blocks.CAN_TRIGGER_COLLAPSE) && levelAccess instanceof Level) {
            Level level = (Level)levelAccess;
            CollapseRecipe.tryTriggerCollapse(level, pos);
            return;
        }
        ItemStack stack = event.getPlayer().getMainHandItem();
        if (AxeLoggingHelper.shouldLog(levelAccess, pos, state, stack) && !((LoggingEvent)NeoForge.EVENT_BUS.post((Event)new LoggingEvent(levelAccess, pos, state, stack))).isCanceled()) {
            event.setCanceled(true);
            AxeLoggingHelper.doLogging(levelAccess, pos, event.getPlayer(), stack);
        }
    }

    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)levelAccessor;
            BlockPos pos = event.getPos();
            BlockState state = event.getState();
            if (LandslideRecipe.canLandslide(state)) {
                WorldTracker.get((Level)world).addLandslidePos(pos);
            }
            if (Helpers.isBlock(state, TFCTags.Blocks.BREAKS_WHEN_ISOLATED)) {
                WorldTracker.get((Level)world).addIsolatedPos(pos);
            }
        }
    }

    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        ForgingBonus bonus = ForgingBonusComponent.get(event.getEntity().getMainHandItem());
        if (bonus != ForgingBonus.NONE) {
            event.setNewSpeed(event.getNewSpeed() * bonus.efficiency());
        }
    }

    public static void onNeighborUpdate(BlockEvent.NeighborNotifyEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            for (Direction direction : event.getNotifiedSides()) {
                BlockPos pos = event.getPos().relative(direction);
                BlockState state = level.getBlockState(pos);
                if (LandslideRecipe.canLandslide(state)) {
                    WorldTracker.get((Level)level).addLandslidePos(pos);
                }
                if (!Helpers.isBlock(state.getBlock(), TFCTags.Blocks.BREAKS_WHEN_ISOLATED)) continue;
                WorldTracker.get((Level)level).addIsolatedPos(pos);
            }
        }
    }

    public static void onExplosionDetonate(ExplosionEvent.Detonate event) {
        Level level = event.getLevel();
        if (!level.isClientSide) {
            WorldTracker.get(level).addCollapsePositions(BlockPos.containing((Position)event.getExplosion().center()), event.getExplosion().getToBlow());
        }
    }

    public static void onWorldTick(LevelTickEvent.Pre event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            WorldTracker.get((Level)level2).tick();
        }
    }

    public static void onWorldLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            MinecraftServer server = level.getServer();
            GameRules rules = level.getGameRules();
            if (TFCConfig.SERVER.enableForcedTFCGameRules.get().booleanValue()) {
                ((GameRules.BooleanValue)rules.getRule(GameRules.RULE_NATURAL_REGENERATION)).set(false, server);
                ((GameRules.BooleanValue)rules.getRule(GameRules.RULE_DOINSOMNIA)).set(false, server);
                ((GameRules.BooleanValue)rules.getRule(GameRules.RULE_DO_PATROL_SPAWNING)).set(false, server);
                ((GameRules.BooleanValue)rules.getRule(GameRules.RULE_DO_TRADER_SPAWNING)).set(false, server);
                LOGGER.info("Updating TFC Relevant Game Rules for level {}.", (Object)level.dimension().location());
            }
            ((GameRules.BooleanValue)rules.getRule(GameRules.RULE_DAYLIGHT)).set(false, server);
            Climate.chooseModelForWorld(level);
            if (level.dimension() == Level.OVERWORLD) {
                SelfTests.runServerSelfTests(level.getServer());
            }
        }
    }

    public static void onCreateNetherPortal(BlockEvent.PortalSpawnEvent event) {
        if (!TFCConfig.SERVER.enableNetherPortals.get().booleanValue()) {
            event.setCanceled(true);
        }
    }

    public static void onFluidPlaceBlock(BlockEvent.FluidPlaceBlockEvent event) {
        BlockState state = event.getNewState();
        if (Helpers.isBlock(state, Blocks.STONE)) {
            event.setNewState(((Block)TFCBlocks.ROCK_BLOCKS.get(Rock.GABBRO).get((Object)Rock.BlockType.HARDENED).get()).defaultBlockState());
        } else if (Helpers.isBlock(state, Blocks.COBBLESTONE)) {
            event.setNewState(((Block)TFCBlocks.ROCK_BLOCKS.get(Rock.RHYOLITE).get((Object)Rock.BlockType.HARDENED).get()).defaultBlockState());
        } else if (Helpers.isBlock(state, Blocks.BASALT)) {
            event.setNewState(((Block)TFCBlocks.ROCK_BLOCKS.get(Rock.BASALT).get((Object)Rock.BlockType.HARDENED).get()).defaultBlockState());
        }
    }

    public static void onFluidCreateSource(CreateFluidSourceEvent event) {
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = event.getState();
        if (state.getBlock() instanceof AqueductBlock) {
            event.setCanConvert(false);
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos relPos = pos.relative(direction).above();
            BlockState relState = level.getBlockState(relPos);
            if (!(relState.getBlock() instanceof SluiceBlock) || ((Boolean)relState.getValue((Property)SluiceBlock.UPPER)).booleanValue() || relState.getValue((Property)SluiceBlock.FACING) != direction.getOpposite()) continue;
            event.setCanConvert(false);
        }
    }

    public static void onFireStart(StartFireEvent event) {
        BowlBlockEntity bowl;
        ItemStack stack;
        BlockEntity bloomery2;
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = event.getState();
        Block block = state.getBlock();
        if ((block == TFCBlocks.FIREPIT.get() || block == TFCBlocks.POT.get() || block == TFCBlocks.GRILL.get() || block == TFCBlocks.STOVE.get() || block == TFCBlocks.STOVE_POT.get()) && event.isStrong()) {
            AbstractFirepitBlockEntity firepit;
            BlockEntity entity2 = level.getBlockEntity(pos);
            if (entity2 instanceof AbstractFirepitBlockEntity && (firepit = (AbstractFirepitBlockEntity)entity2).light(state)) {
                event.setCanceled(true);
            }
        } else if (block == TFCBlocks.TORCH.get() || block == TFCBlocks.WALL_TORCH.get()) {
            level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.TICK_COUNTER.get()).ifPresent(TickCounterBlockEntity::resetCounter);
            event.setCanceled(true);
        } else if (block == TFCBlocks.DEAD_TORCH.get()) {
            level.setBlockAndUpdate(pos, ((Block)TFCBlocks.TORCH.get()).defaultBlockState());
            level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.TICK_COUNTER.get()).ifPresent(TickCounterBlockEntity::resetCounter);
            event.setCanceled(true);
        } else if (block == TFCBlocks.DEAD_WALL_TORCH.get()) {
            level.setBlockAndUpdate(pos, ((Block)TFCBlocks.WALL_TORCH.get()).withPropertiesOf(state));
            level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.TICK_COUNTER.get()).ifPresent(TickCounterBlockEntity::resetCounter);
            event.setCanceled(true);
        } else if (block == TFCBlocks.LOG_PILE.get() && event.isStrong()) {
            BurningLogPileBlock.lightLogPile(level, pos);
            event.setCanceled(true);
        } else if (block == TFCBlocks.PIT_KILN.get() && (Integer)state.getValue((Property)PitKilnBlock.STAGE) == 15 && event.isStrong()) {
            PitKilnBlockEntity kiln;
            BlockEntity firepit = level.getBlockEntity(pos);
            if (firepit instanceof PitKilnBlockEntity && (kiln = (PitKilnBlockEntity)firepit).tryLight()) {
                event.setCanceled(true);
            }
        } else if (block == TFCBlocks.CHARCOAL_PILE.get() && (Integer)state.getValue((Property)CharcoalPileBlock.LAYERS) >= 7 && CharcoalForgeBlock.isValid((LevelAccessor)level, pos) && event.isStrong()) {
            CharcoalForgeBlockEntity.createFromCharcoalPile(level, pos);
            event.setCanceled(true);
        } else if (block == TFCBlocks.CHARCOAL_FORGE.get() && CharcoalForgeBlock.isValid((LevelAccessor)level, pos) && event.isStrong()) {
            CharcoalForgeBlockEntity forge;
            BlockEntity entity3 = level.getBlockEntity(pos);
            if (entity3 instanceof CharcoalForgeBlockEntity && (forge = (CharcoalForgeBlockEntity)entity3).light(state)) {
                event.setCanceled(true);
            }
        } else if (block == TFCBlocks.CRUCIBLE.get() && CharcoalForgeBlock.isValid((LevelAccessor)level, pos.below()) && event.isStrong()) {
            CharcoalForgeBlockEntity forge;
            BlockEntity entity4 = level.getBlockEntity(pos.below());
            if (entity4 instanceof CharcoalForgeBlockEntity && (forge = (CharcoalForgeBlockEntity)entity4).light(level.getBlockState(pos.below()))) {
                event.setCanceled(true);
            }
        } else if (block == TFCBlocks.BLOOMERY.get() && !((Boolean)state.getValue((Property)BloomeryBlock.LIT)).booleanValue() && event.isStrong()) {
            BloomeryBlockEntity bloomery2;
            BlockEntity entity5 = level.getBlockEntity(pos);
            if (entity5 instanceof BloomeryBlockEntity && (bloomery2 = (BloomeryBlockEntity)entity5).light(state)) {
                event.setCanceled(true);
            }
        } else if (block == TFCBlocks.POWDERKEG.get() && ((Boolean)state.getValue((Property)PowderkegBlock.SEALED)).booleanValue() && event.isStrong()) {
            level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.POWDERKEG.get()).ifPresent(entity -> {
                entity.setLit(true, (Entity)event.getPlayer());
                event.setCanceled(true);
            });
        } else if (block == TFCBlocks.BLAST_FURNACE.get() && !((Boolean)state.getValue((Property)BlastFurnaceBlock.LIT)).booleanValue() && event.isStrong()) {
            level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.BLAST_FURNACE.get()).ifPresent(blastFurnace -> {
                if (blastFurnace.light(level, pos, state)) {
                    event.setCanceled(true);
                }
            });
        } else if (block == TFCBlocks.FIREBOX.get() && !((Boolean)state.getValue((Property)FireboxBlock.LIT)).booleanValue() && event.isStrong()) {
            FireboxBlockEntity box;
            BlockEntity bloomery2 = level.getBlockEntity(pos);
            if (bloomery2 instanceof FireboxBlockEntity && (box = (FireboxBlockEntity)bloomery2).light(state)) {
                event.setCanceled(true);
            }
        } else if (block instanceof LampBlock) {
            if (!((Boolean)state.getValue((Property)LampBlock.LIT)).booleanValue()) {
                level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.LAMP.get()).ifPresent(lamp -> {
                    if (lamp.getFuel() != null && !((Boolean)state.getValue((Property)LampBlock.LIT)).booleanValue()) {
                        level.setBlock(pos, (BlockState)state.setValue((Property)LampBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
                        lamp.resetCounter();
                    }
                });
                event.setCanceled(true);
            }
        } else if ((block instanceof TFCCandleBlock || block instanceof TFCCandleCakeBlock) && state.getFluidState().isEmpty()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)TFCCandleBlock.LIT, (Comparable)Boolean.valueOf(true)), 11);
            TickCounterBlockEntity.reset(level, pos);
            event.setCanceled(true);
        } else if (block == Blocks.CARVED_PUMPKIN || block == TFCBlocks.JACK_O_LANTERN.get()) {
            level.setBlockAndUpdate(pos, Helpers.copyProperty(((Block)TFCBlocks.JACK_O_LANTERN.get()).defaultBlockState(), state, HorizontalDirectionalBlock.FACING));
            TickCounterBlockEntity.reset(level, pos);
            event.setCanceled(true);
        } else if (block instanceof TntBlock) {
            TntBlock tnt = (TntBlock)block;
            tnt.onCaughtFire(state, level, pos, event.getTargetedFace(), (LivingEntity)event.getPlayer());
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
            event.setCanceled(true);
        } else if (block == TFCBlocks.CERAMIC_BOWL.get() && (bloomery2 = level.getBlockEntity(pos)) instanceof BowlBlockEntity && (stack = ((ItemStackHandler)(bowl = (BowlBlockEntity)bloomery2).getInventory()).getStackInSlot(0)).getItem() == Items.GUNPOWDER) {
            Helpers.removeStack(bowl.getInventory(), 0);
            level.explode(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (float)stack.getCount() / 6.0f + 2.0f, Level.ExplosionInteraction.BLOCK);
            event.setCanceled(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void onFireStop(DouseFireEvent event) {
        BlastFurnaceBlockEntity furnace;
        PowderkegBlockEntity keg;
        CharcoalForgeBlockEntity forge;
        AbstractFirepitBlockEntity firepit;
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = event.getState();
        Block block = state.getBlock();
        Player player = event.getPlayer();
        if (state.isAir()) {
            return;
        }
        if (Helpers.isBlock(state, (TagKey<Block>)BlockTags.FIRE)) {
            level.removeBlock(pos, false);
            Helpers.playSound(level, pos, SoundEvents.FIRE_EXTINGUISH);
            event.setCanceled(true);
        } else if (AbstractCandleBlock.isLit((BlockState)state)) {
            AbstractCandleBlock.extinguish(null, (BlockState)state, (LevelAccessor)level, (BlockPos)pos);
            event.setCanceled(true);
        } else if (CampfireBlock.isLitCampfire((BlockState)state)) {
            level.levelEvent(player, 1009, pos, 0);
            CampfireBlock.dowse((Entity)player, (LevelAccessor)level, (BlockPos)pos, (BlockState)state);
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false)));
            event.setCanceled(true);
        } else if (block == TFCBlocks.WALL_TORCH.get()) {
            level.setBlockAndUpdate(pos, ((Block)TFCBlocks.DEAD_WALL_TORCH.get()).withPropertiesOf(state));
            event.setCanceled(true);
        } else if (block == TFCBlocks.TORCH.get()) {
            level.setBlockAndUpdate(pos, ((Block)TFCBlocks.DEAD_TORCH.get()).withPropertiesOf(state));
            event.setCanceled(true);
        }
        if (block == TFCBlocks.WALL_TORCH.get()) {
            level.setBlockAndUpdate(pos, ((Block)TFCBlocks.DEAD_WALL_TORCH.get()).withPropertiesOf(state));
            event.setCanceled(true);
        }
        if (block instanceof JackOLanternBlock) {
            JackOLanternBlock lantern = (JackOLanternBlock)block;
            lantern.extinguish(level, pos, state);
            event.setCanceled(true);
        }
        if (event.isCanceled()) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof LampBlockEntity) {
            LampBlockEntity lamp = (LampBlockEntity)blockEntity;
            if (((Boolean)state.getValue((Property)LampBlock.LIT)).booleanValue()) {
                Helpers.playSound(level, pos, SoundEvents.FIRE_EXTINGUISH);
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LampBlock.LIT, (Comparable)Boolean.valueOf(false)));
                lamp.resetCounter();
                event.setCanceled(true);
                return;
            }
        }
        if (blockEntity instanceof AbstractFirepitBlockEntity && (firepit = (AbstractFirepitBlockEntity)blockEntity).getTemperature() > 0.0f) {
            firepit.extinguish(state);
            event.setCanceled(true);
            return;
        }
        if (blockEntity instanceof CharcoalForgeBlockEntity && (forge = (CharcoalForgeBlockEntity)blockEntity).getTemperature() > 0.0f) {
            forge.extinguish(state);
            event.setCanceled(true);
            return;
        }
        if (blockEntity instanceof PowderkegBlockEntity && (keg = (PowderkegBlockEntity)blockEntity).isLit()) {
            keg.setLit(false, (Entity)player);
            event.setCanceled(true);
            return;
        }
        if (blockEntity instanceof BlastFurnaceBlockEntity && (furnace = (BlastFurnaceBlockEntity)blockEntity).getTemperature() > 0.0f) {
            furnace.extinguish(state);
            event.setCanceled(true);
            return;
        }
        if (blockEntity instanceof CrucibleBlockEntity) {
            CrucibleBlockEntity crucible = (CrucibleBlockEntity)blockEntity;
            ((CrucibleBlockEntity.CrucibleInventory)crucible.getInventory()).setTemperature(0.0f);
            return;
        }
        if (!(blockEntity instanceof FireboxBlockEntity)) return;
        FireboxBlockEntity firebox = (FireboxBlockEntity)blockEntity;
        firebox.extinguish(state);
        event.setCanceled(true);
    }

    public static void onProjectileImpact(ProjectileImpactEvent event) {
        ThrownPotion potion;
        PotionContents contents;
        Projectile projectile = event.getProjectile();
        HitResult result = event.getRayTraceResult();
        Level level = projectile.level();
        if (projectile instanceof ThrownPotion && (contents = (PotionContents)(potion = (ThrownPotion)projectile).getItem().get(DataComponents.POTION_CONTENTS)) != null && contents.is(Potions.WATER) && !contents.hasEffects()) {
            Player player;
            boolean lingering = potion.getItem().getItem() instanceof LingeringPotionItem;
            Entity entity = projectile.getOwner();
            DouseFireEvent.douse(level, potion.getBoundingBox().inflate(lingering ? 4.0 : 2.0, 2.0, lingering ? 4.0 : 2.0), entity instanceof Player ? (player = (Player)entity) : null);
        }
        if (!TFCConfig.SERVER.enableFireArrowSpreading.get().booleanValue()) {
            return;
        }
        if (result.getType() == HitResult.Type.BLOCK && projectile.isOnFire()) {
            BlockHitResult blockResult = (BlockHitResult)result;
            BlockPos pos = blockResult.getBlockPos();
            StartFireEvent.startFire(projectile.level(), pos, projectile.level().getBlockState(pos), blockResult.getDirection(), null, ItemStack.EMPTY);
        }
    }

    public static void onPlayerTick(PlayerTickEvent.Pre event) {
        Player player = event.getEntity();
        Level level = player.level();
        float angle = Mth.wrapDegrees((float)player.getXRot());
        if (angle <= -80.0f && !level.isClientSide() && level.isRainingAt(player.blockPosition().above())) {
            IPlayerInfo.get(player).addThirst(TFCConfig.SERVER.thirstGainedFromDrinkingInTheRain.get().floatValue());
        }
        if (!level.isClientSide() && !player.getAbilities().invulnerable && TFCConfig.SERVER.enableOverburdening.get().booleanValue() && level.getGameTime() % 20L == 0L) {
            switch (Helpers.getCarryCount((Container)player.getInventory())) {
                case ONE: {
                    player.addEffect(Helpers.getExhausted(false));
                    break;
                }
                case MORE_THAN_ONE: {
                    player.addEffect(Helpers.getOverburdened(false));
                }
            }
        }
    }

    public static void onEffectRemove(MobEffectEvent.Remove event) {
        MobEffectInstance inst = event.getEffectInstance();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (inst != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new EffectExpirePacket((Holder<MobEffect>)inst.getEffect()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                if (inst.getEffect() == TFCEffects.PINNED.get()) {
                    player.setForcedPose(null);
                }
            }
        }
    }

    public static void onEffectExpire(MobEffectEvent.Expired event) {
        LivingEntity livingEntity;
        MobEffectInstance instance = event.getEffectInstance();
        if (instance != null && (livingEntity = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new EffectExpirePacket((Holder<MobEffect>)instance.getEffect()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            if (instance.getEffect() == TFCEffects.PINNED.get()) {
                player.setForcedPose(null);
            }
        }
    }

    public static void onLivingJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.hasEffect(TFCEffects.PINNED.holder()) || entity.hasEffect(TFCEffects.OVERBURDENED.holder())) {
            entity.setDeltaMovement(0.0, 0.0, 0.0);
            entity.hasImpulse = false;
        }
    }

    public static void onLivingHurt(LivingIncomingDamageEvent event) {
        float amount = event.getAmount();
        if (amount == Float.MAX_VALUE) {
            return;
        }
        Entity attackerEntity = event.getSource().getEntity();
        if (attackerEntity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)attackerEntity;
            amount *= ForgingBonusComponent.get(livingEntity.getMainHandItem()).damage();
        }
        amount *= PhysicalDamageType.calculateMultiplier(event.getSource(), (Entity)event.getEntity());
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            amount /= IPlayerInfo.get(player).getHealthModifier();
        }
        event.setAmount(amount);
    }

    public static void onShieldBlock(LivingShieldBlockEvent event) {
        float damageModifier = 1.0f;
        Item useItem = event.getEntity().getUseItem().getItem();
        if (useItem == Items.SHIELD) {
            damageModifier = 0.25f;
        }
        if (useItem instanceof TFCShieldItem) {
            TFCShieldItem shield = (TFCShieldItem)useItem;
            damageModifier = shield.getDamageBlocked();
        }
        if (!event.getDamageSource().is(DamageTypeTags.IS_PROJECTILE)) {
            event.setBlockedDamage(event.getOriginalBlockedDamage() * damageModifier);
        }
    }

    public static void onItemStacked(ItemStackedOnOtherEvent event) {
        ItemStack batch = event.getCarriedItem();
        ItemStack pipe = event.getStackedOnItem();
        if (event.getClickAction() == ClickAction.SECONDARY && pipe.getCount() == 1 && Helpers.isItem(pipe, TFCTags.Items.TOOLS_BLOWPIPE) && Helpers.isItem(batch.getItem(), TFCTags.Items.GLASS_BATCHES)) {
            ItemStack newItem = new ItemStack((ItemLike)BlowpipeItem.transform(pipe.getItem()));
            GlassWorking.createNewBatch(newItem, batch);
            event.getSlot().set(newItem);
            event.getCarriedSlotAccess().get().shrink(1);
            event.setCanceled(true);
        }
    }

    public static void onLivingSpawnCheck(FinalizeSpawnEvent event) {
        Mob entity = event.getEntity();
        ServerLevelAccessor level = event.getLevel();
        MobSpawnType spawn = event.getSpawnType();
        if ((spawn == MobSpawnType.NATURAL || spawn == MobSpawnType.CHUNK_GENERATION || spawn == MobSpawnType.REINFORCEMENT) && Helpers.isEntity((Entity)entity, TFCTags.Entities.MONSTERS)) {
            if (TFCConfig.SERVER.enableVanillaMonsters.get().booleanValue()) {
                if (!TFCConfig.SERVER.enableVanillaMonstersOnSurface.get().booleanValue()) {
                    BlockPos pos = entity.blockPosition();
                    if (entity.getType() != EntityType.SLIME && level.getRawBrightness(pos, 0) != 0) {
                        event.setSpawnCancelled(true);
                        event.setCanceled(true);
                    } else if (level.getHeight(Heightmap.Types.WORLD_SURFACE, pos.getX(), pos.getZ()) <= pos.getY()) {
                        event.setSpawnCancelled(true);
                        event.setCanceled(true);
                    } else if (!Helpers.isBlock(level.getBlockState(pos.below()), TFCTags.Blocks.MONSTER_SPAWNS_ON)) {
                        event.setSpawnCancelled(true);
                        event.setCanceled(true);
                    }
                }
            } else {
                event.setSpawnCancelled(true);
                event.setCanceled(true);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        block24: {
            block26: {
                block25: {
                    if (event.loadedFromDisk()) {
                        return;
                    }
                    level = event.getLevel();
                    entity = event.getEntity();
                    if (!(entity instanceof ItemEntity)) ** GOTO lbl-1000
                    itemEntity = (ItemEntity)entity;
                    if (!level.isClientSide && TFCConfig.SERVER.coolHotItemEntities.get().booleanValue()) {
                        item = itemEntity.getItem();
                        if (HeatCapability.isHot(item)) {
                            itemEntity.lifespan = TFCConfig.SERVER.ticksBeforeItemCool.get();
                        }
                    } else if (entity instanceof LightningBolt) {
                        lightning = (LightningBolt)entity;
                        if (!level.isClientSide && !event.isCanceled()) {
                            if (!TFCConfig.SERVER.enableLightning.get().booleanValue()) {
                                event.setCanceled(true);
                                return;
                            }
                            if (TFCConfig.SERVER.enableLightningStrippingLogs.get().booleanValue() && level.random.nextFloat() < 0.2f) {
                                mutable = new BlockPos.MutableBlockPos();
                                pos = lightning.blockPosition();
                                for (x = -5; x <= 5; ++x) {
                                    for (y = -5; y <= 5; ++y) {
                                        for (z = -5; z <= 5; ++z) {
                                            if (level.random.nextInt(3) != 0 || x * x + y * y + z * z > 25) continue;
                                            mutable.setWithOffset((Vec3i)pos, x, y, z);
                                            state = level.getBlockState((BlockPos)mutable);
                                            modified = state.getToolModifiedState(new UseOnContext(level, null, InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.DIAMOND_AXE), new BlockHitResult(Vec3.atBottomCenterOf((Vec3i)mutable), Direction.DOWN, (BlockPos)mutable, false)), ItemAbilities.AXE_STRIP, true);
                                            if (modified == null) continue;
                                            level.setBlockAndUpdate((BlockPos)mutable, modified);
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (entity instanceof Monster) {
                        monster = (Monster)entity;
                        if (!TFCConfig.SERVER.enableVanillaMobsSpawningWithVanillaEquipment.get().booleanValue()) {
                            if (Helpers.isItem(monster.getItemInHand(InteractionHand.MAIN_HAND), TFCTags.Items.DISABLED_MONSTER_HELD_ITEMS)) {
                                monster.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                            }
                            if (Helpers.isItem(monster.getItemInHand(InteractionHand.OFF_HAND), TFCTags.Items.DISABLED_MONSTER_HELD_ITEMS)) {
                                monster.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY);
                            }
                        }
                    }
                    if (TFCConfig.SERVER.enableChickenJockies.get().booleanValue()) break block24;
                    if (!(entity instanceof Chicken)) break block25;
                    chicken = (Chicken)entity;
                    if (chicken.isChickenJockey) break block26;
                }
                if (entity.getVehicle() == null || !((var5_4 = entity.getVehicle()) instanceof Chicken)) break block24;
                vehicleChicken = (Chicken)var5_4;
                if (!vehicleChicken.isChickenJockey) break block24;
            }
            event.setCanceled(true);
        }
        if (entity.getType() == EntityType.SKELETON && entity instanceof Skeleton) {
            skeleton = (Skeleton)entity;
            skeleton.setItemSlot(EquipmentSlot.MAINHAND, Helpers.randomItem(TFCTags.Items.SKELETON_WEAPONS, entity.level().getRandom()).orElse(Items.BOW).getDefaultInstance());
        } else if (entity.getType() == EntityType.SKELETON_HORSE && !TFCConfig.SERVER.enableVanillaSkeletonHorseSpawning.get().booleanValue()) {
            event.setCanceled(true);
        } else if ((entity instanceof IronGolem || entity instanceof SnowGolem) && !TFCConfig.SERVER.enableVanillaGolems.get().booleanValue()) {
            event.setCanceled(true);
        }
    }

    public static void onItemExpire(ItemExpireEvent event) {
        if (!TFCConfig.SERVER.coolHotItemEntities.get().booleanValue()) {
            return;
        }
        ItemEntity entity = event.getEntity();
        if (entity.level().isClientSide) {
            return;
        }
        ServerLevel level = (ServerLevel)entity.level();
        ItemStack stack = entity.getItem();
        BlockPos pos = entity.blockPosition();
        @Nullable IHeat heat = HeatCapability.get(stack);
        if (heat != null) {
            int lifespan = stack.getItem().getEntityLifespan(stack, (Level)level);
            if (entity.lifespan >= lifespan) {
                return;
            }
            float itemTemp = heat.getTemperature();
            if (itemTemp > 0.0f) {
                float coolAmount = 0.0f;
                BlockState state = level.getBlockState(pos);
                if (FluidHelpers.canFluidExtinguishFire(state.getFluidState().getType())) {
                    coolAmount = 50.0f;
                    if (level.random.nextFloat() < 0.001f && FluidHelpers.isAirOrEmptyFluid(state)) {
                        level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                    }
                } else if (Helpers.isBlock(state, Blocks.SNOW)) {
                    coolAmount = 70.0f;
                    if (level.random.nextFloat() < 0.1f) {
                        int layers = (Integer)state.getValue((Property)SnowLayerBlock.LAYERS);
                        if (layers > 1) {
                            level.destroyBlock(pos, false);
                            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(layers - 1)));
                        } else {
                            level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                        }
                    }
                } else {
                    BlockPos belowPos = pos.below();
                    BlockState belowState = level.getBlockState(belowPos);
                    if (Helpers.isBlock(belowState, Blocks.SNOW_BLOCK)) {
                        coolAmount = 75.0f;
                        if (level.random.nextFloat() < 0.1f) {
                            level.destroyBlock(belowPos, false);
                        }
                    } else if (belowState.getBlock() == Blocks.ICE || belowState.getBlock() == Blocks.FROSTED_ICE) {
                        coolAmount = 100.0f;
                        if (level.random.nextFloat() < 0.01f) {
                            level.setBlockAndUpdate(belowPos, Helpers.isBlock(belowState, (Block)TFCBlocks.SEA_ICE.get()) ? ((LiquidBlock)TFCBlocks.SALT_WATER.get()).defaultBlockState() : Blocks.WATER.defaultBlockState());
                        }
                    } else if (belowState.getBlock() == Blocks.PACKED_ICE || belowState.getBlock() == Blocks.BLUE_ICE) {
                        coolAmount = 125.0f;
                        if (level.random.nextFloat() < 0.005f) {
                            level.setBlockAndUpdate(belowPos, Blocks.WATER.defaultBlockState());
                        }
                    }
                }
                if (coolAmount > 0.0f) {
                    heat.setTemperature(Math.max(0.0f, heat.getTemperature() - coolAmount));
                    Helpers.playSound((Level)level, pos, (SoundEvent)TFCSounds.ITEM_COOL.get());
                    level.sendParticles((ParticleOptions)ParticleTypes.SMOKE, entity.getX(), entity.getY(), entity.getZ(), 1, 0.0, 0.0, 0.0, 1.0);
                }
                event.setExtraLife(heat.getTemperature() == 0.0f ? lifespan : TFCConfig.SERVER.ticksBeforeItemCool.get());
            } else {
                event.setExtraLife(lifespan);
            }
        }
    }

    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ForgeEventHandler.onNewPlayerInWorld(event.getEntity());
    }

    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        ForgeEventHandler.onNewPlayerInWorld(event.getEntity());
    }

    public static void onPlayerDeath(PlayerEvent.Clone event) {
        if (TFCConfig.SERVER.keepNutritionAfterDeath.get().booleanValue() && event.isWasDeath()) {
            IPlayerInfo.copyOnDeath(event.getOriginal(), event.getEntity());
        }
    }

    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        ForgeEventHandler.onNewPlayerInWorld(event.getEntity());
    }

    private static void onNewPlayerInWorld(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ClimateModel model = Climate.get(serverPlayer.level());
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new UpdateClimateModelPacket(model), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void onServerChat(ServerChatEvent event) {
        float intoxicationChance = Mth.clampedMap((float)IPlayerInfo.get((Player)event.getPlayer()).getIntoxication(), (float)0.2f, (float)1.0f, (float)0.0f, (float)0.7f);
        if (intoxicationChance > 0.0f) {
            RandomSource random = event.getPlayer().getRandom();
            String originalMessage = event.getMessage().getString();
            CharSequence[] words = originalMessage.split(" ");
            for (int i = 0; i < words.length; ++i) {
                int pos;
                Object word = words[i];
                if (((String)word).isEmpty()) continue;
                if (random.nextFloat() < intoxicationChance && ((String)word).length() >= 2) {
                    pos = random.nextInt(((String)word).length() - 1);
                    word = ((String)word).substring(0, pos) + ((String)word).charAt(pos + 1) + ((String)word).charAt(pos) + ((String)word).substring(pos + 2);
                }
                if (random.nextFloat() < intoxicationChance) {
                    pos = random.nextInt(((String)word).length());
                    char repeat = ((String)word).charAt(pos);
                    int amount = 1 + random.nextInt(3);
                    word = ((String)word).substring(0, pos) + new String(new char[amount]).replace('\u0000', repeat) + (pos + 1 < ((String)word).length() ? ((String)word).substring(pos + 1) : "");
                }
                if (random.nextFloat() < intoxicationChance) {
                    pos = random.nextInt(((String)word).length());
                    char replacement = ALPHABET.charAt(random.nextInt(ALPHABET.length()));
                    if (Character.isUpperCase(((String)word).charAt(random.nextInt(((String)word).length())))) {
                        replacement = Character.toUpperCase(replacement);
                    }
                    word = ((String)word).substring(0, pos) + replacement + (pos + 1 < ((String)word).length() ? ((String)word).substring(pos + 1) : "");
                }
                words[i] = word;
            }
            event.setMessage((Component)Component.literal((String)String.join((CharSequence)" ", words)));
        }
    }

    public static void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        PestContainer test;
        BaseContainerBlockEntity container;
        BlockEntity blockEntity;
        Level level = event.getLevel();
        BlockState state = level.getBlockState(event.getPos());
        ItemStack stack = event.getItemStack();
        if ((Helpers.isItem(stack, (ItemLike)Items.WRITABLE_BOOK) || Helpers.isItem(stack, (ItemLike)Items.WRITTEN_BOOK)) && state.getBlock() instanceof TFCLecternBlock && LecternBlock.tryPlaceBook((LivingEntity)event.getEntity(), (Level)level, (BlockPos)event.getPos(), (BlockState)state, (ItemStack)stack)) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide));
        }
        if ((blockEntity = level.getBlockEntity(event.getPos())) instanceof BaseContainerBlockEntity && (container = (BaseContainerBlockEntity)blockEntity).canOpen(event.getEntity()) && container instanceof PestContainer && (test = (PestContainer)container).canBeInfested()) {
            int infestation = 0;
            for (int i = 0; !(i >= container.getContainerSize() || Helpers.isItem(container.getItem(i), TFCTags.Items.FOODS) && ++infestation == 5); ++i) {
            }
            Helpers.tickInfestation(level, container.getBlockPos(), infestation, event.getEntity());
        }
    }

    public static void onPlayerRightClickBlockLowestPriority(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        BlockState state = level.getBlockState(event.getPos());
        ItemStack stack = event.getItemStack();
        if (!event.isCanceled() && event.getHand() == InteractionHand.MAIN_HAND && stack.isEmpty()) {
            ItemInteractionResult useBlockResult = state.useItemOn(stack, level, event.getEntity(), event.getHand(), event.getHitVec());
            if (useBlockResult.consumesAction()) {
                Player player = event.getEntity();
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, event.getPos(), stack);
                }
                event.setCanceled(true);
                event.setCancellationResult(useBlockResult.result());
            } else {
                InteractionResult result = Drinkable.attemptDrink(level, event.getEntity(), true);
                if (result != InteractionResult.PASS) {
                    event.setCanceled(true);
                    event.setCancellationResult(result);
                }
            }
        }
        if (state.getBlock() instanceof AnvilBlock || state.getBlock() instanceof RockAnvilBlock || Fertilizer.get(stack) != null || state.getBlock() instanceof BarrelBlock && !((Boolean)state.getValue((Property)BarrelBlock.RACK)).booleanValue() && ((Direction)state.getValue(BarrelBlock.FACING)).getAxis().isHorizontal() && stack.getItem() == ((Block)TFCBlocks.BARREL_RACK.get()).asItem()) {
            event.setUseBlock(TriState.TRUE);
        }
    }

    public static void onPlayerRightClickItem(PlayerInteractEvent.RightClickItem event) {
        UseOnContext context = new UseOnContext(event.getEntity(), event.getHand(), FAKE_MISS);
        InteractionManager.onItemUse(event.getItemStack(), context, true).ifPresent(result -> {
            event.setCanceled(true);
            event.setCancellationResult(result);
        });
    }

    public static void onPlayerRightClickEmpty(PlayerInteractEvent.RightClickEmpty event) {
        if (event.getHand() == InteractionHand.MAIN_HAND && event.getItemStack().isEmpty()) {
            Player player = event.getEntity();
            InteractionResult result = Drinkable.attemptDrink(event.getLevel(), player, false);
            if (result.consumesAction()) {
                player.swing(InteractionHand.MAIN_HAND);
                PacketDistributor.sendToServer((CustomPacketPayload)PlayerDrinkPacket.PACKET, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static void onUseItemOnBlock(UseItemOnBlockEvent event) {
        if (event.getUsePhase() == UseItemOnBlockEvent.UsePhase.ITEM_AFTER_BLOCK) {
            InteractionManager.onItemUse(event.getItemStack(), event.getUseOnContext(), false).ifPresent(result -> event.cancelWithResult(switch (result) {
                default -> throw new MatchException(null, null);
                case InteractionResult.SUCCESS, InteractionResult.SUCCESS_NO_ITEM_USED -> ItemInteractionResult.SUCCESS;
                case InteractionResult.CONSUME, InteractionResult.CONSUME_PARTIAL -> ItemInteractionResult.CONSUME;
                case InteractionResult.PASS -> ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
                case InteractionResult.FAIL -> ItemInteractionResult.FAIL;
            }));
        }
    }

    public static void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        ItemStack stack = event.getItem();
        @Nullable ItemComponent bowl = (ItemComponent)stack.get(TFCComponents.BOWL);
        if (bowl != null) {
            event.setResultStack(Bowl.onItemUse(bowl, stack, event.getResultStack(), event.getEntity()));
        }
    }

    public static void addReloadListeners(AddReloadListenerEvent event) {
        DataManagers.REGISTRY.forEach(arg_0 -> ((AddReloadListenerEvent)event).addListener(arg_0));
        Helpers.setCachedRecipeManager(event.getServerResources().getRecipeManager());
    }

    public static void onDataPackSync(OnDatapackSyncEvent event) {
        if (event.getPlayer() == null) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new DataManagerSyncPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            PacketDistributor.sendToPlayer((ServerPlayer)event.getPlayer(), (CustomPacketPayload)new DataManagerSyncPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void onTagsUpdated(TagsUpdatedEvent event) {
        if (event.shouldUpdateStaticData() && event.getUpdateCause() == TagsUpdatedEvent.UpdateCause.SERVER_DATA_LOAD) {
            Helpers.updateReloadableData(event.getRegistryAccess(), Helpers.getUnsafeRecipeManager());
        }
    }

    public static void onBoneMeal(BonemealEvent event) {
        if (!TFCConfig.SERVER.enableVanillaBonemeal.get().booleanValue()) {
            event.setCanceled(true);
        }
    }

    public static void onSelectClimateModel(SelectClimateModelEvent event) {
        ChunkGenerator chunkGenerator;
        ServerLevel level = event.level();
        if (event.level().dimension() == Level.OVERWORLD && (chunkGenerator = level.getChunkSource().getGenerator()) instanceof ChunkGeneratorExtension) {
            ChunkGeneratorExtension ex = (ChunkGeneratorExtension)chunkGenerator;
            event.setModel(new OverworldClimateModel(level, ex));
        }
    }

    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Entity entity;
        Player player = event.getEntity();
        if (event.getTarget().getType() == EntityType.MINECART && (entity = event.getTarget()) instanceof Minecart) {
            ItemStack held;
            Minecart oldCart = (Minecart)entity;
            if (player.isShiftKeyDown() && player.isSecondaryUseActive() && Helpers.isItem(held = player.getItemInHand(event.getHand()), TFCTags.Items.MINECART_HOLDABLE)) {
                ItemStack holdingItem;
                if (player.isCreative()) {
                    holdingItem = held.copy();
                    holdingItem.setCount(1);
                } else {
                    holdingItem = held.split(1);
                }
                if (!player.level().isClientSide) {
                    HoldingMinecart minecart = new HoldingMinecart(player.level(), oldCart.getX(), oldCart.getY(), oldCart.getZ());
                    HoldingMinecart.copyMinecart((AbstractMinecart)oldCart, minecart);
                    minecart.setHoldItem(holdingItem);
                    oldCart.discard();
                    player.level().addFreshEntity((Entity)minecart);
                }
                event.setCancellationResult(InteractionResult.sidedSuccess((boolean)player.level().isClientSide));
            }
        }
    }

    public static void onMount(EntityMountEvent event) {
        if (event.getEntityBeingMounted() instanceof Boat && event.getEntityMounting() instanceof Predator) {
            event.setCanceled(true);
        }
    }

    public static void onAnimalTame(AnimalTameEvent event) {
        if (Helpers.isEntity((Entity)event.getEntity(), TFCTags.Entities.HORSES)) {
            event.setCanceled(true);
        }
    }

    public static void onContainerOpen(PlayerContainerEvent.Open event) {
        AbstractContainerMenu abstractContainerMenu = event.getContainer();
        if (abstractContainerMenu instanceof BlockEntityContainer) {
            PestContainer test;
            BlockEntityContainer container = (BlockEntityContainer)abstractContainerMenu;
            abstractContainerMenu = event.getContainer();
            if (abstractContainerMenu instanceof PestContainer && (test = (PestContainer)abstractContainerMenu).canBeInfested()) {
                Player player = event.getEntity();
                Level level = player.level();
                if (level.isClientSide) {
                    return;
                }
                int amount = 0;
                if (TFCConfig.SERVER.enableInfestations.get().booleanValue()) {
                    for (Slot slot : container.slots) {
                        if (container.typeOf(slot.index) != Container.IndexType.CONTAINER || !Helpers.isItem(slot.getItem(), TFCTags.Items.FOODS) || ++amount != 5) continue;
                        break;
                    }
                }
                Helpers.tickInfestation(level, container.getBlockEntity().getBlockPos(), amount, player);
            }
        }
    }

    public static void onCropsGrow(CropGrowEvent.Pre event) {
        BlockState state = event.getState();
        LevelAccessor level = event.getLevel();
        if (state.getBlock() instanceof BambooStalkBlock && level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if ((double)server.random.nextFloat() > TFCConfig.SERVER.plantLongGrowthChance.get()) {
                event.setResult(CropGrowEvent.Pre.Result.DO_NOT_GROW);
            }
        }
    }
}

