/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client;

import java.util.Objects;
import net.dries007.tfc.common.component.EggComponent;
import net.dries007.tfc.common.component.TFCComponents;
import net.dries007.tfc.common.component.heat.Heat;
import net.dries007.tfc.common.component.heat.HeatCapability;
import net.dries007.tfc.common.component.heat.IHeat;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegistryBuilder;
import org.jetbrains.annotations.Nullable;

public final class BarSystem {
    public static final ResourceKey<Registry<Bar>> KEY = ResourceKey.createRegistryKey((ResourceLocation)Helpers.identifier("bars"));
    public static final Registry<Bar> REGISTRY = new RegistryBuilder(KEY).sync(true).create();
    public static final DeferredRegister<Bar> BARS = DeferredRegister.create(KEY, (String)"tfc");
    public static final DeferredHolder<Bar, Bar> HEAT = BarSystem.register("heat", new Bar(){

        @Override
        public int getBarColor(ItemStack stack) {
            Heat heat;
            @Nullable IHeat cap = HeatCapability.get(stack);
            if (cap != null && cap.getTemperature() > 0.0f && (heat = Heat.getHeat(cap.getTemperature())) != null) {
                return Objects.requireNonNull(heat.getColor().getColor());
            }
            return 0;
        }

        @Override
        public boolean isBarVisible(ItemStack stack) {
            return TFCConfig.CLIENT.displayItemHeatBars.get() != false && HeatCapability.isHot(stack);
        }

        @Override
        public int getBarWidth(ItemStack stack) {
            @Nullable IHeat cap = HeatCapability.get(stack);
            if (cap != null) {
                HeatingRecipe recipe = HeatingRecipe.getRecipe(stack);
                if (recipe != null) {
                    return Mth.clamp((int)Math.round(13.0f * cap.getTemperature() / recipe.getTemperature()), (int)1, (int)13);
                }
                return Mth.clamp((int)Math.round(13.0f * cap.getTemperature() / Heat.maxVisibleTemperature()), (int)1, (int)13);
            }
            return 0;
        }

        @Override
        public ItemStack createDefaultItem(ItemStack stack) {
            HeatCapability.setTemperature(stack, 0.0f);
            return stack;
        }
    });
    public static final DeferredHolder<Bar, Bar> EGG = BarSystem.register("egg", new Bar(){

        @Override
        public int getBarColor(ItemStack stack) {
            return Objects.requireNonNull(ChatFormatting.GOLD.getColor());
        }

        @Override
        public boolean isBarVisible(ItemStack stack) {
            @Nullable EggComponent egg = (EggComponent)stack.get(TFCComponents.EGG);
            return egg != null && egg.fertilized();
        }

        @Override
        public int getBarWidth(ItemStack stack) {
            int maxDays = 8;
            @Nullable EggComponent egg = (EggComponent)stack.get(TFCComponents.EGG);
            if (egg != null) {
                int incubationDays = 8 - Mth.clamp((int)((int)(egg.hatchDay() - Calendars.CLIENT.getTotalDays())), (int)0, (int)8);
                return Math.round(13.0f * (float)incubationDays / 8.0f);
            }
            return 0;
        }

        @Override
        public ItemStack createDefaultItem(ItemStack stack) {
            stack.remove(TFCComponents.EGG);
            return stack;
        }
    });

    private static DeferredHolder<Bar, Bar> register(String name, Bar bar) {
        return BARS.register(name, () -> bar);
    }

    @Nullable
    public static Bar getCustomBar(ItemStack stack) {
        if (stack.isEmpty()) {
            return null;
        }
        for (Bar bar : REGISTRY) {
            if (!bar.isBarVisible(stack) || !bar.overridesOtherBars() && bar.createDefaultItem(stack.copy()).isBarVisible()) continue;
            return bar;
        }
        return null;
    }

    public static interface Bar {
        public static final int WIDTH = 13;

        public int getBarColor(ItemStack var1);

        public boolean isBarVisible(ItemStack var1);

        public int getBarWidth(ItemStack var1);

        public ItemStack createDefaultItem(ItemStack var1);

        default public boolean overridesOtherBars() {
            return false;
        }
    }
}

