/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client;

import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.climate.ClimateModel;
import net.dries007.tfc.util.tracker.WeatherHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec2;

public enum ClimateRenderCache {
    INSTANCE;

    private float hemisphereScale;
    private float averageSeaLevelTemperature;
    private float averageTemperature;
    private float temperature;
    private float averageRainfall;
    private float rainVariance;
    private float rainfall;
    private float baseGroundwater;
    private float averageGroundwater;
    private float groundwater;
    private Vec2 wind = Vec2.ZERO;
    private float lastRainLevel;
    private float currRainLevel;

    public void onClientTick() {
        Level level = ClientHelpers.getLevel();
        Player player = ClientHelpers.getPlayer();
        if (level != null && player != null) {
            BlockPos pos = player.blockPosition();
            BlockPos seaLevelPos = pos.atY(63);
            ClimateModel model = Climate.get(level);
            this.averageSeaLevelTemperature = model.getAverageTemperature((LevelReader)level, seaLevelPos);
            this.averageTemperature = model.getAverageTemperature((LevelReader)level, pos);
            this.temperature = model.getTemperature((LevelReader)level, pos);
            this.averageRainfall = model.getAverageRainfall((LevelReader)level, pos);
            this.rainVariance = model.getRainfallVariance((LevelReader)level, pos);
            this.rainfall = model.getRainfall((LevelReader)level, pos);
            this.baseGroundwater = model.getBaseGroundwater((LevelReader)level, pos);
            this.averageGroundwater = model.getAverageGroundwater((LevelReader)level, pos);
            this.groundwater = model.getGroundwater((LevelReader)level, pos);
            this.wind = model.getWind(level, pos);
            this.hemisphereScale = model.hemisphereScale();
            if (model.supportsRain()) {
                boolean isRaining = WeatherHelpers.isPrecipitating(model.getRain(Calendars.CLIENT.getCalendarTicks()), this.rainfall);
                this.lastRainLevel = this.currRainLevel;
                this.currRainLevel = Mth.clamp((float)(this.currRainLevel + (isRaining ? 0.01f : -0.01f)), (float)0.0f, (float)1.0f);
            } else {
                this.lastRainLevel = level.oRainLevel;
                this.currRainLevel = level.rainLevel;
            }
        }
    }

    public float getAverageSeaLevelTemperature() {
        return this.averageSeaLevelTemperature;
    }

    public float getAverageTemperature() {
        return this.averageTemperature;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public float getRainfall() {
        return this.rainfall;
    }

    public float getAverageRainfall() {
        return this.averageRainfall;
    }

    public float getRainVariance() {
        return this.rainVariance;
    }

    public float getRainLevel(float partialTick) {
        return Mth.lerp((float)partialTick, (float)this.lastRainLevel, (float)this.currRainLevel);
    }

    public float getBaseGroundwater() {
        return this.baseGroundwater;
    }

    public float getAverageGroundwater() {
        return this.averageGroundwater;
    }

    public float getGroundwater() {
        return this.groundwater;
    }

    public float getHemisphereScale() {
        return this.hemisphereScale;
    }

    public Vec2 getWind() {
        return this.wind;
    }
}

