/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client;

import java.util.ArrayList;
import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.common.blocks.soil.HoeOverlayBlock;
import net.dries007.tfc.config.TFCConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class HoeOverlays {
    public static boolean render(Minecraft minecraft, GuiGraphics graphics) {
        BlockState targetedState;
        Block block;
        ClientLevel world = minecraft.level;
        BlockPos targetedPos = ClientHelpers.getTargetedPos();
        if (world != null && targetedPos != null && (block = (targetedState = world.getBlockState(targetedPos)).getBlock()) instanceof HoeOverlayBlock) {
            HoeOverlayBlock overlayBlock = (HoeOverlayBlock)block;
            ArrayList lines = new ArrayList();
            overlayBlock.addHoeOverlayInfo((Level)world, targetedPos, targetedState, lines::add, TFCConfig.CLIENT.enableDebug.get());
            if (!lines.isEmpty()) {
                int x = graphics.guiWidth() / 2 + 3;
                int y = graphics.guiHeight() / 2 + 8;
                for (Component line : lines) {
                    HoeOverlays.drawCenteredText(minecraft, graphics, line, x, y);
                    y += 12;
                }
            }
            return true;
        }
        return false;
    }

    private static void drawCenteredText(Minecraft minecraft, GuiGraphics graphics, Component text, int x, int y) {
        int textWidth = minecraft.font.width((FormattedText)text) / 2;
        graphics.drawString(minecraft.font, text, x - textWidth, y, 0xCCCCCC, true);
    }
}

