/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.Locale;
import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.effect.TFCEffects;
import net.dries007.tfc.common.entities.livestock.Age;
import net.dries007.tfc.common.entities.livestock.MammalProperties;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.common.entities.misc.TFCFishingHook;
import net.dries007.tfc.common.player.IPlayerInfo;
import net.dries007.tfc.config.DisabledExperienceBarStyle;
import net.dries007.tfc.config.HealthDisplayStyle;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import org.jetbrains.annotations.Nullable;

public final class IngameOverlays
extends Enum<IngameOverlays> {
    public static final /* enum */ IngameOverlays HEALTH = new IngameOverlays(IngameOverlays::renderHealth);
    public static final /* enum */ IngameOverlays MOUNT_HEALTH = new IngameOverlays(IngameOverlays::renderMountHealth);
    public static final /* enum */ IngameOverlays FOOD = new IngameOverlays(IngameOverlays::renderFood);
    public static final /* enum */ IngameOverlays THIRST = new IngameOverlays(IngameOverlays::renderThirst);
    public static final /* enum */ IngameOverlays INK = new IngameOverlays(IngameOverlays::renderInk);
    public static final /* enum */ IngameOverlays CHISEL = new IngameOverlays(IngameOverlays::renderChiselMode);
    public static final /* enum */ IngameOverlays EXPERIENCE = new IngameOverlays(IngameOverlays::renderExperience);
    public static final /* enum */ IngameOverlays JUMP_BAR = new IngameOverlays(IngameOverlays::renderJumpBar);
    public static final /* enum */ IngameOverlays HUD_MOVER = new IngameOverlays(IngameOverlays::moveLeftAndRightHeights);
    public static final /* enum */ IngameOverlays FAMILIARITY = new IngameOverlays(IngameOverlays::renderFamiliarity);
    private final ResourceLocation id = Helpers.resourceLocation(this.name().toLowerCase(Locale.ROOT));
    final LayeredDraw.Layer overlay;
    public static final ResourceLocation TEXTURE;
    public static final ResourceLocation INK_TEXTURE;
    public static final ResourceLocation GLOW_INK_TEXTURE;
    static final int HEALTH_TEXT_SHADOW_COLOR;
    private static final ResourceLocation VANILLA_HEALTH;
    private static final ResourceLocation VANILLA_MOUNT_HEALTH;
    private static final ResourceLocation VANILLA_FOOD;
    private static final ResourceLocation VANILLA_EXP;
    private static final ResourceLocation VANILLA_EXP_LEVEL;
    private static final ResourceLocation VANILLA_JUMP;
    private static final /* synthetic */ IngameOverlays[] $VALUES;

    public static IngameOverlays[] values() {
        return (IngameOverlays[])$VALUES.clone();
    }

    public static IngameOverlays valueOf(String name) {
        return Enum.valueOf(IngameOverlays.class, name);
    }

    private IngameOverlays(LayeredDraw.Layer overlay) {
        this.overlay = overlay;
    }

    public static void registerOverlays(RegisterGuiLayersEvent event) {
        IngameOverlays.above(event, VanillaGuiLayers.PLAYER_HEALTH, HEALTH);
        IngameOverlays.above(event, VanillaGuiLayers.VEHICLE_HEALTH, MOUNT_HEALTH);
        IngameOverlays.above(event, VanillaGuiLayers.FOOD_LEVEL, FOOD);
        IngameOverlays.above(event, VanillaGuiLayers.FOOD_LEVEL, THIRST);
        IngameOverlays.above(event, VanillaGuiLayers.EXPERIENCE_BAR, EXPERIENCE);
        IngameOverlays.above(event, VanillaGuiLayers.JUMP_METER, JUMP_BAR);
        IngameOverlays.above(event, VanillaGuiLayers.PLAYER_HEALTH, HUD_MOVER);
        IngameOverlays.above(event, VanillaGuiLayers.CROSSHAIR, FAMILIARITY);
        IngameOverlays.top(event, INK);
        IngameOverlays.top(event, CHISEL);
    }

    private static void above(RegisterGuiLayersEvent event, ResourceLocation vanilla, IngameOverlays overlay) {
        event.registerAbove(vanilla, overlay.id, overlay.overlay);
    }

    private static void top(RegisterGuiLayersEvent event, IngameOverlays overlay) {
        event.registerAboveAll(overlay.id, overlay.overlay);
    }

    public static void checkGuiOverlays(RenderGuiLayerEvent.Pre event) {
        ResourceLocation id = event.getName();
        if (IngameOverlays.enableThisOrThat(id, TFCConfig.CLIENT.enableHungerBar.get(), IngameOverlays.FOOD.id, VANILLA_FOOD) || IngameOverlays.enableThisOrThat(id, TFCConfig.CLIENT.enableHealthBar.get(), IngameOverlays.HEALTH.id, VANILLA_HEALTH) || IngameOverlays.enableThisOrThat(id, TFCConfig.CLIENT.enableHealthBar.get(), IngameOverlays.MOUNT_HEALTH.id, VANILLA_MOUNT_HEALTH)) {
            event.setCanceled(true);
        } else if (IngameOverlays.disableIfFalse(id, TFCConfig.CLIENT.enableThirstBar.get(), IngameOverlays.THIRST.id) || IngameOverlays.disableIfFalse(id, TFCConfig.CLIENT.enableInkSplatter.get(), IngameOverlays.INK.id)) {
            event.setCanceled(true);
        }
        if (!TFCConfig.CLIENT.enableExperienceBar.get().booleanValue() && (id.equals((Object)VANILLA_EXP) || id.equals((Object)VANILLA_JUMP) || id.equals((Object)VANILLA_EXP_LEVEL))) {
            event.setCanceled(true);
        }
    }

    private static boolean enableThisOrThat(ResourceLocation id, boolean config, ResourceLocation myOverlay, ResourceLocation vanillaOverlay) {
        return config && id.equals((Object)vanillaOverlay) || !config && id.equals((Object)myOverlay);
    }

    private static boolean disableIfFalse(ResourceLocation id, boolean config, ResourceLocation myOverlay) {
        return id.equals((Object)myOverlay) && !config;
    }

    public static void renderHealth(GuiGraphics graphics, DeltaTracker delta) {
        Minecraft minecraft = Minecraft.getInstance();
        if (IngameOverlays.setupForSurvival(graphics, minecraft)) {
            Player player = (Player)minecraft.getCameraEntity();
            assert (player != null);
            IngameOverlays.renderHealthBar((LivingEntity)player, Minecraft.getInstance().gui, graphics, graphics.guiWidth(), graphics.guiHeight());
        }
    }

    public static void renderMountHealth(GuiGraphics graphics, DeltaTracker delta) {
        Minecraft minecraft = Minecraft.getInstance();
        if (IngameOverlays.setupForSurvival(graphics, minecraft)) {
            Player player = (Player)minecraft.getCameraEntity();
            assert (player != null);
            Entity entity = player.getVehicle();
            if (entity instanceof LivingEntity) {
                LivingEntity entity2 = (LivingEntity)entity;
                IngameOverlays.renderHealthBar(entity2, Minecraft.getInstance().gui, graphics, graphics.guiWidth(), graphics.guiHeight());
            }
        }
    }

    public static void renderFood(GuiGraphics graphics, DeltaTracker delta) {
        Gui gui = Minecraft.getInstance().gui;
        PoseStack stack = graphics.pose();
        Minecraft minecraft = Minecraft.getInstance();
        if (IngameOverlays.setupForSurvival(graphics, minecraft)) {
            Player player = (Player)minecraft.getCameraEntity();
            assert (player != null);
            int x = graphics.guiWidth() / 2;
            int y = graphics.guiHeight() - gui.rightHeight;
            float percentFood = (float)player.getFoodData().getFoodLevel() / 20.0f;
            stack.pushPose();
            stack.translate((float)(x + 10), (float)(y + 4), 0.0f);
            graphics.blit(TEXTURE, 0, 0, 0, 19, 81, 5);
            graphics.blit(TEXTURE, 0, 0, 0, 24, (int)(81.0f * percentFood), 5);
            stack.popPose();
            gui.rightHeight += 6;
        }
    }

    public static void renderThirst(GuiGraphics graphics, DeltaTracker delta) {
        Gui gui = Minecraft.getInstance().gui;
        PoseStack stack = graphics.pose();
        Minecraft minecraft = Minecraft.getInstance();
        if (IngameOverlays.setupForSurvival(graphics, minecraft)) {
            Player player = (Player)minecraft.getCameraEntity();
            assert (player != null);
            IPlayerInfo info = IPlayerInfo.get(player);
            int x = graphics.guiWidth() / 2;
            int y = graphics.guiHeight() - gui.rightHeight;
            float percentThirst = info.getThirst() / 100.0f;
            float overheat = info.getThirstContributionFromTemperature();
            stack.pushPose();
            stack.translate((float)(x + 10), (float)(y + 4), 0.0f);
            graphics.blit(TEXTURE, 0, 0, 90, 19, 81, 5);
            graphics.blit(TEXTURE, 0, 0, 90, 24, (int)(81.0f * percentThirst), 5);
            if (overheat > 0.0f) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(overheat / 0.4f));
                graphics.blit(TEXTURE, 0, 0, 90, 29, 81, 5);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            stack.popPose();
            gui.rightHeight += 6;
        }
    }

    private static void renderChiselMode(GuiGraphics graphics, DeltaTracker delta) {
        Player player;
        PoseStack stack = graphics.pose();
        Minecraft mc = Minecraft.getInstance();
        if (IngameOverlays.setup(graphics, mc) && (player = ClientHelpers.getPlayer()) != null && Helpers.isItem(player.getItemInHand(InteractionHand.MAIN_HAND), TFCTags.Items.TOOLS_CHISEL)) {
            stack.pushPose();
            if (!Helpers.isItem(player.getItemInHand(InteractionHand.OFF_HAND), TFCTags.Items.TOOLS_HAMMER)) {
                graphics.blit(TEXTURE, graphics.guiWidth() / 2 + 100, graphics.guiHeight() - 21, 60, 58, 20, 20);
            } else {
                IPlayerInfo.get(player).chiselMode().createHotbarIcon((texture, u, v) -> graphics.blit(texture, graphics.guiWidth() / 2 + 100, graphics.guiHeight() - 21, u, v, 20, 20));
            }
            stack.popPose();
        }
    }

    private static void renderExperience(GuiGraphics graphics, DeltaTracker delta) {
        FishingHook fishingHook;
        boolean isStyleLeftHotbar;
        Minecraft mc = Minecraft.getInstance();
        @Nullable LocalPlayer localPlayer = mc.player;
        boolean isShowingExperience = TFCConfig.CLIENT.enableExperienceBar.get();
        boolean bl = isStyleLeftHotbar = TFCConfig.CLIENT.disabledExperienceBarStyle.get() == DisabledExperienceBarStyle.LEFT_HOTBAR;
        if (localPlayer != null && (fishingHook = localPlayer.fishing) instanceof TFCFishingHook) {
            TFCFishingHook hook = (TFCFishingHook)fishingHook;
            if (IngameOverlays.setup(graphics, mc)) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
                if (!isShowingExperience && isStyleLeftHotbar) {
                    int uOffset;
                    int barHeight;
                    if (localPlayer.getVehicle() instanceof LivingEntity && TFCConfig.CLIENT.enableHealthBar.get().booleanValue()) {
                        barHeight = 42;
                        uOffset = 164;
                    } else {
                        barHeight = 32;
                        uOffset = 153;
                    }
                    int x = graphics.guiWidth() / 2 - 97;
                    int y = graphics.guiHeight() - barHeight;
                    int texturePos = 36 + barHeight;
                    int amount = Mth.ceil((float)Mth.clampedMap((float)hook.pullExhaustion, (float)0.0f, (float)100.0f, (float)0.0f, (float)(barHeight + 1)));
                    graphics.blit(TEXTURE, x, y, uOffset, 36, 5, barHeight);
                    if (amount > 0) {
                        graphics.blit(TEXTURE, x, graphics.guiHeight() - amount, uOffset + 5, texturePos - amount, 5, amount);
                    }
                } else {
                    int x = graphics.guiWidth() / 2 - 91;
                    int y = graphics.guiHeight() - 29;
                    int amount = Mth.ceil((float)Mth.clampedMap((float)hook.pullExhaustion, (float)0.0f, (float)100.0f, (float)0.0f, (float)183.0f));
                    graphics.blit(TEXTURE, x, y, 0, 111, 182, 5);
                    if (amount > 0) {
                        graphics.blit(TEXTURE, x, y, 0, 116, amount, 5);
                    }
                }
                RenderSystem.enableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    private static void renderJumpBar(GuiGraphics graphics, DeltaTracker delta) {
        boolean isStyleLeftHotbar;
        PoseStack stack = graphics.pose();
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer localPlayer = mc.player;
        boolean isShowingExperience = TFCConfig.CLIENT.enableExperienceBar.get();
        boolean bl = isStyleLeftHotbar = TFCConfig.CLIENT.disabledExperienceBarStyle.get() == DisabledExperienceBarStyle.LEFT_HOTBAR;
        if (isShowingExperience || !isStyleLeftHotbar) {
            return;
        }
        if (localPlayer != null && localPlayer.jumpableVehicle() != null && IngameOverlays.setup(graphics, mc)) {
            int uOffset;
            int barHeight;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            if (TFCConfig.CLIENT.enableHealthBar.get().booleanValue()) {
                barHeight = 42;
                uOffset = 186;
            } else {
                barHeight = 32;
                uOffset = 175;
            }
            int x = graphics.guiWidth() / 2 - 97;
            int y = graphics.guiHeight() - barHeight;
            int texturePos = 36 + barHeight;
            int charge = (int)(localPlayer.getJumpRidingScale() * (float)(barHeight + 1));
            graphics.blit(TEXTURE, x, y, uOffset, 36, 5, barHeight);
            if (charge > 0) {
                graphics.blit(TEXTURE, x, graphics.guiHeight() - charge, uOffset + 5, texturePos - charge, 5, charge);
            }
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private static void renderInk(GuiGraphics graphics, DeltaTracker delta) {
        LocalPlayer player;
        if (Minecraft.getInstance().options.getCameraType().isFirstPerson() && (player = Minecraft.getInstance().player) != null) {
            if (player.hasEffect(TFCEffects.INK.holder())) {
                IngameOverlays.renderTextureOverlay(graphics, INK_TEXTURE, 1.0f);
            } else if (player.hasEffect(TFCEffects.GLOW_INK.holder())) {
                IngameOverlays.renderTextureOverlay(graphics, GLOW_INK_TEXTURE, 1.0f);
            }
        }
    }

    private static void renderHealthBar(LivingEntity entity, Gui gui, GuiGraphics graphics, int width, int height) {
        float f;
        float surplusPercent;
        Player player;
        boolean playerHasSaturation;
        PoseStack stack = graphics.pose();
        HealthDisplayStyle style = TFCConfig.CLIENT.healthDisplayStyle.get();
        float maxHealth = entity.getMaxHealth();
        int centerX = graphics.guiWidth() / 2;
        int y = height - gui.leftHeight;
        stack.pushPose();
        stack.translate((float)(centerX - 91), (float)y, 0.0f);
        graphics.blit(TEXTURE, 0, 0, 0, 0, 81, 9);
        float absorption = entity.getAbsorptionAmount();
        absorption = Float.isNaN(absorption) ? 0.0f : absorption;
        float percentHealth = (entity.getHealth() + absorption) / entity.getMaxHealth();
        float currentHealth = percentHealth * maxHealth;
        percentHealth = Mth.clamp((float)percentHealth, (float)0.0f, (float)1.0f);
        graphics.blit(TEXTURE, 0, 0, 0, 9, (int)(81.0f * percentHealth), 9);
        boolean isHurt = entity.getHealth() > 0.0f && entity.getHealth() < entity.getMaxHealth();
        boolean bl = playerHasSaturation = entity instanceof Player && (player = (Player)entity).getFoodData().getSaturationLevel() > 0.0f;
        if (playerHasSaturation && isHurt || entity.hurtTime > 0 || entity.hasEffect(MobEffects.REGENERATION)) {
            graphics.blit(TEXTURE, 0, 0, 0, 29, 81, 9);
        }
        if ((surplusPercent = Mth.clamp((float)(percentHealth + absorption / 20.0f - 1.0f), (float)0.0f, (float)1.0f)) > 0.0f) {
            float percent = Math.min(surplusPercent, 1.0f);
            graphics.blit(TEXTURE, 0, 0, 90, 9, (int)(81.0f * percent), 9);
        }
        stack.popPose();
        if (entity instanceof Player) {
            Player player2 = (Player)entity;
            f = IPlayerInfo.get(player2).getHealthModifier();
        } else {
            f = 1.0f;
        }
        float healthModifier = f;
        String text = style.format(currentHealth * healthModifier, maxHealth * healthModifier);
        stack.pushPose();
        stack.translate((float)(centerX - 50), (float)y, 0.0f);
        stack.scale(1.0f, 1.0f, 1.0f);
        graphics.drawString(gui.getFont(), text, -1 * gui.getFont().width(text) / 2 + 1, 1, HEALTH_TEXT_SHADOW_COLOR, false);
        graphics.drawString(gui.getFont(), text, -1 * gui.getFont().width(text) / 2, 1, Color.WHITE.getRGB(), false);
        stack.popPose();
        gui.leftHeight += 10;
    }

    private static void renderFamiliarity(GuiGraphics graphics, DeltaTracker delta) {
        TFCAnimalProperties animal;
        Entity entity;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        LocalPlayer player = mc.player;
        if (player.isShiftKeyDown() && IngameOverlays.setup(graphics, mc) && (entity = mc.crosshairPickEntity) instanceof TFCAnimalProperties && (animal = (TFCAnimalProperties)entity).getAdultFamiliarityCap() > 0.0f && player.closerThan(entity, 5.0)) {
            MammalProperties mammal;
            int fontColor;
            int u;
            PoseStack stack = graphics.pose();
            stack.pushPose();
            stack.translate((float)graphics.guiWidth() / 2.0f, (float)graphics.guiHeight() / 2.0f - 45.0f, 0.0f);
            stack.scale(1.5f, 1.5f, 1.5f);
            float familiarity = Math.max(0.0f, Math.min(1.0f, animal.getFamiliarity()));
            if (familiarity >= animal.getAdultFamiliarityCap() && animal.getAgeType() != Age.CHILD) {
                u = 132;
                fontColor = Color.RED.getRGB();
            } else if (familiarity >= 0.3f) {
                u = 112;
                fontColor = Color.WHITE.getRGB();
            } else {
                u = 92;
                fontColor = Color.GRAY.getRGB();
            }
            if (TFCConfig.CLIENT.displayFamiliarityAsPercent.get().booleanValue()) {
                String string = String.format("%.2f", Float.valueOf(familiarity * 100.0f));
                graphics.drawString(mc.font, string, -mc.font.width(string) / 2, 0, fontColor, false);
            } else {
                graphics.blit(TEXTURE, -8, 0, u, 40, 16, 16);
                stack.translate(0.0f, 0.0f, 0.001f);
                graphics.blit(TEXTURE, -6, 14 - (int)(12.0f * familiarity), familiarity == 1.0f ? 114 : 94, 74 - (int)(12.0f * familiarity), 12, (int)(12.0f * familiarity));
            }
            if (animal instanceof MammalProperties && (mammal = (MammalProperties)animal).getPregnantTime() > 0L && mammal.isFertilized()) {
                stack.translate(0.0f, -15.0f, 0.0f);
                String string = Component.translatable((String)"tfc.tooltip.animal.pregnant", (Object[])new Object[]{entity.getName().getString()}).getString();
                graphics.drawString(mc.font, string, -mc.font.width(string) / 2, 0, Color.WHITE.getRGB(), false);
            }
            stack.popPose();
        }
    }

    private static void renderTextureOverlay(GuiGraphics graphics, ResourceLocation location, float alpha) {
        Minecraft mc = Minecraft.getInstance();
        int screenWidth = mc.getWindow().getGuiScaledWidth();
        int screenHeight = mc.getWindow().getGuiScaledHeight();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        graphics.setColor(1.0f, 1.0f, 1.0f, alpha);
        graphics.blit(location, 0, 0, -90, 0.0f, 0.0f, screenWidth, screenHeight, screenWidth, screenHeight);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private static void moveLeftAndRightHeights(GuiGraphics graphics, DeltaTracker delta) {
        Gui gui = Minecraft.getInstance().gui;
        gui.rightHeight -= IngameOverlays.considerExperienceConfigs();
        gui.leftHeight -= IngameOverlays.considerExperienceConfigs();
    }

    private static boolean setupForSurvival(GuiGraphics gui, Minecraft minecraft) {
        MultiPlayerGameMode gm = Minecraft.getInstance().gameMode;
        return gm != null && gm.canHurtPlayer() && IngameOverlays.setup(gui, minecraft);
    }

    public static boolean setup(GuiGraphics gui, Minecraft minecraft) {
        return !minecraft.options.hideGui && minecraft.getCameraEntity() instanceof Player;
    }

    private static int considerExperienceConfigs() {
        LocalPlayer player = Minecraft.getInstance().player;
        return switch (TFCConfig.CLIENT.disabledExperienceBarStyle.get()) {
            case DisabledExperienceBarStyle.LEFT_HOTBAR -> 6;
            case DisabledExperienceBarStyle.BUMP -> {
                if (player != null && (player.fishing instanceof TFCFishingHook || player.jumpableVehicle() != null)) {
                    yield 0;
                }
                yield 6;
            }
            default -> 0;
        };
    }

    private static /* synthetic */ IngameOverlays[] $values() {
        return new IngameOverlays[]{HEALTH, MOUNT_HEALTH, FOOD, THIRST, INK, CHISEL, EXPERIENCE, JUMP_BAR, HUD_MOVER, FAMILIARITY};
    }

    static {
        $VALUES = IngameOverlays.$values();
        TEXTURE = Helpers.identifier("textures/gui/icons/overlay.png");
        INK_TEXTURE = Helpers.identifier("textures/misc/ink_splatter.png");
        GLOW_INK_TEXTURE = Helpers.identifier("textures/misc/glow_ink_splatter.png");
        HEALTH_TEXT_SHADOW_COLOR = new Color(104, 0, 0).getRGB();
        VANILLA_HEALTH = VanillaGuiLayers.PLAYER_HEALTH;
        VANILLA_MOUNT_HEALTH = VanillaGuiLayers.VEHICLE_HEALTH;
        VANILLA_FOOD = VanillaGuiLayers.FOOD_LEVEL;
        VANILLA_EXP = VanillaGuiLayers.EXPERIENCE_BAR;
        VANILLA_EXP_LEVEL = VanillaGuiLayers.EXPERIENCE_LEVEL;
        VANILLA_JUMP = VanillaGuiLayers.JUMP_METER;
    }
}

