/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client;

import net.dries007.tfc.common.blocks.TFCBubbleColumnBlock;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AmbientSoundHandler;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.block.BubbleColumnBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TFCBubbleColumnAmbientSoundHandler
implements AmbientSoundHandler {
    private final LocalPlayer player;
    private boolean wasInBubbleColumn;
    private boolean firstTick = true;

    public TFCBubbleColumnAmbientSoundHandler(LocalPlayer localPlayer) {
        this.player = localPlayer;
    }

    public void tick() {
        ClientLevel level = this.player.clientLevel;
        BlockState stateAt = level.getBlockStatesIfLoaded(this.player.getBoundingBox().inflate(0.0, (double)-0.4f, 0.0).deflate(1.0E-6)).filter(state -> state.getBlock() instanceof TFCBubbleColumnBlock).findFirst().orElse(null);
        if (stateAt != null) {
            if (!this.wasInBubbleColumn && !this.firstTick && stateAt.getBlock() instanceof TFCBubbleColumnBlock && !this.player.isSpectator()) {
                if (((Boolean)stateAt.getValue((Property)BubbleColumnBlock.DRAG_DOWN)).booleanValue()) {
                    this.player.playSound(SoundEvents.BUBBLE_COLUMN_WHIRLPOOL_INSIDE, 1.0f, 1.0f);
                } else {
                    this.player.playSound(SoundEvents.BUBBLE_COLUMN_UPWARDS_INSIDE, 1.0f, 1.0f);
                }
            }
            this.wasInBubbleColumn = true;
        } else {
            this.wasInBubbleColumn = false;
        }
        this.firstTick = false;
    }
}

