/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.function.Function;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.model.SimpleStaticBlockEntityModel;
import net.dries007.tfc.common.blockentities.IngotPileBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.devices.DoubleIngotPileBlock;
import net.dries007.tfc.util.MetalItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.Property;

public enum DoubleIngotPileBlockModel implements SimpleStaticBlockEntityModel<DoubleIngotPileBlockModel, IngotPileBlockEntity>
{
    INSTANCE;


    @Override
    public TextureAtlasSprite render(IngotPileBlockEntity pile, PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay) {
        int ingots = (Integer)pile.getBlockState().getValue((Property)DoubleIngotPileBlock.DOUBLE_COUNT);
        Function textureAtlas = Minecraft.getInstance().getTextureAtlas(RenderHelpers.BLOCKS_ATLAS);
        TextureAtlasSprite sprite = null;
        for (int i = 0; i < ingots; ++i) {
            MetalItem metal = pile.getOrCacheMetal(i);
            sprite = (TextureAtlasSprite)textureAtlas.apply(metal.softTextureId());
            int layer = (i + 6) / 6;
            boolean oddLayer = layer % 2 == 1;
            float x = (float)(i % 3) * 0.33f;
            float y = (float)(layer - 1) * 1.0f / 6.0f;
            float z = i % 6 >= 3 ? 0.5f : 0.0f;
            poseStack.pushPose();
            if (oddLayer) {
                poseStack.translate(0.5f, 0.0f, 0.5f);
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                poseStack.translate(-0.5f, 0.0f, -0.5f);
            }
            poseStack.translate(x, y, z);
            float scale = 0.03125f;
            float minX = 0.015625f;
            float minY = 0.0f;
            float minZ = 0.015625f;
            float maxX = 0.31298828f;
            float maxY = 0.15625f;
            float maxZ = 0.46923828f;
            RenderHelpers.renderTexturedTrapezoidalCuboid(poseStack, buffer, sprite, packedLight, packedOverlay, 0.015625f, 0.31298828f, 0.015625f, 0.46923828f, 0.046875f, 0.28173828f, 0.046875f, 0.43798828f, 0.0f, 0.15625f, 10.0f, 5.0f, 15.0f, oddLayer);
            poseStack.popPose();
        }
        if (sprite == null) {
            sprite = RenderHelpers.missingTexture();
        }
        return sprite;
    }

    @Override
    public BlockEntityType<IngotPileBlockEntity> type() {
        return (BlockEntityType)TFCBlockEntities.INGOT_PILE.get();
    }

    @Override
    public int faces(IngotPileBlockEntity pile) {
        return (Integer)pile.getBlockState().getValue((Property)DoubleIngotPileBlock.DOUBLE_COUNT) * 6;
    }
}

