/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import org.jetbrains.annotations.Nullable;

public class MoldTableBlockModel
implements IDynamicBakedModel,
IUnbakedGeometry<MoldTableBlockModel> {
    private final BlockModel model;
    @Nullable
    private BakedModel baked;
    private static final MoldModelCache MOLD_MODEL_CACHE = IndirectHashCollection.create(new MoldModelCache(new IdentityHashMap<Item, BakedModel>()));

    public MoldTableBlockModel(BlockModel model) {
        this.model = model;
    }

    public ModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData modelData) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity != null && blockEntity.getType() == TFCBlockEntities.MOLD_TABLE.get()) {
            return blockEntity.getModelData();
        }
        return modelData;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction direction, RandomSource random, ModelData modelData, @Nullable RenderType renderType) {
        assert (this.baked != null);
        MoldModelData moldData = (MoldModelData)modelData.get(MoldModelData.PROPERTY);
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(this.baked.getQuads(state, direction, random, modelData, renderType));
        if (moldData != null && moldData.model() != null) {
            quads.addAll(moldData.model().getQuads(state, direction, random, modelData, renderType));
        }
        return quads;
    }

    public boolean useAmbientOcclusion() {
        return this.model.hasAmbientOcclusion();
    }

    public boolean isGui3d() {
        assert (this.baked != null);
        return this.baked.isGui3d();
    }

    public boolean usesBlockLight() {
        assert (this.baked != null);
        return this.baked.usesBlockLight();
    }

    public boolean isCustomRenderer() {
        assert (this.baked != null);
        return this.baked.isCustomRenderer();
    }

    public TextureAtlasSprite getParticleIcon() {
        assert (this.baked != null);
        return this.baked.getParticleIcon();
    }

    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> mapper, ModelState state, ItemOverrides overrides) {
        this.baked = this.model.bake(baker, mapper, state);
        return this;
    }

    public static MoldModelData getMoldModelData(ItemStack stack) {
        if (!stack.isEmpty()) {
            return new MoldModelData(MoldTableBlockModel.MOLD_MODEL_CACHE.values.get(stack.getItem()));
        }
        return new MoldModelData(null);
    }

    public record MoldModelData(@Nullable BakedModel model) {
        public static final ModelProperty<MoldModelData> PROPERTY = new ModelProperty();
    }

    record MoldModelCache(Map<Item, BakedModel> values) implements IndirectHashCollection.Cache
    {
        @Override
        public void clear() {
            this.values.clear();
        }

        @Override
        public void reload(RecipeManager manager) {
            BuiltInRegistries.ITEM.getTagOrEmpty(TFCTags.Items.USABLE_IN_MOLD_TABLE).forEach(item -> {
                ResourceLocation moldLocation = BuiltInRegistries.ITEM.getKey((Object)((Item)item.value()));
                ModelResourceLocation modelLocation = RenderHelpers.modelId(ResourceLocation.fromNamespaceAndPath((String)moldLocation.getNamespace(), (String)("block/mold/" + moldLocation.getPath())));
                BakedModel model = Minecraft.getInstance().getModelManager().getModel(modelLocation);
                if (model != Minecraft.getInstance().getModelManager().getMissingModel()) {
                    this.values.put((Item)item.value(), model);
                } else {
                    TerraFirmaCraft.LOGGER.error("No mold model loaded for mold item {}", (Object)moldLocation);
                }
            });
        }
    }

    public static class Loader
    implements IGeometryLoader<MoldTableBlockModel> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        public MoldTableBlockModel read(JsonObject json, JsonDeserializationContext context) throws JsonParseException {
            json.remove("loader");
            BlockModel model = (BlockModel)context.deserialize((JsonElement)json, BlockModel.class);
            return new MoldTableBlockModel(model);
        }
    }
}

