/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.math.Transformation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.model.ContainedFluidModel;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.neoforged.neoforge.client.NeoForgeRenderTypes;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.model.CompositeModel;
import net.neoforged.neoforge.client.model.SimpleModelState;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import net.neoforged.neoforge.client.model.geometry.StandaloneGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.UnbakedGeometryHelper;
import org.jetbrains.annotations.Nullable;

public record TrimmedItemModel(@Nullable ArmorTrim trim) implements IUnbakedGeometry<TrimmedItemModel>
{
    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides) {
        TextureAtlasSprite baseSprite = spriteGetter.apply(context.getMaterial("armor"));
        TextureAtlasSprite overlaySprite = context.hasMaterial("overlay") ? spriteGetter.apply(context.getMaterial("overlay")) : null;
        ResourceLocation trimLocation = context.getMaterial("trim").texture();
        String color = this.trim != null ? ((TrimMaterial)this.trim.material().value()).assetName() : null;
        TextureAtlasSprite trimSprite = this.trim != null ? spriteGetter.apply(new Material(RenderHelpers.BLOCKS_ATLAS, trimLocation.withSuffix("_" + color))) : null;
        StandaloneGeometryBakingContext itemContext = StandaloneGeometryBakingContext.builder((IGeometryBakingContext)context).withGui3d(false).withUseBlockLight(false).build(Helpers.resourceLocation("trim_override"));
        CompositeModel.Baked.Builder builder = CompositeModel.Baked.builder((IGeometryBakingContext)itemContext, (TextureAtlasSprite)baseSprite, (ItemOverrides)new TrimOverrideHandler(overrides, baker, (IGeometryBakingContext)itemContext), (ItemTransforms)context.getTransforms());
        RenderTypeGroup normalRenderTypes = new RenderTypeGroup(RenderType.translucent(), NeoForgeRenderTypes.ITEM_UNSORTED_TRANSLUCENT.get());
        TrimmedItemModel.addQuads(modelState, baseSprite, builder, normalRenderTypes, ContainedFluidModel.FLUID_TRANSFORM);
        if (overlaySprite != null) {
            TrimmedItemModel.addQuads(modelState, overlaySprite, builder, normalRenderTypes, ContainedFluidModel.FLUID_TRANSFORM);
        }
        if (trimSprite != null) {
            TrimmedItemModel.addQuads(modelState, trimSprite, builder, normalRenderTypes, ContainedFluidModel.COVER_TRANSFORM);
        }
        builder.setParticle(baseSprite);
        return builder.build();
    }

    private static void addQuads(ModelState modelState, TextureAtlasSprite trimSprite, CompositeModel.Baked.Builder builder, RenderTypeGroup normalRenderTypes, @Nullable Transformation transformation) {
        ModelState transformedState = transformation == null ? modelState : new SimpleModelState(modelState.getRotation().compose(transformation), modelState.isUvLocked());
        List unbaked = UnbakedGeometryHelper.createUnbakedItemElements((int)0, (TextureAtlasSprite)trimSprite);
        List quads = UnbakedGeometryHelper.bakeElements((List)unbaked, material -> trimSprite, (ModelState)transformedState);
        builder.addQuads(normalRenderTypes, (Collection)quads);
    }

    private static final class TrimOverrideHandler
    extends ItemOverrides {
        private final Map<String, BakedModel> cache = Maps.newHashMap();
        private final ItemOverrides nested;
        private final ModelBaker baker;
        private final IGeometryBakingContext owner;

        private TrimOverrideHandler(ItemOverrides nested, ModelBaker baker, IGeometryBakingContext owner) {
            this.nested = nested;
            this.baker = baker;
            this.owner = owner;
        }

        public BakedModel resolve(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
            BakedModel overridden = this.nested.resolve(originalModel, stack, level, entity, seed);
            if (overridden != originalModel || level == null) {
                return overridden;
            }
            ArmorTrim trim = (ArmorTrim)stack.get(DataComponents.TRIM);
            if (trim == null) {
                return originalModel;
            }
            String name = ((TrimMaterial)trim.material().value()).assetName();
            if (!this.cache.containsKey(name)) {
                TrimmedItemModel unbaked = new TrimmedItemModel(trim);
                BakedModel bakedModel = unbaked.bake(this.owner, this.baker, Material::sprite, (ModelState)BlockModelRotation.X0_Y0, this);
                this.cache.put(name, bakedModel);
                return bakedModel;
            }
            return this.cache.get(name);
        }
    }

    public static class Loader
    implements IGeometryLoader<TrimmedItemModel> {
        public TrimmedItemModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) throws JsonParseException {
            return new TrimmedItemModel(null);
        }
    }
}

