/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model.entity;

import com.google.common.collect.ImmutableList;
import net.dries007.tfc.common.entities.livestock.WoolyAnimal;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class AlpacaModel
extends AgeableListModel<WoolyAnimal> {
    private final ModelPart neck;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart leftHindLeg;
    private final ModelPart rightHindLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart wool_body_f;
    private final ModelPart wool_head_f;
    private final ModelPart wool_neck_f;
    private final ModelPart wool_right_hind_leg_f;
    private final ModelPart wool_left_hind_leg_f;
    private final ModelPart wool_right_front_leg_f;
    private final ModelPart wool_left_front_leg_f;

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 31).addBox(-4.0f, -18.0f, -9.0f, 8.0f, 9.0f, 17.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)25.0f, (float)0.0f));
        PartDefinition wool_body_f = body.addOrReplaceChild("wool_body_f", CubeListBuilder.create().texOffs(0, 0).addBox(-4.5f, -19.0f, -10.0f, 9.0f, 12.0f, 19.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition neck = body.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(52, 42).addBox(-1.5f, -12.3983f, -4.1846f, 3.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-15.0f, (float)-6.0f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(48, 9).addBox(-2.0872f, -4.5038f, -1.75f, 4.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(56, 19).addBox(-1.0872f, -2.5038f, -3.75f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0872f, (float)-12.4962f, (float)-4.0f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition earL = head.addOrReplaceChild("earL", CubeListBuilder.create().texOffs(45, 42).addBox(-1.0f, -2.0f, 0.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)-4.5f, (float)0.5f, (float)0.0873f, (float)0.0175f, (float)0.1396f));
        PartDefinition earR = head.addOrReplaceChild("earR", CubeListBuilder.create().texOffs(13, 0).addBox(-1.0f, -2.0f, 0.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)-4.5f, (float)0.5f, (float)0.0873f, (float)0.0175f, (float)-0.1396f));
        PartDefinition wool_head_f = head.addOrReplaceChild("wool_head_f", CubeListBuilder.create().texOffs(35, 31).addBox(-3.0f, -5.0f, -0.75f, 6.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition wool_neck_f = neck.addOrReplaceChild("wool_neck_f", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -13.0f, -4.75f, 4.0f, 13.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(35, 42).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-17.5f, (float)7.5f, (float)0.9599f, (float)0.0f, (float)0.0f));
        PartDefinition right_hind_leg = body.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(12, 57).addBox(-1.75f, -2.0f, -1.5f, 3.0f, 15.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)-14.0f, (float)6.5f));
        PartDefinition wool_right_hind_leg_f = right_hind_leg.addOrReplaceChild("wool_right_hind_leg_f", CubeListBuilder.create().texOffs(37, 0).addBox(-2.0f, -3.0f, -2.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_hind_leg = body.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(0, 57).addBox(-1.25f, -2.0f, -1.5f, 3.0f, 15.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)-14.0f, (float)6.5f));
        PartDefinition wool_left_hind_leg_f = left_hind_leg.addOrReplaceChild("wool_left_hind_leg_f", CubeListBuilder.create().texOffs(0, 31).addBox(4.0f, -3.0f, -2.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_front_leg = body.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(12, 75).addBox(-1.5f, -1.0f, -1.5f, 3.0f, 11.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.25f, (float)-11.0f, (float)-6.0f));
        PartDefinition wool_right_front_leg_f = right_front_leg.addOrReplaceChild("wool_right_front_leg_f", CubeListBuilder.create().texOffs(62, 54).addBox(-2.0f, -3.0f, -2.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_front_leg = body.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(0, 75).addBox(-1.25f, -1.0f, -1.5f, 3.0f, 11.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)-11.0f, (float)-6.0f));
        PartDefinition wool_left_front_leg_f = left_front_leg.addOrReplaceChild("wool_left_front_leg_f", CubeListBuilder.create().texOffs(59, 27).addBox(-2.0f, -3.0f, -2.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)128, (int)128);
    }

    public AlpacaModel(ModelPart root) {
        super(false, 0.0f, 0.0f, 1.8f, 1.8f, 19.0f);
        this.body = root.getChild("body");
        this.neck = this.body.getChild("neck");
        this.head = this.neck.getChild("head");
        this.wool_body_f = this.body.getChild("wool_body_f");
        this.wool_head_f = this.head.getChild("wool_head_f");
        this.wool_neck_f = this.neck.getChild("wool_neck_f");
        this.leftHindLeg = this.body.getChild("left_hind_leg");
        this.wool_left_hind_leg_f = this.leftHindLeg.getChild("wool_left_hind_leg_f");
        this.rightHindLeg = this.body.getChild("right_hind_leg");
        this.wool_right_hind_leg_f = this.rightHindLeg.getChild("wool_right_hind_leg_f");
        this.leftFrontLeg = this.body.getChild("left_front_leg");
        this.wool_left_front_leg_f = this.leftFrontLeg.getChild("wool_left_front_leg_f");
        this.rightFrontLeg = this.body.getChild("right_front_leg");
        this.wool_right_front_leg_f = this.rightFrontLeg.getChild("wool_right_front_leg_f");
    }

    public void setupAnim(WoolyAnimal animal, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        this.wool_body_f.visible = animal.hasProduct();
        this.head.xRot = headPitch * 0.01308997f;
        this.neck.xRot = headPitch * 0.004363323f;
        this.head.yRot = headYaw * ((float)Math.PI / 360);
        this.neck.yRot = headYaw * ((float)Math.PI / 360);
        this.rightHindLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftHindLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leftFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body);
    }
}

