/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model.entity;

import net.dries007.tfc.client.model.entity.DeerModel;
import net.dries007.tfc.client.model.entity.HierarchicalAnimatedModel;
import net.dries007.tfc.common.entities.prey.Prey;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class GazelleModel
extends HierarchicalAnimatedModel<Prey> {
    private final ModelPart head;

    public GazelleModel(ModelPart root) {
        super(root);
        this.head = root.getChild("body").getChild("neck").getChild("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -18.0f, -7.0f, 5.0f, 7.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)27.0f, (float)0.0f));
        PartDefinition neck = body.addOrReplaceChild("neck", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-15.0f, (float)-6.0f));
        PartDefinition neck0_r1 = neck.addOrReplaceChild("neck0_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5872f, -6.4021f, -0.1846f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0872f, (float)0.0038f, (float)-1.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 22).addBox(-2.0872f, -3.0038f, -3.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(32, 22).addBox(-1.0872f, -2.0038f, -5.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0872f, (float)-5.9962f, (float)-2.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition earR = head.addOrReplaceChild("earR", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-3.0f, (float)-2.5f, (float)0.0f, (float)-0.6269f, (float)0.3301f, (float)-0.3362f));
        PartDefinition ear_r1 = earR.addOrReplaceChild("ear_r1", CubeListBuilder.create().texOffs(33, 0).addBox(-1.0f, -2.0f, 1.75f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.154f, (float)-0.8513f, (float)-0.5015f, (float)-0.2618f, (float)0.0f, (float)-0.48f));
        PartDefinition earL = head.addOrReplaceChild("earL", CubeListBuilder.create(), PartPose.offsetAndRotation((float)2.8257f, (float)-2.5f, (float)0.0f, (float)-0.6269f, (float)-0.3301f, (float)0.3362f));
        PartDefinition ear_r2 = earL.addOrReplaceChild("ear_r2", CubeListBuilder.create().texOffs(8, 10).addBox(-1.0f, -2.0f, 1.75f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.154f, (float)-0.8513f, (float)-0.5015f, (float)-0.2618f, (float)0.0f, (float)0.48f));
        PartDefinition hornR = head.addOrReplaceChild("hornR", CubeListBuilder.create(), PartPose.offset((float)-1.0f, (float)-2.75f, (float)-0.75f));
        PartDefinition tip_r1 = hornR.addOrReplaceChild("tip_r1", CubeListBuilder.create().texOffs(33, 4).addBox(-1.5f, -0.5f, 0.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)3.0f, (float)0.9599f, (float)0.0f, (float)0.0f));
        PartDefinition mid_r1 = hornR.addOrReplaceChild("mid_r1", CubeListBuilder.create().texOffs(32, 27).addBox(-1.25f, -0.25f, -0.75f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.25f, (float)1.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition base_r1 = hornR.addOrReplaceChild("base_r1", CubeListBuilder.create().texOffs(0, 22).addBox(-1.0f, -2.0f, -1.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition hornL2 = head.addOrReplaceChild("hornL2", CubeListBuilder.create(), PartPose.offset((float)0.8257f, (float)-2.75f, (float)-0.75f));
        PartDefinition tip_r2 = hornL2.addOrReplaceChild("tip_r2", CubeListBuilder.create().texOffs(9, 0).addBox(0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)3.0f, (float)0.9599f, (float)0.0f, (float)0.0f));
        PartDefinition mid_r2 = hornL2.addOrReplaceChild("mid_r2", CubeListBuilder.create().texOffs(32, 31).addBox(0.25f, -0.25f, -0.75f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.25f, (float)1.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition base_r2 = hornL2.addOrReplaceChild("base_r2", CubeListBuilder.create().texOffs(0, 10).addBox(0.0f, -2.0f, -1.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 10).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-17.0f, (float)7.75f, (float)-1.1781f, (float)0.0f, (float)0.0f));
        PartDefinition legBR = body.addOrReplaceChild("legBR", CubeListBuilder.create().texOffs(19, 36).addBox(-1.0f, -3.0f, -1.0f, 2.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 30).addBox(-1.0f, 4.0f, 0.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)-14.0f, (float)5.0f));
        PartDefinition legBL = body.addOrReplaceChild("legBL", CubeListBuilder.create().texOffs(8, 35).addBox(-1.0f, -3.0f, -1.0f, 2.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(40, 0).addBox(-1.0f, 4.0f, 0.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)-14.0f, (float)5.0f));
        PartDefinition legFR = body.addOrReplaceChild("legFR", CubeListBuilder.create().texOffs(16, 22).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)-14.0f, (float)-4.0f));
        PartDefinition legFL = body.addOrReplaceChild("legFL", CubeListBuilder.create().texOffs(24, 22).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)-15.0f, (float)-4.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Override
    public void setupAnim(Prey entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, headYaw, headPitch);
        float speed = this.getAdjustedLandSpeed(entity);
        if (speed > 1.1f) {
            this.animateWalk(DeerModel.DEER_RUN, limbSwing, limbSwingAmount, 1.0f, 2.5f);
        } else {
            this.animateWalk(DeerModel.DEER_WALK, limbSwing, limbSwingAmount, 2.5f, 2.5f);
        }
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = headYaw * ((float)Math.PI / 180);
    }
}

