/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model.entity;

import net.dries007.tfc.client.model.entity.HierarchicalAnimatedModel;
import net.dries007.tfc.common.entities.aquatic.Penguin;
import net.minecraft.client.animation.AnimationChannel;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class PenguinModel
extends HierarchicalAnimatedModel<Penguin> {
    public static final AnimationDefinition WALK = AnimationDefinition.Builder.withLength((float)1.0f).looping().addAnimation("core", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)15.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.5f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)-15.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)15.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("head", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.33f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)-15.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.66f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)15.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("leftfoot", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.5f, KeyframeAnimations.degreeVec((float)45.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("rightfoot", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.5f, KeyframeAnimations.degreeVec((float)-45.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("leftwing", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.5f, KeyframeAnimations.degreeVec((float)25.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("rightwing", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.5f, KeyframeAnimations.degreeVec((float)25.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).build();
    public static final AnimationDefinition SWIM = AnimationDefinition.Builder.withLength((float)1.0f).looping().addAnimation("leftfoot", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.5f, KeyframeAnimations.degreeVec((float)45.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("rightfoot", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.5f, KeyframeAnimations.degreeVec((float)-45.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("leftwing", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.5f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)-25.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("rightwing", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.5f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)25.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).build();
    private final ModelPart core;
    private final ModelPart head;

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition core = partdefinition.addOrReplaceChild("core", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)23.0f, (float)0.0f));
        PartDefinition core_r1 = core.addOrReplaceChild("core_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -9.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)1.0f, (float)-3.1416f, (float)0.0f, (float)3.1416f));
        PartDefinition head = core.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition head_r1 = head.addOrReplaceChild("head_r1", CubeListBuilder.create().texOffs(16, 4).addBox(-1.0f, -10.0f, 1.5f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)9.0f, (float)1.0f, (float)-3.1416f, (float)0.0f, (float)3.1416f));
        PartDefinition head_r2 = head.addOrReplaceChild("head_r2", CubeListBuilder.create().texOffs(13, 9).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)1.0f, (float)-3.1416f, (float)0.0f, (float)3.1416f));
        PartDefinition leftfoot = core.addOrReplaceChild("leftfoot", CubeListBuilder.create().texOffs(12, 0).addBox(1.3264f, 0.0f, -0.9848f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)-1.0f, (float)0.0f, (float)-0.1745f, (float)0.0f));
        PartDefinition rightfoot = core.addOrReplaceChild("rightfoot", CubeListBuilder.create().texOffs(16, 16).addBox(-4.3264f, 0.0f, -0.9848f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)0.0f, (float)-1.0f, (float)0.0f, (float)0.1745f, (float)0.0f));
        PartDefinition leftwing = core.addOrReplaceChild("leftwing", CubeListBuilder.create().texOffs(0, 12).mirror().addBox(0.0f, 0.0f, 0.0f, 1.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)2.0f, (float)-7.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition rightwing = core.addOrReplaceChild("rightwing", CubeListBuilder.create().texOffs(8, 12).mirror().addBox(-1.0f, 0.0f, 0.0f, 1.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-2.0f, (float)-7.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public PenguinModel(ModelPart root) {
        super(root);
        this.core = root.getChild("core");
        this.head = this.core.getChild("head");
    }

    @Override
    public void setupAnim(Penguin entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (entity.isPlayingDead()) {
            this.core.xRot = -1.5707964f;
        } else {
            this.animateWalk(entity.isInWaterOrBubble() ? SWIM : WALK, limbSwing, limbSwingAmount, 3.2f, 2.5f);
            this.head.xRot = entity.isInWater() ? -1.0f : headPitch * ((float)Math.PI / 180);
            this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        }
    }
}

