/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model.entity;

import com.google.common.collect.ImmutableList;
import net.dries007.tfc.common.entities.livestock.DairyAnimal;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class TFCCowModel
extends AgeableListModel<DairyAnimal> {
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart leftHindLeg;
    private final ModelPart rightHindLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart udder;
    private final ModelPart hornR;
    private final ModelPart hornR2;
    private final ModelPart hornL;
    private final ModelPart hornL2;

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-12.0f, -9.0f, -8.0f, 12.0f, 10.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.offset((float)6.0f, (float)11.0f, (float)0.0f));
        PartDefinition leftFrontLeg = body.addOrReplaceChild("leftFrontLeg", CubeListBuilder.create().texOffs(0, 42).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)1.0f, (float)-6.0f));
        PartDefinition rightHindLeg = body.addOrReplaceChild("rightHindLeg", CubeListBuilder.create().texOffs(40, 40).addBox(-2.0f, 0.0f, -3.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-10.0f, (float)1.0f, (float)8.0f));
        PartDefinition rightFrontLeg = body.addOrReplaceChild("rightFrontLeg", CubeListBuilder.create().texOffs(28, 28).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-10.0f, (float)1.0f, (float)-6.0f));
        PartDefinition leftHindLeg = body.addOrReplaceChild("leftHindLeg", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, 0.0f, -3.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)1.0f, (float)8.0f));
        PartDefinition udder = body.addOrReplaceChild("udder", CubeListBuilder.create().texOffs(42, 0).addBox(-2.0f, -11.0f, 4.05f, 4.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.0f, (float)11.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 28).addBox(-4.0f, -3.0f, -6.0f, 8.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.0f, (float)-8.0f, (float)-8.0f));
        PartDefinition hornR = head.addOrReplaceChild("hornR", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -2.0f, -1.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)-2.0f, (float)-2.0f));
        PartDefinition hornR2 = hornR.addOrReplaceChild("hornR2", CubeListBuilder.create().texOffs(42, 8).addBox(0.0f, -2.0f, -1.25f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4363f));
        PartDefinition hornL = head.addOrReplaceChild("hornL", CubeListBuilder.create().texOffs(12, 0).addBox(0.0f, -2.0f, -1.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)-2.0f, (float)-2.0f));
        PartDefinition hornL2 = hornL.addOrReplaceChild("hornL2", CubeListBuilder.create().texOffs(42, 11).addBox(-1.0f, -2.0f, -1.25f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.4363f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body);
    }

    public TFCCowModel(ModelPart root) {
        super(false, 0.0f, 0.0f, 1.8f, 1.8f, 19.0f);
        this.body = root.getChild("body");
        this.head = this.body.getChild("head");
        this.leftHindLeg = this.body.getChild("leftHindLeg");
        this.rightHindLeg = this.body.getChild("rightHindLeg");
        this.leftFrontLeg = this.body.getChild("leftFrontLeg");
        this.rightFrontLeg = this.body.getChild("rightFrontLeg");
        this.hornL = this.head.getChild("hornL");
        this.hornL2 = this.hornL.getChild("hornL2");
        this.hornR = this.head.getChild("hornR");
        this.hornR2 = this.hornR.getChild("hornR2");
        this.udder = this.body.getChild("udder");
    }

    public void setupAnim(DairyAnimal entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        this.hornR2.visible = this.hornL2.visible = entity.displayMaleCharacteristics();
        this.udder.visible = entity.displayFemaleCharacteristics();
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = headYaw * ((float)Math.PI / 180);
        this.rightHindLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftHindLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leftFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
    }
}

