/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.dries007.tfc.common.blockentities.rotation.WindmillBlockEntity;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;

public class WindmillBladeModel
extends Model {
    private final ModelPart blade;
    private final ModelPart main;

    public WindmillBladeModel(ModelPart root) {
        super(RenderType::entityCutout);
        this.blade = root.getChild("blade");
        this.main = root.getChild("main");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition blade = partdefinition.addOrReplaceChild("blade", CubeListBuilder.create().texOffs(0, 99).addBox(-1.0f, 1.5f, -94.5f, 2.0f, 13.0f, 80.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition main = partdefinition.addOrReplaceChild("main", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -1.5f, -94.5f, 4.0f, 3.0f, 96.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public void setupAnim(WindmillBlockEntity windmill, float partialTick, float offsetAngle) {
        this.main.xRot = -(windmill.getRotationAngle(partialTick) + offsetAngle);
        this.blade.xRot = -(windmill.getRotationAngle(partialTick) + offsetAngle);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.main.render(poseStack, vertexConsumer, packedLight, packedOverlay, -1);
        this.blade.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    public void renderWindmillExtras(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
    }
}

