/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model.entity;

import com.google.common.collect.ImmutableList;
import net.dries007.tfc.common.entities.livestock.DairyAnimal;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class YakModel
extends AgeableListModel<DairyAnimal> {
    private final ModelPart body;
    private final ModelPart udder;
    private final ModelPart legBR;
    private final ModelPart legBL;
    private final ModelPart legFR;
    private final ModelPart legFL;
    private final ModelPart neck;
    private final ModelPart head;
    private final ModelPart hornL1;
    private final ModelPart hornL2;
    private final ModelPart hornR1;
    private final ModelPart hornR2;
    private final ModelPart snout;
    private final ModelPart beard;

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 46).addBox(-5.0f, -26.0f, -6.0f, 10.0f, 19.0f, 20.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-7.0f, -24.0f, -11.0f, 14.0f, 20.0f, 26.0f, new CubeDeformation(0.0f)).texOffs(60, 46).addBox(-6.0f, -25.0f, -14.0f, 12.0f, 17.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)23.0f, (float)0.0f));
        PartDefinition neck = body.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(56, 0).addBox(-3.0f, -2.0f, -3.0f, 6.0f, 5.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-20.0f, (float)-15.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -3.0f, -4.0f, 7.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)1.0f, (float)-2.0f, (float)0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition hornL1 = head.addOrReplaceChild("hornL1", CubeListBuilder.create().texOffs(31, 85).addBox(-2.6f, 0.3521f, -1.9674f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition hornL2 = hornL1.addOrReplaceChild("hornL2", CubeListBuilder.create().texOffs(0, 85).addBox(-1.608f, -0.2903f, -0.5f, 3.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.092f, (float)1.2903f, (float)-1.1233f, (float)0.0f, (float)0.0f, (float)-0.5236f));
        PartDefinition hornLCube3_r1 = hornL2.addOrReplaceChild("hornLCube3_r1", CubeListBuilder.create().texOffs(10, 87).addBox(-2.75f, -0.75f, 0.75f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.7014f, (float)1.2758f, (float)0.1107f, (float)0.0f, (float)-1.1781f, (float)0.9163f));
        PartDefinition hornR1 = head.addOrReplaceChild("hornR1", CubeListBuilder.create().texOffs(18, 85).addBox(-0.4f, 0.3521f, -1.9674f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition hornR2 = hornR1.addOrReplaceChild("hornR2", CubeListBuilder.create().texOffs(0, 88).addBox(-2.5934f, -1.0661f, -0.4874f, 3.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.7934f, (float)2.5661f, (float)-1.0126f, (float)0.0f, (float)0.0f, (float)0.5236f));
        PartDefinition hornRCube3_r1 = hornR2.addOrReplaceChild("hornRCube3_r1", CubeListBuilder.create().texOffs(10, 85).addBox(-0.25f, -0.75f, 0.0f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.1781f, (float)-0.9163f));
        PartDefinition snout = head.addOrReplaceChild("snout", CubeListBuilder.create().texOffs(0, 13).addBox(-2.0f, -4.4102f, -4.0209f, 5.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.3499f, (float)-4.0589f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition beard = head.addOrReplaceChild("beard", CubeListBuilder.create().texOffs(41, -3).addBox(0.0f, -1.0442f, -5.8944f, 0.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.0442f, (float)-0.6163f, (float)-0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition legFL = body.addOrReplaceChild("legFL", CubeListBuilder.create().texOffs(0, 46).addBox(-1.25f, -6.0f, -1.5f, 4.0f, 15.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.25f, (float)-8.0f, (float)-7.5f));
        PartDefinition legFR = body.addOrReplaceChild("legFR", CubeListBuilder.create().texOffs(40, 46).addBox(-2.5f, -6.0f, -1.5f, 4.0f, 15.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.5f, (float)-8.0f, (float)-7.5f));
        PartDefinition legBL = body.addOrReplaceChild("legBL", CubeListBuilder.create().texOffs(60, 73).addBox(-1.5f, -3.0f, -1.5f, 4.0f, 13.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.5f, (float)-9.0f, (float)9.5f));
        PartDefinition legBR = body.addOrReplaceChild("legBR", CubeListBuilder.create().texOffs(76, 73).addBox(-2.5f, -3.0f, -1.5f, 4.0f, 13.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.5f, (float)-9.0f, (float)9.5f));
        PartDefinition udder = body.addOrReplaceChild("udder", CubeListBuilder.create().texOffs(56, 18).addBox(1.0f, -7.5f, 4.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)1.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public YakModel(ModelPart root) {
        super(false, 0.0f, 0.0f, 1.8f, 1.8f, 19.0f);
        this.body = root.getChild("body");
        this.udder = this.body.getChild("udder");
        this.neck = this.body.getChild("neck");
        this.head = this.neck.getChild("head");
        this.legBR = this.body.getChild("legBR");
        this.legBL = this.body.getChild("legBL");
        this.legFR = this.body.getChild("legFR");
        this.legFL = this.body.getChild("legFL");
        this.hornL1 = this.head.getChild("hornL1");
        this.hornL2 = this.hornL1.getChild("hornL2");
        this.hornR1 = this.head.getChild("hornR1");
        this.hornR2 = this.hornR1.getChild("hornR2");
        this.beard = this.head.getChild("beard");
        this.snout = this.head.getChild("snout");
    }

    public void setupAnim(DairyAnimal animal, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        this.hornR1.visible = !animal.isBaby();
        this.hornL1.visible = this.hornR1.visible;
        this.udder.visible = animal.displayFemaleCharacteristics();
        this.head.xRot = headPitch * 0.006544985f + 0.873f;
        this.neck.xRot = headPitch * 0.004363323f;
        this.head.yRot = headYaw * ((float)Math.PI / 360);
        this.neck.yRot = headYaw * ((float)Math.PI / 360);
        this.legBR.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.legBL.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.legFR.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.legFL.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body);
    }
}

