/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.overworld;

import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.client.overworld.SkyPos;
import net.dries007.tfc.client.overworld.SolarCalculator;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.climate.Climate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public final class ClientSolarCalculatorBridge {
    public static long getDayTime(LevelAccessor maybeLevel) {
        Player player;
        Level level;
        if (maybeLevel instanceof Level && (level = (Level)maybeLevel).dimension() == Level.OVERWORLD && (player = ClientHelpers.getPlayer()) != null) {
            return SolarCalculator.getSunBasedDayTime(player.blockPosition().getZ(), Climate.get(level).hemisphereScale(), Calendars.CLIENT.getCalendarFractionOfYear(), Calendars.CLIENT.getCalendarFractionOfDay());
        }
        return maybeLevel.getLevelData().getDayTime();
    }

    public static SkyPos getSunPosition(Level level, BlockPos pos) {
        return SolarCalculator.getSunPosition(pos.getZ(), Climate.get(level).hemisphereScale(), Calendars.CLIENT.getCalendarFractionOfYear(), Calendars.CLIENT.getCalendarFractionOfDay());
    }

    public static int getMoonPhase() {
        return SolarCalculator.getMoonPhase(Calendars.CLIENT.getCalendarTicks(), ClientSolarCalculatorBridge.getMoonOrbitTicks());
    }

    public static SkyPos getMoonPosition(Level level, BlockPos pos) {
        return SolarCalculator.getMoonPosition(pos.getZ(), Climate.get(level).hemisphereScale(), Calendars.CLIENT.getCalendarTicks(), ClientSolarCalculatorBridge.getMoonOrbitTicks());
    }

    public static int getMoonOrbitTicks() {
        return 387120;
    }

    public static SkyPos getStarPosition(Level level, BlockPos pos) {
        return SolarCalculator.getStarPosition(pos.getZ(), Climate.get(level).hemisphereScale(), Calendars.CLIENT.getCalendarFractionOfDay(), Calendars.CLIENT.getCalendarFractionOfYear());
    }
}

