/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;

public class BubbleColumnDownParticle
extends TextureSheetParticle {
    private float angle;

    public BubbleColumnDownParticle(ClientLevel worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
        this.setSize(0.02f, 0.02f);
        this.quadSize *= this.random.nextFloat() * 0.6f + 0.2f;
        this.lifetime = (int)(Math.random() * 60.0) + 30;
        this.hasPhysics = false;
        this.xd = 0.0;
        this.yd = -0.05;
        this.zd = 0.0;
        this.gravity = 0.002f;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        this.xd += (double)(0.6f * Mth.cos((float)this.angle));
        this.zd += (double)(0.6f * Mth.sin((float)this.angle));
        this.xd *= 0.07;
        this.zd *= 0.07;
        this.move(this.xd, this.yd, this.zd);
        if (this.level.getFluidState(BlockPos.containing((double)this.x, (double)this.y, (double)this.z)).isEmpty() || this.onGround) {
            this.remove();
        }
        this.angle += 0.08f;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public record Provider(SpriteSet sprite) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            BubbleColumnDownParticle particle = new BubbleColumnDownParticle(level, x, y, z);
            particle.pickSprite(this.sprite);
            return particle;
        }
    }
}

