/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.particle;

import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.particle.FluidParticleOption;
import net.dries007.tfc.client.particle.TFCParticles;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;

public class FluidDripParticle
extends TextureSheetParticle {
    private final Fluid type;
    protected boolean isGlowing;

    public FluidDripParticle(ClientLevel level, double x, double y, double z, Fluid fluid) {
        super(level, x, y, z);
        this.setSize(0.01f, 0.01f);
        this.gravity = 0.06f;
        this.type = fluid;
        int color = RenderHelpers.getFluidColor(this.type);
        this.rCol = (float)(color >> 16 & 0xFF) / 255.0f;
        this.gCol = (float)(color >> 8 & 0xFF) / 255.0f;
        this.bCol = (float)(color & 0xFF) / 255.0f;
    }

    protected Fluid getFluid() {
        return this.type;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public int getLightColor(float partialTick) {
        return this.isGlowing ? 240 : super.getLightColor(partialTick);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.preMoveUpdate();
        if (!this.removed) {
            this.yd -= (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
            this.postMoveUpdate();
            if (!this.removed) {
                this.xd *= (double)0.98f;
                this.yd *= (double)0.98f;
                this.zd *= (double)0.98f;
                BlockPos blockpos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
                FluidState fluidstate = this.level.getFluidState(blockpos);
                if (fluidstate.getType() == this.type && this.y < (double)((float)blockpos.getY() + fluidstate.getHeight((BlockGetter)this.level, blockpos))) {
                    this.remove();
                }
            }
        }
    }

    protected void preMoveUpdate() {
        if (this.lifetime-- <= 0) {
            this.remove();
        }
    }

    protected void postMoveUpdate() {
    }

    public static ParticleProvider<FluidParticleOption> provider(SpriteSet set, FluidParticleFactory factory) {
        return (type, level, x, y, z, dx, dy, dz) -> {
            FluidDripParticle particle = factory.create(level, x, y, z, type.getFluid());
            particle.pickSprite(set);
            return particle;
        };
    }

    public static interface FluidParticleFactory {
        public FluidDripParticle create(ClientLevel var1, double var2, double var4, double var6, Fluid var8);
    }

    public static class BarrelSpillParticle
    extends FluidFallAndLandParticle {
        public BarrelSpillParticle(ClientLevel level, double x, double y, double z, Fluid fluid) {
            super(level, x, y, z, fluid);
            this.gravity = 0.06f;
        }
    }

    public static class BarrelDripParticle
    extends FluidFallAndLandParticle {
        public BarrelDripParticle(ClientLevel level, double x, double y, double z, Fluid fluid) {
            super(level, x, y, z, fluid);
            double dx = x - (double)Mth.floor((double)x);
            double dz = z - (double)Mth.floor((double)z);
            if (dx < 0.5) {
                this.xd = 0.01;
            } else if (dx > 0.5) {
                this.xd = -0.01;
            } else {
                this.zd = dz < 0.5 ? 0.01 : -0.01;
            }
        }
    }

    public static class FluidLandParticle
    extends FluidDripParticle {
        public FluidLandParticle(ClientLevel level, double x, double y, double z, Fluid fluid) {
            super(level, x, y, z, fluid);
            this.lifetime = (int)(16.0 / (Math.random() * 0.8 + 0.2));
        }
    }

    public static class FluidFallAndLandParticle
    extends FluidDripParticle {
        private final ParticleOptions landingParticle;

        public FluidFallAndLandParticle(ClientLevel level, double x, double y, double z, Fluid fluid) {
            this(level, x, y, z, fluid, new FluidParticleOption((ParticleType<FluidParticleOption>)((ParticleType)TFCParticles.FLUID_LAND.get()), fluid));
        }

        public FluidFallAndLandParticle(ClientLevel level, double x, double y, double z, Fluid fluid, ParticleOptions landParticle) {
            super(level, x, y, z, fluid);
            this.landingParticle = landParticle;
            this.lifetime = 40;
            this.gravity *= 0.02f;
        }

        @Override
        protected void postMoveUpdate() {
            if (this.onGround) {
                this.remove();
                this.level.addParticle(this.landingParticle, this.x, this.y, this.z, 0.0, 0.0, 0.0);
            }
        }
    }

    public static class FluidHangParticle
    extends FluidDripParticle {
        private final ParticleOptions fallingParticle;

        public FluidHangParticle(ClientLevel level, double x, double y, double z, Fluid fluid) {
            this(level, x, y, z, fluid, new FluidParticleOption((ParticleType<FluidParticleOption>)((ParticleType)TFCParticles.FLUID_FALL.get()), fluid));
        }

        public FluidHangParticle(ClientLevel level, double x, double y, double z, Fluid fluid, ParticleOptions fallParticle) {
            super(level, x, y, z, fluid);
            this.fallingParticle = fallParticle;
            this.lifetime = 40;
            this.gravity *= 0.02f;
        }

        @Override
        protected void preMoveUpdate() {
            if (this.lifetime-- <= 0) {
                this.remove();
                this.level.addParticle(this.fallingParticle, this.x, this.y, this.z, this.xd, this.yd, this.zd);
            }
        }

        @Override
        protected void postMoveUpdate() {
            this.xd *= 0.02;
            this.yd *= 0.02;
            this.zd *= 0.02;
        }
    }
}

