/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public class SparkParticle
extends TextureSheetParticle {
    public SparkParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
        this.rCol = level.random.nextFloat() * 0.3f + 0.6f;
        this.gCol = this.rCol - level.random.nextFloat() / 5.0f;
        this.bCol = 0.0f;
        this.lifetime = 60 + level.random.nextInt(40);
        this.scale(Mth.nextFloat((RandomSource)level.random, (float)0.7f, (float)0.9f));
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.move(this.xd, this.yd, this.zd);
            if (this.speedUpWhenYMotionIsBlocked && this.y == this.yo) {
                this.xd *= 1.1;
                this.zd *= 1.1;
            }
            this.xd *= (double)0.9f;
            this.yd *= (double)0.7f;
            this.zd *= (double)0.9f;
            this.yd -= (double)0.03f;
            this.rCol = Mth.lerp((float)0.01f, (float)this.rCol, (float)1.0f);
            this.gCol *= 0.98f;
            if (this.onGround) {
                this.zd = 0.0;
                this.yd = 0.0;
                this.xd = 0.0;
            }
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public record Provider(SpriteSet sprite) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SparkParticle particle = new SparkParticle(level, x, y, z);
            particle.xd = xSpeed;
            particle.yd = ySpeed;
            particle.zd = zSpeed;
            particle.pickSprite(this.sprite);
            return particle;
        }
    }
}

