/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.particle;

import net.dries007.tfc.client.ClimateRenderCache;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.phys.Vec2;

public class VariableHeightSmokeParticle
extends TextureSheetParticle {
    public VariableHeightSmokeParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int lifeTime) {
        super(level, x, y, z);
        this.scale(3.0f);
        this.setSize(0.25f, 0.25f);
        this.lifetime = this.random.nextInt(50) + lifeTime;
        this.gravity = 3.0E-6f;
        Vec2 wind = ClimateRenderCache.INSTANCE.getWind();
        float windStrength = wind.length();
        this.xd = xSpeed + (double)(wind.x * windStrength * 0.05f);
        this.yd = ySpeed + (double)(this.random.nextFloat() / 500.0f);
        this.zd = zSpeed + (double)(wind.y * windStrength * 0.05f);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ < this.lifetime && this.alpha > 0.0f) {
            this.xd += (double)(Helpers.triangle(this.random) / 5000.0f);
            this.zd += (double)(Helpers.triangle(this.random) / 5000.0f);
            this.yd -= (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
            if (this.age >= this.lifetime - 60 && this.alpha > 0.01f) {
                this.alpha -= 0.015f;
            }
        } else {
            this.remove();
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public record Provider(SpriteSet sprites, int lifetime) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            VariableHeightSmokeParticle particle = new VariableHeightSmokeParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, this.lifetime);
            particle.pickSprite(this.sprites);
            particle.setAlpha(0.92f);
            return particle;
        }
    }
}

