/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.model.entity.AnemometerModel;
import net.dries007.tfc.common.blockentities.AnemometerBlockEntity;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;

public class AnemometerBlockEntityRenderer
implements BlockEntityRenderer<AnemometerBlockEntity> {
    public static final ResourceLocation TEXTURE = Helpers.identifier("textures/entity/anemometer.png");
    private final AnemometerModel model;

    public AnemometerBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new AnemometerModel(context.bakeLayer(RenderHelpers.layerId("anemometer")));
    }

    public void render(AnemometerBlockEntity anemometer, float partialTick, PoseStack stack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        if (anemometer.getLevel() == null) {
            return;
        }
        stack.pushPose();
        stack.translate(0.5f, -0.0f, 0.5f);
        stack.translate(0.0f, 1.5f, 0.0f);
        stack.scale(-1.0f, -1.0f, 1.0f);
        stack.mulPose(Axis.YP.rotationDegrees(0.0f));
        this.model.setupAnim(anemometer, partialTick);
        this.model.renderToBuffer(stack, buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)TEXTURE)), packedLight, packedOverlay, -1);
        stack.popPose();
    }
}

