/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.render.blockentity.AxleBlockEntityRenderer;
import net.dries007.tfc.common.blockentities.rotation.BladedAxleBlockEntity;
import net.dries007.tfc.common.blocks.rotation.BladedAxleBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BladedAxleBlockEntityRenderer
implements BlockEntityRenderer<BladedAxleBlockEntity> {
    private static final ResourceLocation BLADE_TEXTURE = Helpers.identifier("block/metal/block/steel");

    public static void renderBlade(PoseStack stack, MultiBufferSource bufferSource, Direction.Axis axis, int packedLight, int packedOverlay, float rotationAngle) {
        TextureAtlasSprite sprite = RenderHelpers.blockTexture(BLADE_TEXTURE);
        VertexConsumer buffer = bufferSource.getBuffer(RenderType.cutout());
        stack.pushPose();
        AxleBlockEntityRenderer.applyRotation(stack, axis, rotationAngle);
        RenderHelpers.renderTexturedCuboid(stack, buffer, sprite, packedLight, packedOverlay, 0.4375f, 0.625f, 0.375f, 0.5625f, 1.09375f, 0.625f, false);
        stack.popPose();
    }

    public void render(BladedAxleBlockEntity axle, float partialTick, PoseStack stack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        BladedAxleBlock axleBlock;
        BlockState state;
        block3: {
            block2: {
                state = axle.getBlockState();
                Level level = axle.getLevel();
                Block block = state.getBlock();
                if (!(block instanceof BladedAxleBlock)) break block2;
                axleBlock = (BladedAxleBlock)block;
                if (level != null) break block3;
            }
            return;
        }
        Direction.Axis axis = (Direction.Axis)state.getValue((Property)BladedAxleBlock.AXIS);
        AxleBlockEntityRenderer.renderAxle(stack, bufferSource, axleBlock, axis, packedLight, packedOverlay, -axle.getRotationAngle(partialTick));
        BladedAxleBlockEntityRenderer.renderBlade(stack, bufferSource, axis, packedLight, packedOverlay, -axle.getRotationAngle(partialTick));
    }
}

