/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.common.blockentities.rotation.CrankshaftBlockEntity;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.rotation.ConnectedAxleBlock;
import net.dries007.tfc.common.blocks.rotation.CrankshaftBlock;
import net.dries007.tfc.common.blocks.rotation.FluidPumpBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.client.model.data.ModelData;

public class CrankshaftBlockEntityRenderer
implements BlockEntityRenderer<CrankshaftBlockEntity> {
    public static final ModelResourceLocation WHEEL_MODEL = RenderHelpers.modelId("block/crankshaft_wheel");
    public static final ResourceLocation ROD_TEXTURE = Helpers.identifier("block/metal/block/steel");
    public static final ResourceLocation PUMP_TEXTURE = Helpers.identifier("block/metal/smooth/brass");

    public void render(CrankshaftBlockEntity crankshaft, float partialTick, PoseStack stack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Level level = crankshaft.getLevel();
        BlockPos pos = crankshaft.getBlockPos();
        BlockState state = crankshaft.getBlockState();
        if (!(state.getBlock() instanceof CrankshaftBlock) || level == null) {
            return;
        }
        Direction face = (Direction)state.getValue(CrankshaftBlock.FACING);
        CrankshaftBlock.Part part = (CrankshaftBlock.Part)((Object)state.getValue(CrankshaftBlock.PART));
        if (part == CrankshaftBlock.Part.SHAFT && crankshaft.getRotationNode().rotation() == null) {
            BlockEntity mainPart = level.getBlockEntity(pos.relative(face, -1));
            if (!(mainPart instanceof CrankshaftBlockEntity)) {
                return;
            }
            CrankshaftBlockEntity mainEntity = (CrankshaftBlockEntity)mainPart;
            crankshaft = mainEntity;
        }
        VertexConsumer buffer = bufferSource.getBuffer(RenderType.cutout());
        float rotationAngle = CrankshaftBlockEntity.calculateRealRotationAngle(crankshaft, face, partialTick);
        RandomSource random = RandomSource.create();
        stack.pushPose();
        stack.translate(0.5f, 0.5f, 0.5f);
        stack.mulPose(Axis.YP.rotationDegrees(180.0f - 90.0f * (float)face.get2DDataValue()));
        if (part == CrankshaftBlock.Part.BASE) {
            stack.mulPose(Axis.XP.rotation(rotationAngle + (float)Math.PI));
            stack.translate(-0.5f, -0.5f, -0.5f);
            ModelBlockRenderer modelRenderer = Minecraft.getInstance().getBlockRenderer().getModelRenderer();
            BakedModel baked = Minecraft.getInstance().getModelManager().getModel(WHEEL_MODEL);
            modelRenderer.tesselateWithAO((BlockAndTintGetter)level, baked, crankshaft.getBlockState(), crankshaft.getBlockPos(), stack, buffer, true, random, (long)packedLight, packedOverlay, ModelData.EMPTY, RenderType.cutout());
            BlockState adjacentAxleState = level.getBlockState(crankshaft.getBlockPos().relative(face.getCounterClockWise()));
            Block block = adjacentAxleState.getBlock();
            if (block instanceof ConnectedAxleBlock) {
                ConnectedAxleBlock axleBlock = (ConnectedAxleBlock)block;
                if (crankshaft.getRotationNode().isConnectedToNetwork()) {
                    ResourceLocation axleTexture = axleBlock.getAxleTextureLocation();
                    TextureAtlasSprite axleSprite = RenderHelpers.blockTexture(axleTexture);
                    RenderHelpers.renderTexturedCuboid(stack, buffer, axleSprite, packedLight, packedOverlay, 0.0f, 0.375f, 0.375f, 0.375f, 0.625f, 0.625f, false);
                }
            }
        } else {
            stack.translate(-0.5f, -0.5f, -0.5f);
            TextureAtlasSprite rodSprite = RenderHelpers.blockTexture(ROD_TEXTURE);
            CrankshaftBlockEntity.ShaftMovement movement = CrankshaftBlockEntity.calculateShaftMovement(rotationAngle);
            float pistonLength = 1.03125f;
            float armLength = 0.75f;
            float armRadius = 0.0625f;
            float boxRadius = 0.125f;
            stack.translate(0.5625f, 0.5f, movement.lengthEH());
            RenderHelpers.renderTexturedCuboid(stack, buffer, rodSprite, packedLight, packedOverlay, -0.125f, -0.125f, -0.125f, 0.125f, 0.125f, 0.125f);
            RenderHelpers.renderTexturedCuboid(stack, buffer, rodSprite, packedLight, packedOverlay, -0.0625f, -0.0625f, -1.03125f, 0.0625f, 0.0625f, 0.0625f);
            BlockPos pumpPos = pos.relative(face);
            BlockState pumpState = level.getBlockState(pumpPos);
            if (pumpState.getBlock() == TFCBlocks.STEEL_PUMP.get() && face == pumpState.getValue(FluidPumpBlock.FACING)) {
                RenderHelpers.renderTexturedCuboid(stack, buffer, RenderHelpers.blockTexture(PUMP_TEXTURE), packedLight, packedOverlay, -0.125f, -0.125f, -1.125f, 0.125f, 0.125f, -0.875f);
            }
            stack.mulPose(Axis.XP.rotation(movement.raiseAngle()));
            RenderHelpers.renderTexturedCuboid(stack, buffer, rodSprite, packedLight, packedOverlay, -0.0625f, -0.0625f, -0.0625f, 0.0625f, 0.0625f, 0.8125f);
        }
        stack.popPose();
    }

    public boolean shouldRenderOffScreen(CrankshaftBlockEntity entity) {
        return true;
    }

    public AABB getRenderBoundingBox(CrankshaftBlockEntity blockEntity) {
        return AABB.INFINITE;
    }
}

