/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.common.component.TFCComponents;
import net.dries007.tfc.common.component.item.ItemComponent;
import net.dries007.tfc.util.data.Deposit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public class PanItemRenderer
extends BlockEntityWithoutLevelRenderer {
    public PanItemRenderer() {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext transforms, PoseStack poseStack, MultiBufferSource buffers, int packedLight, int packedOverlay) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        @Nullable Deposit deposit = Deposit.get(((ItemComponent)stack.getOrDefault(TFCComponents.DEPOSIT, (Object)ItemComponent.EMPTY)).stack());
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (deposit != null) {
            List<ResourceLocation> stages = deposit.modelStages();
            ResourceLocation location = stages.getFirst();
            if (player != null && transforms.firstPerson()) {
                int useTicks = player.getTicksUsingItem();
                location = stages.get(Mth.clamp((int)Math.round((float)useTicks / 120.0f * (float)stages.size()), (int)0, (int)(stages.size() - 1)));
            }
            BakedModel model = mc.getModelManager().getModel(RenderHelpers.modelId(location));
            poseStack.pushPose();
            mc.getBlockRenderer().getModelRenderer().renderModel(poseStack.last(), buffers.getBuffer(Sheets.solidBlockSheet()), null, model, 1.0f, 1.0f, 1.0f, packedLight, packedOverlay, ModelData.EMPTY, Sheets.solidBlockSheet());
            poseStack.popPose();
        }
    }
}

