/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.dries007.tfc.common.blockentities.ToolRackBlockEntity;
import net.dries007.tfc.common.blocks.wood.ToolRackBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.ItemStackHandler;

public class ToolRackBlockEntityRenderer
implements BlockEntityRenderer<ToolRackBlockEntity> {
    private static final float[][][] ITEM_LOCATION = new float[4][4][3];
    private static final float[] META_TO_ANGLE = new float[]{180.0f, 90.0f, 0.0f, 270.0f};
    private static final float ITEM_SCALE = 0.5f;

    public void render(ToolRackBlockEntity toolRack, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (toolRack.getLevel() == null) {
            return;
        }
        int meta = ((Direction)toolRack.getBlockState().getValue((Property)ToolRackBlock.FACING)).get2DDataValue();
        for (int i = 0; i < 4; ++i) {
            ItemStack stack = ((ItemStackHandler)toolRack.getInventory()).getStackInSlot(i);
            if (stack.isEmpty()) continue;
            poseStack.pushPose();
            poseStack.translate(ITEM_LOCATION[meta][i][0], ITEM_LOCATION[meta][i][1], ITEM_LOCATION[meta][i][2]);
            poseStack.mulPose(Axis.YP.rotationDegrees(META_TO_ANGLE[meta]));
            poseStack.scale(0.5f, 0.5f, 0.5f);
            Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, combinedLight, combinedOverlay, poseStack, buffer, toolRack.getLevel(), 0);
            poseStack.popPose();
        }
    }

    static {
        float heightLow = 0.28125f;
        float heightHigh = 0.78125f;
        float column1 = 0.25f;
        float column2 = 0.75f;
        float offset = 0.09375f;
        float offsetInv = 0.90625f;
        for (int dir = 0; dir < 4; ++dir) {
            for (int slot = 0; slot < 4; ++slot) {
                ToolRackBlockEntityRenderer.ITEM_LOCATION[dir][slot][1] = slot < 2 ? 0.78125f : 0.28125f;
                if (dir % 2 == 0) {
                    ToolRackBlockEntityRenderer.ITEM_LOCATION[dir][slot][0] = slot % 2 == 0 ? 0.25f : 0.75f;
                } else {
                    ToolRackBlockEntityRenderer.ITEM_LOCATION[dir][slot][2] = slot % 2 == 0 ? 0.25f : 0.75f;
                }
                if (dir == 0) {
                    ToolRackBlockEntityRenderer.ITEM_LOCATION[dir][slot][2] = 0.09375f;
                    continue;
                }
                if (dir == 1) {
                    ToolRackBlockEntityRenderer.ITEM_LOCATION[dir][slot][0] = 0.90625f;
                    continue;
                }
                if (dir == 2) {
                    ToolRackBlockEntityRenderer.ITEM_LOCATION[dir][slot][2] = 0.90625f;
                    continue;
                }
                ToolRackBlockEntityRenderer.ITEM_LOCATION[dir][slot][0] = 0.09375f;
            }
        }
    }
}

