/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.model.entity.VaneModel;
import net.dries007.tfc.common.blockentities.VaneBlockEntity;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;

public class VaneBlockEntityRenderer
implements BlockEntityRenderer<VaneBlockEntity> {
    public static final ResourceLocation TEXTURE = Helpers.identifier("textures/entity/vane.png");
    private final VaneModel model;

    public VaneBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new VaneModel(context.bakeLayer(RenderHelpers.layerId("vane")));
    }

    public void render(VaneBlockEntity vane, float partialTick, PoseStack stack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        if (vane.getLevel() == null) {
            return;
        }
        stack.pushPose();
        stack.translate(0.5f, -0.0f, 0.5f);
        stack.translate(0.0f, 1.5f, 0.0f);
        stack.scale(-1.0f, -1.0f, 1.0f);
        if (((Boolean)vane.getBlockState().getValue((Property)TFCBlockStateProperties.ATTACHED_WIND_DEVICES)).booleanValue()) {
            stack.translate(0.0f, 0.5625f, 0.0f);
        } else {
            this.model.renderBase(stack, buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)TEXTURE)), packedLight, packedOverlay, -1);
        }
        this.model.setupAnim(vane, partialTick);
        this.model.renderToBuffer(stack, buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)TEXTURE)), packedLight, packedOverlay, -1);
        stack.popPose();
    }
}

