/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.model.entity.WaterWheelModel;
import net.dries007.tfc.common.blockentities.rotation.WaterWheelBlockEntity;
import net.dries007.tfc.common.blocks.rotation.WaterWheelBlock;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class WaterWheelBlockEntityRenderer
implements BlockEntityRenderer<WaterWheelBlockEntity> {
    private final WaterWheelModel model;

    public WaterWheelBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new WaterWheelModel(context.bakeLayer(RenderHelpers.layerId("water_wheel")));
    }

    public void render(WaterWheelBlockEntity wheel, float partialTick, PoseStack stack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Block block = wheel.getBlockState().getBlock();
        assert (block instanceof WaterWheelBlock);
        @Nullable ResourceLocation texture = ((WaterWheelBlock)block).getTextureLocation();
        if (wheel.getLevel() == null || texture == null) {
            return;
        }
        stack.pushPose();
        stack.translate(0.5f, -0.5f, 0.5f);
        if (wheel.getBlockState().getValue(WaterWheelBlock.AXIS) == Direction.Axis.Z) {
            stack.mulPose(Axis.YN.rotationDegrees(90.0f));
        }
        this.model.setupAnim(wheel, partialTick);
        this.model.renderToBuffer(stack, buffer.getBuffer(RenderType.entityCutout((ResourceLocation)texture)), packedLight, packedOverlay, -1);
        stack.popPose();
    }

    public boolean shouldRenderOffScreen(WaterWheelBlockEntity entity) {
        return true;
    }

    public AABB getRenderBoundingBox(WaterWheelBlockEntity blockEntity) {
        return AABB.INFINITE;
    }
}

