/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.model.entity.JavelinModel;
import net.dries007.tfc.common.blocks.rock.RockCategory;
import net.dries007.tfc.common.entities.misc.ThrownJavelin;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;

public class ThrownJavelinRenderer
extends EntityRenderer<ThrownJavelin> {
    public static final ResourceLocation DEFAULT_TEXTURE = Helpers.identifier("textures/entity/projectiles/stone_javelin.png");
    public static final Map<Item, ResourceLocation> JAVELIN_TEXTURES = (Map)Util.make(new HashMap(), map -> {
        TFCItems.ROCK_TOOLS.forEach((k, v) -> map.put((Item)((TFCItems.ItemId)v.get((Object)RockCategory.ItemType.JAVELIN)).get(), Helpers.identifier("textures/entity/projectiles/stone_javelin.png")));
        TFCItems.METAL_ITEMS.entrySet().stream().filter(e -> ((Map)e.getValue()).containsKey((Object)Metal.ItemType.JAVELIN)).forEach(e -> map.put((Item)((TFCItems.ItemId)((Map)e.getValue()).get((Object)Metal.ItemType.JAVELIN)).get(), Helpers.identifier("textures/entity/projectiles/" + ((Metal)e.getKey()).getSerializedName() + "_javelin.png")));
    });
    private final JavelinModel model;

    public ThrownJavelinRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new JavelinModel(context.bakeLayer(RenderHelpers.layerId("javelin")));
    }

    public void render(ThrownJavelin javelin, float ageInTicks, float pitch, PoseStack poseStack, MultiBufferSource buffers, int packedLight) {
        poseStack.pushPose();
        float degrees = Mth.lerp((float)pitch, (float)javelin.yRotO, (float)javelin.getYRot()) - 90.0f;
        poseStack.mulPose(Axis.YP.rotationDegrees(degrees));
        float degrees1 = Mth.lerp((float)pitch, (float)javelin.xRotO, (float)javelin.getXRot()) + 90.0f;
        poseStack.mulPose(Axis.ZP.rotationDegrees(degrees1));
        VertexConsumer buffer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)buffers, (RenderType)this.model.renderType(this.getTextureLocation(javelin)), (boolean)false, (boolean)javelin.isEnchantGlowing());
        this.model.renderToBuffer(poseStack, buffer, packedLight, OverlayTexture.NO_OVERLAY, -1);
        poseStack.popPose();
        super.render((Entity)javelin, ageInTicks, pitch, poseStack, buffers, packedLight);
    }

    public ResourceLocation getTextureLocation(ThrownJavelin entity) {
        return JAVELIN_TEXTURES.getOrDefault(entity.getItem().getItem(), DEFAULT_TEXTURE);
    }
}

