/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.client.screen.BlockEntityScreen;
import net.dries007.tfc.client.screen.button.AnvilPlanButton;
import net.dries007.tfc.client.screen.button.AnvilStepButton;
import net.dries007.tfc.common.blockentities.AnvilBlockEntity;
import net.dries007.tfc.common.component.forge.ForgeRule;
import net.dries007.tfc.common.component.forge.ForgeStep;
import net.dries007.tfc.common.component.forge.Forging;
import net.dries007.tfc.common.container.AnvilContainer;
import net.dries007.tfc.common.recipes.AnvilRecipe;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.Level;

public class AnvilScreen
extends BlockEntityScreen<AnvilBlockEntity, AnvilContainer> {
    public static final ResourceLocation BACKGROUND = Helpers.identifier("textures/gui/anvil.png");

    public AnvilScreen(AnvilContainer container, Inventory playerInventory, Component name) {
        super(container, playerInventory, name, BACKGROUND);
        this.inventoryLabelY += 41;
        this.imageHeight += 41;
    }

    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new AnvilPlanButton((AnvilBlockEntity)this.blockEntity, this.getGuiLeft(), this.getGuiTop()));
        for (ForgeStep step : ForgeStep.VALUES) {
            this.addRenderableWidget((GuiEventListener)new AnvilStepButton(step, this.getGuiLeft(), this.getGuiTop()));
        }
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(graphics, partialTicks, mouseX, mouseY);
        Level level = ((AnvilBlockEntity)this.blockEntity).getLevel();
        int guiLeft = this.getGuiLeft();
        int guiTop = this.getGuiTop();
        if (TerraFirmaCraft.JEI) {
            graphics.blit(this.texture, guiLeft + 26, guiTop + 24, 0, 207, 9, 14);
        }
        assert (level != null);
        Forging forging = ((AnvilBlockEntity)this.blockEntity).getMainInputForging();
        int progress = forging.work();
        graphics.blit(this.texture, guiLeft + 13 + progress, guiTop + 100, 176, 0, 5, 5);
        int target = forging.target();
        graphics.blit(this.texture, guiLeft + 13 + target, guiTop + 94, 181, 0, 5, 5);
        AnvilRecipe recipe = forging.getRecipe();
        if (recipe != null) {
            List<ForgeRule> rules = recipe.getRules();
            for (int i = 0; i < rules.size(); ++i) {
                ForgeRule rule = rules.get(i);
                if (rule == null) continue;
                int xOffset = i * 19;
                graphics.blit(this.texture, guiLeft + 64 + xOffset, guiTop + 10, 10, 10, (float)rule.iconX(), (float)rule.iconY(), 32, 32, 256, 256);
                if (forging.matches(rule)) {
                    RenderSystem.setShaderColor((float)0.0f, (float)0.6f, (float)0.2f, (float)1.0f);
                } else {
                    RenderSystem.setShaderColor((float)1.0f, (float)0.4f, (float)0.0f, (float)1.0f);
                }
                graphics.blit(this.texture, guiLeft + 59 + xOffset, guiTop + 7, 198, rule.overlayY(), 20, 22);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        int index = 0;
        for (ForgeStep step : forging.lastSteps()) {
            graphics.blit(this.texture, guiLeft + 102 - index * 19, guiTop + 31, 10, 10, (float)step.iconX(), (float)step.iconY(), 32, 32, 256, 256);
            ++index;
        }
    }

    protected void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        AnvilRecipe recipe;
        super.renderTooltip(graphics, mouseX, mouseY);
        Level level = ((AnvilBlockEntity)this.blockEntity).getLevel();
        Forging forging = ((AnvilBlockEntity)this.blockEntity).getMainInputForging();
        if (level != null && (recipe = forging.getRecipe()) != null) {
            List<ForgeRule> rules = recipe.getRules();
            for (int i = 0; i < rules.size(); ++i) {
                ForgeRule rule = rules.get(i);
                if (rule == null) continue;
                int xOffset = i * 19;
                int x = this.getGuiLeft() + 64 + xOffset;
                int y = this.getGuiTop() + 10;
                if (mouseX <= x || mouseX >= x + 10 || mouseY <= y || mouseY >= y + 10) continue;
                graphics.renderTooltip(this.font, rule.getDescriptionId(), mouseX, mouseY);
            }
        }
    }
}

