/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.screen;

import java.util.Objects;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.screen.BlockEntityScreen;
import net.dries007.tfc.client.screen.button.BarrelSealButton;
import net.dries007.tfc.common.blockentities.BarrelBlockEntity;
import net.dries007.tfc.common.blocks.devices.BarrelBlock;
import net.dries007.tfc.common.container.BarrelContainer;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.tooltip.Tooltips;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class BarrelScreen
extends BlockEntityScreen<BarrelBlockEntity, BarrelContainer> {
    private static final Component SEAL = Component.translatable((String)"tfc.tooltip.seal_barrel");
    private static final Component UNSEAL = Component.translatable((String)"tfc.tooltip.unseal_barrel");
    private static final int MAX_RECIPE_NAME_LENGTH = 100;
    public static final ResourceLocation BACKGROUND = Helpers.identifier("textures/gui/barrel.png");

    public BarrelScreen(BarrelContainer container, Inventory playerInventory, Component name) {
        super(container, playerInventory, name, BACKGROUND);
        this.inventoryLabelY += 12;
        this.imageHeight += 12;
    }

    public void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new BarrelSealButton((BarrelBlockEntity)this.blockEntity, this.getGuiLeft(), this.getGuiTop(), this.isSealed() ? UNSEAL : SEAL));
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderLabels(graphics, mouseX, mouseY);
        if (this.isSealed()) {
            this.drawDisabled(graphics, 0, 2);
            @Nullable Component recipe = ((BarrelBlockEntity)this.blockEntity).getRecipeTooltip();
            if (recipe != null) {
                if (this.font.width((FormattedText)recipe) > 100) {
                    int line = 0;
                    for (FormattedCharSequence text : this.font.split((FormattedText)recipe, 100)) {
                        int n = 70 + Math.floorDiv(100 - this.font.width(text), 2);
                        Objects.requireNonNull(this.font);
                        graphics.drawString(this.font, text, n, this.titleLabelY + line * 9, 0x404040, false);
                        ++line;
                    }
                } else {
                    graphics.drawString(this.font, recipe.getString(), 70 + Math.floorDiv(100 - this.font.width((FormattedText)recipe), 2), 61, 0x404040, false);
                }
            }
            String date = Calendars.CLIENT.getExactTimeAndDate(((BarrelBlockEntity)this.blockEntity).getSealedTick()).getString();
            graphics.drawString(this.font, date, this.imageWidth / 2 - this.font.width(date) / 2, 74, 0x404040, false);
        }
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        FluidStack fluidStack;
        super.renderBg(graphics, partialTicks, mouseX, mouseY);
        if (TerraFirmaCraft.JEI) {
            graphics.blit(this.texture, this.getGuiLeft() + 92, this.getGuiTop() + 21, 227, 0, 9, 14);
        }
        if (!(fluidStack = ((BarrelBlockEntity.BarrelInventory)((BarrelBlockEntity)this.blockEntity).getInventory()).getFluidInTank(0)).isEmpty()) {
            TextureAtlasSprite sprite = RenderHelpers.getAndBindFluidSprite(fluidStack);
            int fillHeight = (int)Math.ceil(50.0f * (float)fluidStack.getAmount() / (float)TFCConfig.SERVER.barrelCapacity.get().intValue());
            RenderHelpers.fillAreaWithSprite(graphics, sprite, this.leftPos + 8, this.topPos + 70 - fillHeight, 16, fillHeight, 16, 16);
            this.resetToBackgroundSprite();
        }
        graphics.blit(this.texture, this.getGuiLeft() + 7, this.getGuiTop() + 19, 176, 0, 18, 52);
    }

    protected void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        FluidStack fluid;
        super.renderTooltip(graphics, mouseX, mouseY);
        int relX = mouseX - this.getGuiLeft();
        int relY = mouseY - this.getGuiTop();
        if (relX >= 7 && relY >= 19 && relX < 25 && relY < 71 && !(fluid = ((BarrelBlockEntity.BarrelInventory)((BarrelBlockEntity)this.blockEntity).getInventory()).getFluidInTank(0)).isEmpty()) {
            graphics.renderTooltip(this.font, (Component)Tooltips.fluidUnitsOf(fluid), mouseX, mouseY);
        }
    }

    private boolean isSealed() {
        return (Boolean)((BarrelBlockEntity)this.blockEntity).getBlockState().getValue((Property)BarrelBlock.SEALED);
    }
}

