/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.screen;

import java.util.ArrayList;
import java.util.List;
import net.dries007.tfc.client.screen.ScreenParticle;
import net.dries007.tfc.client.screen.TFCContainerScreen;
import net.dries007.tfc.client.screen.button.KnappingButton;
import net.dries007.tfc.common.container.KnappingContainer;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.data.KnappingType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class KnappingScreen
extends TFCContainerScreen<KnappingContainer> {
    public static final ResourceLocation BACKGROUND = Helpers.identifier("textures/gui/knapping.png");
    private final ResourceLocation buttonLocation;
    @Nullable
    private final ResourceLocation buttonDisabledLocation;
    private final List<ScreenParticle> particles = new ArrayList<ScreenParticle>();

    public static ResourceLocation getHighTexture(ItemStack stack) {
        return KnappingScreen.getButtonLocation(stack.getItem(), false);
    }

    @Nullable
    public static ResourceLocation getLowTexture(KnappingType type, ItemStack stack) {
        return type.hasOffTexture() ? KnappingScreen.getButtonLocation(stack.getItem(), true) : null;
    }

    public static ResourceLocation getButtonLocation(Item item, boolean disabled) {
        return Helpers.identifier("textures/gui/knapping/" + BuiltInRegistries.ITEM.getKey((Object)item).getPath() + (disabled ? "_disabled" : "") + ".png");
    }

    public KnappingScreen(KnappingContainer container, Inventory inv, Component name) {
        super(container, inv, name, BACKGROUND);
        this.imageHeight = 186;
        this.inventoryLabelY += 22;
        this.titleLabelY -= 2;
        ItemStack stack = container.getOriginalStack();
        this.buttonLocation = KnappingScreen.getHighTexture(stack);
        this.buttonDisabledLocation = KnappingScreen.getLowTexture(container.getKnappingType(), stack);
    }

    protected void init() {
        super.init();
        for (int x = 0; x < 5; ++x) {
            for (int y = 0; y < 5; ++y) {
                int bx = (this.width - this.getXSize()) / 2 + 12 + 16 * x;
                int by = (this.height - this.getYSize()) / 2 + 12 + 16 * y;
                this.addRenderableWidget((GuiEventListener)new KnappingButton(x + 5 * y, bx, by, 16, 16, this.buttonLocation, ((KnappingContainer)this.menu).getKnappingType().clickSound(), this::spawnParticles));
            }
        }
        ((KnappingContainer)this.menu).setRequiresReset(true);
    }

    private void spawnParticles(Button button) {
        if (button instanceof KnappingButton) {
            KnappingButton knappingButton = (KnappingButton)button;
            if (((KnappingContainer)this.menu).getKnappingType().spawnsParticles() && TFCConfig.CLIENT.enableScreenParticles.get().booleanValue() && Minecraft.useFancyGraphics()) {
                RandomSource random = Minecraft.getInstance().font.random;
                int amount = Mth.nextInt((RandomSource)random, (int)0, (int)3);
                for (int i = 0; i < amount; ++i) {
                    ScreenParticle particle = new ScreenParticle(knappingButton.getTexture(), button.getX(), button.getY(), Mth.nextFloat((RandomSource)random, (float)-0.1f, (float)0.1f), Mth.nextFloat((RandomSource)random, (float)1.2f, (float)1.5f), 16, 16, random);
                    this.particles.add(particle);
                }
            }
        }
    }

    protected void containerTick() {
        super.containerTick();
        for (ScreenParticle particle : this.particles) {
            particle.tick();
        }
        this.particles.removeIf(ScreenParticle::shouldBeRemoved);
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        KnappingButton button;
        if (((KnappingContainer)this.menu).requiresReset()) {
            for (Renderable widget : this.renderables) {
                if (!(widget instanceof KnappingButton)) continue;
                button = (KnappingButton)widget;
                button.visible = ((KnappingContainer)this.menu).getPattern().get(button.id);
            }
            ((KnappingContainer)this.menu).setRequiresReset(false);
        }
        super.renderBg(graphics, partialTicks, mouseX, mouseY);
        for (Renderable widget : this.renderables) {
            if (!(widget instanceof KnappingButton)) continue;
            button = (KnappingButton)widget;
            if (button.visible) {
                graphics.blit(this.buttonLocation, button.getX(), button.getY(), 0.0f, 0.0f, 16, 16, 16, 16);
                continue;
            }
            if (this.buttonDisabledLocation == null) continue;
            graphics.blit(this.buttonDisabledLocation, button.getX(), button.getY(), 0.0f, 0.0f, 16, 16, 16, 16);
        }
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        for (ScreenParticle particle : this.particles) {
            particle.render(graphics);
        }
    }

    public boolean mouseDragged(double x, double y, int clickType, double dragX, double dragY) {
        if (clickType == 0) {
            this.mouseClicked(x, y, clickType);
        }
        return super.mouseDragged(x, y, clickType, dragX, dragY);
    }

    public boolean mouseClicked(double x, double y, int clickType) {
        if (clickType == 0) {
            this.undoAccidentalButtonPress(x, y);
        }
        return super.mouseClicked(x, y, clickType);
    }

    private void undoAccidentalButtonPress(double x, double y) {
        for (Renderable widget : this.renderables) {
            KnappingButton button;
            if (!(widget instanceof KnappingButton) || !(button = (KnappingButton)widget).isMouseOver(x, y)) continue;
            ((KnappingContainer)this.menu).getPattern().set(button.id, false);
        }
    }
}

