/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.common.entities.livestock.pet.TamableMammal;
import net.dries007.tfc.network.PetCommandPacket;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;

public class PetCommandScreen
extends Screen {
    private final TamableMammal entity;

    public PetCommandScreen(TamableMammal entity) {
        super((Component)Component.translatable((String)"tfc.screen.pet_command"));
        this.entity = entity;
    }

    protected void init() {
        super.init();
        int y = 72;
        for (TamableMammal.Command command : TamableMammal.Command.VALUES) {
            if (!this.entity.willListenTo(command, true)) continue;
            MutableComponent comp = Helpers.translateEnum(command);
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)comp, b -> {
                PacketDistributor.sendToServer((CustomPacketPayload)new PetCommandPacket((Entity)this.entity, command), (CustomPacketPayload[])new CustomPacketPayload[0]);
                Minecraft.getInstance().setScreen(null);
                Player player = ClientHelpers.getPlayer();
                if (player != null) {
                    player.containerMenu = player.inventoryMenu;
                }
            }).bounds(this.width / 2 - 100, this.height / 4 + y, 200, 20).build());
            y += 24;
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = graphics.pose();
        graphics.fillGradient(0, 0, this.width, this.height, -1072689136, -804253680);
        poseStack.pushPose();
        poseStack.scale(2.0f, 2.0f, 2.0f);
        graphics.drawCenteredString(this.font, this.title, this.width / 2 / 2, 30, 0xFFFFFF);
        poseStack.popPose();
        super.render(graphics, mouseX, mouseY, partialTick);
        for (Renderable widget : this.renderables) {
            Button button;
            if (!(widget instanceof Button) || !(button = (Button)widget).isHoveredOrFocused()) continue;
            graphics.renderTooltip(this.font, button.getMessage(), mouseX, mouseY);
            return;
        }
    }

    public boolean isPauseScreen() {
        return false;
    }
}

