/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.screen.BlockEntityScreen;
import net.dries007.tfc.common.blockentities.PotBlockEntity;
import net.dries007.tfc.common.component.heat.Heat;
import net.dries007.tfc.common.container.PotContainer;
import net.dries007.tfc.common.recipes.outputs.PotOutput;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.tooltip.BlockEntityTooltip;
import net.dries007.tfc.util.tooltip.Tooltips;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.InventoryMenu;
import net.neoforged.neoforge.fluids.FluidStack;

public class PotScreen
extends BlockEntityScreen<PotBlockEntity, PotContainer> {
    private static final ResourceLocation BACKGROUND = Helpers.identifier("textures/gui/fire_pit_cooking_pot.png");

    public PotScreen(PotContainer container, Inventory playerInventory, Component name) {
        super(container, playerInventory, name, BACKGROUND);
        this.inventoryLabelY += 20;
        this.imageHeight += 20;
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderLabels(graphics, mouseX, mouseY);
        if (((PotBlockEntity)this.blockEntity).shouldRenderAsBoiling()) {
            this.drawDisabled(graphics, 4, 8);
        }
        MutableComponent text = Component.empty();
        if (((PotBlockEntity)this.blockEntity).shouldRenderAsBoiling()) {
            text.append((Component)Component.translatable((String)"tfc.tooltip.pot_boiling"));
        } else if (((PotBlockEntity)this.blockEntity).getOutput() != null && !((PotBlockEntity)this.blockEntity).getOutput().isEmpty()) {
            BlockEntityTooltip tooltip = ((PotBlockEntity)this.blockEntity).getOutput().getTooltip();
            if (tooltip != null && ((PotBlockEntity)this.blockEntity).getLevel() != null) {
                ArrayList fakeTooltip = new ArrayList();
                tooltip.display(((PotBlockEntity)this.blockEntity).getLevel(), ((PotBlockEntity)this.blockEntity).getBlockState(), ((PotBlockEntity)this.blockEntity).getBlockPos(), this.blockEntity, fakeTooltip::add);
                text.append((Component)fakeTooltip.get(0));
            } else {
                text.append((Component)Component.translatable((String)"tfc.tooltip.pot_finished"));
            }
        }
        int x = 118 - this.font.width((FormattedText)text) / 2;
        graphics.drawString(this.font, (Component)text, x, 80, 0x404040, false);
    }

    protected void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        MutableComponent text;
        FluidStack fluid;
        super.renderTooltip(graphics, mouseX, mouseY);
        if (RenderHelpers.isInside(mouseX, mouseY, this.getGuiLeft() + 121, this.getGuiTop() + 30, 41, 28) && !(fluid = ((PotBlockEntity.PotInventory)((PotBlockEntity)this.blockEntity).getInventory()).getFluidInTank(0)).isEmpty()) {
            graphics.renderTooltip(this.font, (Component)Tooltips.fluidUnitsAndCapacityOf(fluid, 1000), mouseX, mouseY);
        }
        if (RenderHelpers.isInside(mouseX, mouseY, this.leftPos + 30, this.topPos + 76 - 51, 15, 51) && (text = TFCConfig.CLIENT.heatTooltipStyle.get().formatColored(((PotBlockEntity)this.blockEntity).getTemperature())) != null) {
            graphics.renderTooltip(this.font, (Component)text, mouseX, mouseY);
        }
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        FluidStack fluid;
        int temp;
        super.renderBg(graphics, partialTicks, mouseX, mouseY);
        if (TerraFirmaCraft.JEI) {
            graphics.blit(this.texture, this.getGuiLeft() + 77, this.getGuiTop() + 6, 247, 0, 9, 14);
        }
        if ((temp = Heat.scaleTemperatureForGui(((PotBlockEntity)this.blockEntity).getTemperature())) > 0) {
            graphics.blit(this.texture, this.leftPos + 30, this.topPos + 76 - Math.min(51, temp), 176, 0, 15, 5);
        }
        if (((PotBlockEntity)this.blockEntity).getTemperature() > 0.0f) {
            graphics.blit(BACKGROUND, this.leftPos + 121, this.topPos + 58, 192, 0, 13, 13);
            graphics.blit(BACKGROUND, this.leftPos + 136, this.topPos + 58, 192, 0, 13, 13);
            graphics.blit(BACKGROUND, this.leftPos + 151, this.topPos + 58, 192, 0, 13, 13);
        }
        if (((PotBlockEntity)this.blockEntity).shouldRenderAsBoiling()) {
            int ticks = ((PotBlockEntity)this.blockEntity).getBoilingTicks() % 35;
            int vHeight = Mth.ceil((float)((float)ticks / 35.0f * 20.0f));
            graphics.blit(BACKGROUND, this.leftPos + 131, this.topPos + 10 + 20 - vHeight, 193, 37 - vHeight, 11, vHeight);
            graphics.blit(BACKGROUND, this.leftPos + 144, this.topPos + 10 + 20 - vHeight, 193, 37 - vHeight, 11, vHeight);
        }
        int fluidColor = -1;
        PotOutput output = ((PotBlockEntity)this.blockEntity).getOutput();
        if (output != null && !output.isEmpty()) {
            if (output.getRenderTexture() != null) {
                TextureAtlasSprite sprite = RenderHelpers.blockTexture(output.getRenderTexture());
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
                RenderHelpers.fillAreaWithSprite(graphics, sprite, this.leftPos + 133, this.topPos + 33, 20, 6, 16, 16);
                RenderHelpers.fillAreaWithSprite(graphics, sprite, this.leftPos + 131, this.topPos + 35, 2, 2, 16, 16);
                RenderHelpers.fillAreaWithSprite(graphics, sprite, this.leftPos + 153, this.topPos + 35, 2, 2, 16, 16);
                return;
            }
            fluidColor = output.getFluidColor();
        }
        if (fluidColor == -1 && !(fluid = ((PotBlockEntity.PotInventory)((PotBlockEntity)this.blockEntity).getInventory()).getFluidInTank(0)).isEmpty()) {
            fluidColor = RenderHelpers.getFluidColor(fluid);
        }
        if (fluidColor != -1) {
            RenderHelpers.setShaderColor(graphics, fluidColor);
            graphics.blit(BACKGROUND, this.leftPos + 131, this.topPos + 33, 208, 0, 24, 6);
            this.resetToBackgroundSprite();
        }
    }
}

