/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.stream.Stream;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.container.ScribingTableContainer;
import net.dries007.tfc.network.ScribingTablePacket;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.ItemCombinerScreen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.network.PacketDistributor;

public class ScribingTableScreen
extends ItemCombinerScreen<ScribingTableContainer> {
    private static final ResourceLocation TEXTURE = Helpers.identifier("textures/gui/scribing_table.png");
    private static final float ITEM_ROTATE_TIME = 50.0f;
    private EditBox name;
    private List<Item> valid;
    private int currentIndex = 0;
    private float currentTime = 0.0f;

    public ScribingTableScreen(ScribingTableContainer container, Inventory playerInv, Component name) {
        super((ItemCombinerMenu)container, playerInv, name, TEXTURE);
        this.titleLabelX = 60;
        this.valid = List.of();
    }

    protected void subInit() {
        this.name = new EditBox(this.font, this.leftPos + 62, this.topPos + 24, 103, 12, (Component)Component.translatable((String)"container.repair"));
        this.name.setCanLoseFocus(false);
        this.name.setTextColor(-1);
        this.name.setTextColorUneditable(-1);
        this.name.setBordered(false);
        this.name.setMaxLength(50);
        this.name.setResponder(this::onNameChanged);
        this.name.setValue("");
        this.addWidget((GuiEventListener)this.name);
        this.setInitialFocus((GuiEventListener)this.name);
        this.name.setEditable(false);
        this.valid = Stream.concat(Helpers.allItems(TFCTags.Items.SCRIBING_INK), Helpers.allFluids(TFCTags.Fluids.USABLE_IN_SCRIBING_TABLE).map(Fluid::getBucket)).toList();
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String text = this.name.getValue();
        this.init(minecraft, width, height);
        this.name.setValue(text);
        if (((ScribingTableContainer)this.menu).getSlot(0).hasItem()) {
            this.setFocused((GuiEventListener)this.name);
            this.name.setEditable(true);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.minecraft.player.closeContainer();
        }
        return this.name.keyPressed(keyCode, scanCode, modifiers) || this.name.canConsumeInput() || super.keyPressed(keyCode, scanCode, modifiers);
    }

    private void onNameChanged(String text) {
        if (!text.isEmpty()) {
            Slot slot = ((ScribingTableContainer)this.menu).getSlot(0);
            if (slot.hasItem() && !slot.getItem().has(DataComponents.CUSTOM_NAME) && text.equals(slot.getItem().getHoverName().getString())) {
                text = "";
            }
            ((ScribingTableContainer)this.menu).setItemName(text);
            PacketDistributor.sendToServer((CustomPacketPayload)new ScribingTablePacket(text), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        RenderSystem.disableBlend();
        super.renderLabels(graphics, mouseX, mouseY);
        if (((ScribingTableContainer)this.menu).getSlot(0).hasItem()) {
            MutableComponent component = null;
            if (!((ScribingTableContainer)this.menu).getSlot(1).hasItem()) {
                component = Component.translatable((String)"tfc.tooltip.scribing_table.missing_ink");
            } else if (!ScribingTableContainer.isInkInput(((ScribingTableContainer)this.menu).getSlot(1).getItem())) {
                component = Component.translatable((String)"tfc.tooltip.scribing_table.invalid_ink");
            }
            if (component != null) {
                int k = this.imageWidth - 8 - this.font.width((FormattedText)component) - 2;
                graphics.fill(k - 2, 67, this.imageWidth - 8, 79, 0x4F000000);
                graphics.drawString(this.font, (Component)component, k, 69, 0xFF6060, false);
            }
        }
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(graphics, partialTicks, mouseX, mouseY);
        this.currentTime += partialTicks;
        if (this.currentTime > 50.0f) {
            this.currentTime %= 50.0f;
            this.currentIndex = (this.currentIndex + 1) % this.valid.size();
        }
        Slot itemSlot = ((ScribingTableContainer)this.menu).getSlot(0);
        Slot inkSlot = ((ScribingTableContainer)this.menu).getSlot(1);
        if (itemSlot.hasItem()) {
            graphics.blit(TEXTURE, this.leftPos + 59, this.topPos + 20, 0, 166, 110, 16);
            if (!ScribingTableContainer.isInkInput(inkSlot.getItem())) {
                this.renderErrorIcon(graphics, mouseX, mouseY);
            }
        } else {
            graphics.blit(TEXTURE, this.leftPos + 59, this.topPos + 20, 0, 182, 110, 16);
        }
        if (!inkSlot.hasItem()) {
            graphics.setColor(1.0f, 1.0f, 1.0f, 0.25f);
            graphics.renderItem(this.valid.get(this.currentIndex).getDefaultInstance(), this.leftPos + 76, this.topPos + 47);
            graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public void renderFg(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.name.render(graphics, mouseX, mouseY, partialTicks);
    }

    public void slotChanged(AbstractContainerMenu menu, int slot, ItemStack stack) {
        if (slot == 0) {
            this.name.setValue(stack.isEmpty() ? "" : stack.getHoverName().getString());
            this.name.setEditable(!stack.isEmpty());
            this.setFocused((GuiEventListener)this.name);
        }
    }

    protected void renderErrorIcon(GuiGraphics graphics, int mouseX, int mouseY) {
        if ((((ScribingTableContainer)this.menu).getSlot(0).hasItem() || ((ScribingTableContainer)this.menu).getSlot(1).hasItem()) && !((ScribingTableContainer)this.menu).getSlot(((ScribingTableContainer)this.menu).getResultSlot()).hasItem()) {
            graphics.blit(TEXTURE, this.getGuiLeft() + 99, this.getGuiTop() + 45, this.imageWidth, 0, 28, 21);
        }
    }

    protected void renderTooltip(GuiGraphics graphics, int x, int y) {
        super.renderTooltip(graphics, x, y);
        if (this.hoveredSlot != null && this.hoveredSlot.index == 1 && !this.hoveredSlot.hasItem()) {
            ItemStack hintItem = this.valid.get(this.currentIndex).getDefaultInstance();
            graphics.renderTooltip(this.font, hintItem.getTooltipLines(Item.TooltipContext.EMPTY, null, (TooltipFlag)TooltipFlag.NORMAL), hintItem.getTooltipImage(), hintItem, x, y);
        }
    }
}

