/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.screen;

import java.util.ArrayList;
import java.util.List;
import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.screen.TFCContainerScreen;
import net.dries007.tfc.client.screen.button.LegacyImageButton;
import net.dries007.tfc.common.container.SewingTableContainer;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.common.recipes.SewingRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.network.ScreenButtonPacket;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.function.TriFunction;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Nullable;

public class SewingTableScreen
extends TFCContainerScreen<SewingTableContainer> {
    public static final ResourceLocation TEXTURE = Helpers.identifier("textures/gui/sewing.png");
    private static final int X_OFFSET = 10;
    private static final int Y_OFFSET = 16;
    private static final int RECIPES_PER_PAGE = 16;
    private final List<SewingRecipe> recipes = new ArrayList<SewingRecipe>();
    private boolean showRecipes = false;
    @Nullable
    private SewingRecipe selectedRecipe = null;
    private int startIndex = 0;

    public static void forEachStitch(TriFunction<Integer, Integer, Integer, Boolean> action) {
        int i = 0;
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 9; ++x) {
                if (((Boolean)action.apply((Object)x, (Object)y, (Object)i)).booleanValue()) {
                    return;
                }
                ++i;
            }
        }
    }

    public static void forEachClothSquare(TriConsumer<Integer, Integer, Integer> action) {
        int i = 0;
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 8; ++x) {
                action.accept((Object)x, (Object)y, (Object)i);
                ++i;
            }
        }
    }

    public SewingTableScreen(SewingTableContainer menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title, TEXTURE);
        this.imageHeight += 30;
        this.inventoryLabelY += 30;
        --this.titleLabelY;
    }

    protected void init() {
        super.init();
        this.createButton(this.leftPos + 125, this.topPos + 13, 20, 20, 236, 0, 20, 0, "tfc.tooltip.sewing.dark_cloth");
        this.createButton(this.leftPos + 150, this.topPos + 13, 20, 20, 236, 40, 20, 1, "tfc.tooltip.sewing.light_cloth");
        this.createButton(this.leftPos + 125, this.topPos + 38, 20, 20, 236, 80, 20, 2, "tfc.tooltip.sewing.remove_stitch");
        this.createButton(this.leftPos + 150, this.topPos + 38, 20, 20, 236, 120, 20, 3, "tfc.tooltip.sewing.stitch");
        this.createButton(this.leftPos + 135, this.topPos + 63, 20, 18, 192, 96, 18, 5, "tfc.tooltip.sewing.select_recipe");
        SewingTableScreen.forEachClothSquare((TriConsumer<Integer, Integer, Integer>)((TriConsumer)(x, y, i) -> {
            int id = i + 100;
            this.createButton(this.getScreenX(x * 12 + 6), this.getScreenY(y * 12 + 6), 12, 12, 208, 32, 0, id, null);
        }));
        this.recipes.clear();
        for (RecipeHolder holder : RecipeHelpers.getRecipes(ClientHelpers.getLevelOrThrow(), TFCRecipeTypes.SEWING)) {
            this.recipes.add((SewingRecipe)holder.value());
        }
    }

    private void createButton(int x, int y, int sizeX, int sizeY, int u, int v, int yDiffTex, int packetButtonId, @Nullable String translationKey) {
        LegacyImageButton button;
        if (translationKey != null) {
            button = new LegacyImageButton(x, y, sizeX, sizeY, u, v, yDiffTex, false, TEXTURE, btn -> {
                if (packetButtonId == 5) {
                    this.selectedRecipe = null;
                    this.showRecipes = !this.showRecipes;
                    return;
                }
                if (((SewingTableContainer)this.menu).getCarried().isEmpty() && !this.showRecipes) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new ScreenButtonPacket(packetButtonId), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }, (Component)Component.translatable((String)translationKey));
            button.setTooltip(Tooltip.create((Component)Component.translatable((String)translationKey)));
        } else {
            button = new LegacyImageButton(x, y, sizeX, sizeY, u, v, yDiffTex, true, TEXTURE, btn -> {
                if (((SewingTableContainer)this.menu).getCarried().isEmpty() && !this.showRecipes) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new ScreenButtonPacket(packetButtonId), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }, CommonComponents.EMPTY);
        }
        this.addRenderableWidget((GuiEventListener)button);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int sewX = this.getSewingX(mouseX);
        int sewY = this.getSewingY(mouseY);
        if (this.showRecipes && this.isSewing(mouseX, mouseY)) {
            int y2 = sewY / 16;
            int x2 = sewX / 16;
            int i2 = y2 * 6 + x2;
            if (i2 == 16) {
                if (this.hasLeftPage()) {
                    this.startIndex = Math.max(0, this.startIndex - 16);
                }
                this.playSound(SoundEvents.BOOK_PAGE_TURN);
            } else if (i2 == 17) {
                if (this.hasRightPage()) {
                    this.startIndex += 16;
                }
                this.playSound(SoundEvents.BOOK_PAGE_TURN);
            } else if (i2 + this.startIndex < this.recipes.size()) {
                this.selectedRecipe = this.recipes.get(i2 + this.startIndex);
                this.showRecipes = false;
                this.startIndex = 0;
                this.playSound(SoundEvents.UI_LOOM_SELECT_PATTERN);
                return true;
            }
        }
        int mat = ((SewingTableContainer)this.menu).getActiveMaterial();
        if (!this.showRecipes && this.isSewing(mouseX, mouseY) && (mat == 3 || mat == 2)) {
            SewingTableScreen.forEachStitch((TriFunction<Integer, Integer, Integer, Boolean>)((TriFunction)(x, y, i) -> {
                int topY;
                int leftX = x * 12 + 6;
                if (RenderHelpers.isInside(sewX + 6, sewY + 6, leftX, topY = y * 12 + 6, 12, 12) && (((SewingTableContainer)this.menu).getStitchAt((int)i) == 1 || mat == 3)) {
                    CompoundTag tag = new CompoundTag();
                    tag.putInt("id", i.intValue());
                    tag.putInt("stitchType", mat == 3 ? 1 : 0);
                    PacketDistributor.sendToServer((CustomPacketPayload)new ScreenButtonPacket(4, tag), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    return true;
                }
                return false;
            }));
            if (mat == 3) {
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected void slotClicked(Slot slot, int slotId, int mouseButton, ClickType type) {
        if (slotId == 4) {
            this.selectedRecipe = null;
        }
        super.slotClicked(slot, slotId, mouseButton, type);
    }

    public boolean mouseDragged(double x, double y, int clickType, double dragX, double dragY) {
        if (clickType == 0 && ((SewingTableContainer)this.menu).getActiveMaterial() != 3 && this.isSewing(x, y)) {
            this.mouseClicked(x, y, clickType);
        }
        return super.mouseDragged(x, y, clickType, dragX, dragY);
    }

    @Override
    public void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        super.renderBg(graphics, partialTick, mouseX, mouseY);
        SewingTableScreen.forEachClothSquare((TriConsumer<Integer, Integer, Integer>)((TriConsumer)(x, y, i) -> {
            int recipeMat;
            int mat = ((SewingTableContainer)this.menu).getPlacedMaterial((int)i);
            if (mat != -1) {
                graphics.blit(TEXTURE, this.getScreenX(x * 12 + 6), this.getScreenY(y * 12 + 6), 208, mat == 0 ? 16 : 0, 12, 12);
            } else if (this.selectedRecipe != null && (recipeMat = this.selectedRecipe.getSquare((int)i)) != -1) {
                graphics.blit(TEXTURE, this.getScreenX(x * 12 + 6), this.getScreenY(y * 12 + 6), 208, recipeMat == 0 ? 80 : 64, 12, 12);
            }
        }));
        SewingTableScreen.forEachStitch((TriFunction<Integer, Integer, Integer, Boolean>)((TriFunction)(x, y, i) -> {
            int stitch = ((SewingTableContainer)this.menu).getStitchAt((int)i);
            if (stitch == 1) {
                graphics.blit(TEXTURE, this.getScreenX(x * 12 + 6) - 2, this.getScreenY(y * 12 + 6) - 2, 2, 192.0f, 0.0f, 5, 5, 256, 256);
            } else if (this.selectedRecipe != null && this.selectedRecipe.getStitch((int)i)) {
                graphics.blit(TEXTURE, this.getScreenX(x * 12 + 6) - 2, this.getScreenY(y * 12 + 6) - 2, 2, 192.0f, 64.0f, 5, 5, 256, 256);
            }
            return false;
        }));
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderLabels(graphics, mouseX, mouseY);
        if (!((SewingTableContainer)this.menu).canPickup(0)) {
            SewingTableScreen.renderSlotHighlight((GuiGraphics)graphics, (int)8, (int)83, (int)1);
        }
        if (!((SewingTableContainer)this.menu).canPickup(2)) {
            SewingTableScreen.renderSlotHighlight((GuiGraphics)graphics, (int)62, (int)83, (int)1);
        }
        if (!((SewingTableContainer)this.menu).canPickup(3)) {
            SewingTableScreen.renderSlotHighlight((GuiGraphics)graphics, (int)80, (int)83, (int)1);
        }
        if (!((SewingTableContainer)this.menu).canPickup(1)) {
            SewingTableScreen.renderSlotHighlight((GuiGraphics)graphics, (int)26, (int)83, (int)1);
        }
        if (((SewingTableContainer)this.menu).getCarried().isEmpty() && RenderHelpers.isInside(mouseX, mouseY, this.leftPos, this.topPos, this.imageWidth, this.imageHeight) && !this.showRecipes) {
            int mat = ((SewingTableContainer)this.menu).getActiveMaterial();
            if (mat == 0) {
                graphics.blit(TEXTURE, mouseX - this.leftPos, mouseY - this.topPos, 208, 16, 12, 12);
            } else if (mat == 1) {
                graphics.blit(TEXTURE, mouseX - this.leftPos, mouseY - this.topPos, 208, 0, 12, 12);
            } else if (mat == 2 || mat == 3) {
                graphics.blit(TEXTURE, mouseX - this.leftPos, mouseY - this.topPos, 208, 48, 16, 16);
            }
        }
        int burlapCount = ((SewingTableContainer)this.menu).getBurlapCount();
        int woolCount = ((SewingTableContainer)this.menu).getWoolCount();
        int yarnCount = ((SewingTableContainer)this.menu).getYarnCount();
        graphics.drawString(Minecraft.getInstance().font, String.valueOf(Math.min(burlapCount, 99)), 135, 25, burlapCount == 0 ? 0x404040 : 0xFFFFFF);
        graphics.drawString(Minecraft.getInstance().font, String.valueOf(Math.min(woolCount, 99)), 160, 25, woolCount == 0 ? 0x404040 : 0xFFFFFF);
        graphics.drawString(Minecraft.getInstance().font, String.valueOf(Math.min(yarnCount, 99)), 160, 48, yarnCount == 0 ? 0x404040 : 0xFFFFFF);
        if (this.showRecipes) {
            this.renderRecipes(graphics, mouseX, mouseY);
        }
    }

    private void renderRecipes(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.fillGradient(8, 14, 119, 77, -1072689136, -804253680);
        RegistryAccess access = ClientHelpers.getLevelOrThrow().registryAccess();
        int max = this.startIndex + 16 + 2;
        for (int idx = this.startIndex; idx < max; ++idx) {
            int i = idx - this.startIndex;
            int x = i % 6 * 16 + 10;
            int y = i / 6 * 16 + 16;
            if (i == 16) {
                if (!this.hasLeftPage()) continue;
                graphics.blit(TEXTURE, x, y, 192, 144, 16, 16);
                continue;
            }
            if (i == 17) {
                if (!this.hasRightPage()) continue;
                graphics.blit(TEXTURE, x, y, 208, 144, 16, 16);
                continue;
            }
            if (idx >= this.recipes.size()) continue;
            SewingRecipe recipe = this.recipes.get(idx);
            ItemStack item = recipe.getResultItem((HolderLookup.Provider)access);
            graphics.renderItem(item, x, y, 1);
            if (!RenderHelpers.isInside(mouseX - this.leftPos, mouseY - this.topPos, x, y, 16, 16)) continue;
            graphics.renderTooltip(Minecraft.getInstance().font, item, x + 8, y + 8);
        }
    }

    private boolean hasLeftPage() {
        return this.startIndex > 0;
    }

    private boolean hasRightPage() {
        return this.startIndex + 16 < this.recipes.size();
    }

    private boolean isSewing(double mouseX, double mouseY) {
        return RenderHelpers.isInside((int)mouseX, (int)mouseY, 10 + this.leftPos, 16 + this.topPos, 107, 59);
    }

    private int getSewingX(double mouseX) {
        return (int)(mouseX - 10.0 - (double)this.leftPos);
    }

    private int getSewingY(double mouseY) {
        return (int)(mouseY - 16.0 - (double)this.topPos);
    }

    private int getScreenX(int posX) {
        return posX == -1 ? 0 : posX + 10 + this.leftPos;
    }

    private int getScreenY(int posY) {
        return posY == -1 ? 0 : posY + 16 + this.topPos;
    }

    private void playSound(SoundEvent sound) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)sound, (float)1.0f));
    }

    public void setRecipe(SewingRecipe recipe) {
        this.selectedRecipe = recipe;
        this.showRecipes = false;
        this.startIndex = 0;
    }
}

