/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common;

import net.dries007.tfc.common.LevelTier;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.SimpleTier;

public final class TFCTiers {
    public static final LevelTier IGNEOUS_INTRUSIVE = TFCTiers.create("igneous_intrusive", (TagKey<Block>)BlockTags.INCORRECT_FOR_WOODEN_TOOL, 0, 60, 4.7f, 2.0f, 5);
    public static final LevelTier IGNEOUS_EXTRUSIVE = TFCTiers.create("igneous_extrusive", (TagKey<Block>)BlockTags.INCORRECT_FOR_WOODEN_TOOL, 0, 70, 4.7f, 2.0f, 5);
    public static final LevelTier SEDIMENTARY = TFCTiers.create("sedimentary", (TagKey<Block>)BlockTags.INCORRECT_FOR_WOODEN_TOOL, 0, 50, 4.0f, 2.0f, 5);
    public static final LevelTier METAMORPHIC = TFCTiers.create("metamorphic", (TagKey<Block>)BlockTags.INCORRECT_FOR_WOODEN_TOOL, 0, 55, 4.35f, 2.0f, 5);
    public static final LevelTier COPPER = TFCTiers.create("copper", (TagKey<Block>)BlockTags.INCORRECT_FOR_STONE_TOOL, 1, 600, 5.25f, 3.25f, 8);
    public static final LevelTier BRONZE = TFCTiers.create("bronze", (TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL, 2, 1300, 7.3f, 4.0f, 13);
    public static final LevelTier BISMUTH_BRONZE = TFCTiers.create("bismuth_bronze", (TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL, 2, 1200, 6.65f, 4.0f, 10);
    public static final LevelTier BLACK_BRONZE = TFCTiers.create("black_bronze", (TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL, 2, 1460, 6.0f, 4.25f, 10);
    public static final LevelTier WROUGHT_IRON = TFCTiers.create("wrought_iron", (TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL, 3, 2200, 8.0f, 4.75f, 12);
    public static final LevelTier STEEL = TFCTiers.create("steel", (TagKey<Block>)BlockTags.INCORRECT_FOR_DIAMOND_TOOL, 4, 3300, 9.5f, 5.75f, 12);
    public static final LevelTier BLACK_STEEL = TFCTiers.create("black_steel", (TagKey<Block>)BlockTags.INCORRECT_FOR_NETHERITE_TOOL, 5, 4200, 11.0f, 7.0f, 17);
    public static final LevelTier BLUE_STEEL = TFCTiers.create("blue_steel", (TagKey<Block>)BlockTags.INCORRECT_FOR_NETHERITE_TOOL, 6, 6500, 12.0f, 9.0f, 22);
    public static final LevelTier RED_STEEL = TFCTiers.create("red_steel", (TagKey<Block>)BlockTags.INCORRECT_FOR_NETHERITE_TOOL, 6, 6500, 12.0f, 9.0f, 22);

    private static LevelTier create(String name, TagKey<Block> tag, int level, int uses, float speed, float damage, int enchantmentValue) {
        return new LeveledTier(tag, level, uses, speed, damage, enchantmentValue, name);
    }

    static class LeveledTier
    extends SimpleTier
    implements LevelTier {
        private final String name;
        private final int level;

        public LeveledTier(TagKey<Block> tag, int level, int uses, float speed, float damage, int enchantmentValue, String name) {
            super(tag, uses, speed, damage, enchantmentValue, () -> Ingredient.EMPTY);
            this.name = name;
            this.level = level;
        }

        @Override
        public int level() {
            return this.level;
        }

        public String toString() {
            return this.name;
        }
    }
}

