/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.client.particle.FluidParticleOption;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.BarrelInventoryCallback;
import net.dries007.tfc.common.blockentities.IRecipeTimer;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.blocks.devices.BarrelBlock;
import net.dries007.tfc.common.capabilities.DelegateFluidHandler;
import net.dries007.tfc.common.capabilities.DelegateItemHandler;
import net.dries007.tfc.common.capabilities.FluidTankCallback;
import net.dries007.tfc.common.capabilities.InventoryFluidTank;
import net.dries007.tfc.common.capabilities.InventoryItemHandler;
import net.dries007.tfc.common.capabilities.PartialFluidHandler;
import net.dries007.tfc.common.capabilities.PartialItemHandler;
import net.dries007.tfc.common.capabilities.SidedHandler;
import net.dries007.tfc.common.component.CachedMut;
import net.dries007.tfc.common.component.TFCComponents;
import net.dries007.tfc.common.component.block.BarrelComponent;
import net.dries007.tfc.common.component.fluid.FluidContainerInfo;
import net.dries007.tfc.common.component.size.IItemSize;
import net.dries007.tfc.common.component.size.ItemSizeManager;
import net.dries007.tfc.common.component.size.Size;
import net.dries007.tfc.common.component.size.Weight;
import net.dries007.tfc.common.container.BarrelContainer;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.recipes.BarrelRecipe;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.common.recipes.SealedBarrelRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.input.NonEmptyInput;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.CalendarTransaction;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendarTickable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BarrelBlockEntity
extends TickableInventoryBlockEntity<BarrelInventory>
implements ICalendarTickable,
BarrelInventoryCallback,
IRecipeTimer {
    public static final int SLOT_FLUID_CONTAINER_IN = 0;
    public static final int SLOT_FLUID_CONTAINER_OUT = 1;
    public static final int SLOT_ITEM = 2;
    public static final int SLOTS = 3;
    private final SidedHandler<IFluidHandler> sidedFluidInventory;
    private final CachedMut<RecipeHolder<SealedBarrelRecipe>> recipe = CachedMut.empty();
    private long lastUpdateTick = Integer.MIN_VALUE;
    private long sealedTick;
    private long recipeTick;
    private int soundCooldownTicks = 0;
    private boolean needsInstantRecipeUpdate;

    public static void serverTick(Level level, BlockPos pos, BlockState state, BarrelBlockEntity barrel) {
        List<ItemStack> excess;
        barrel.getRecipe();
        barrel.checkForLastTickSync();
        barrel.checkForCalendarUpdate();
        if (level.getGameTime() % 5L == 0L) {
            barrel.updateFluidIOSlots();
        }
        if (!(excess = ((BarrelInventory)barrel.inventory).excess).isEmpty() && ((BarrelInventory)barrel.inventory).getStackInSlot(2).isEmpty()) {
            ((BarrelInventory)barrel.inventory).setStackInSlot(2, excess.remove(0));
        }
        SealedBarrelRecipe recipe = barrel.getRecipe();
        boolean sealed = (Boolean)state.getValue((Property)BarrelBlock.SEALED);
        Direction facing = (Direction)state.getValue(BarrelBlock.FACING);
        if (recipe != null && sealed) {
            int durationSealed = (int)(Calendars.SERVER.getTicks() - barrel.recipeTick);
            if (!recipe.isInfinite() && durationSealed > recipe.getDuration()) {
                if (recipe.matches((net.dries007.tfc.common.recipes.input.BarrelInventory)barrel.inventory)) {
                    recipe.assembleOutputs((net.dries007.tfc.common.recipes.input.BarrelInventory)barrel.inventory);
                    Helpers.playSound(level, barrel.getBlockPos(), recipe.getCompleteSound());
                }
                barrel.updateRecipe();
                barrel.markForSync();
                @Nullable SealedBarrelRecipe nextRecipe = barrel.getRecipe();
                if (nextRecipe != null) {
                    nextRecipe.onSealed((net.dries007.tfc.common.recipes.input.BarrelInventory)barrel.inventory);
                    if (recipe == nextRecipe) {
                        barrel.resetTickTimer(level);
                    }
                }
            }
        }
        if (barrel.needsInstantRecipeUpdate) {
            barrel.needsInstantRecipeUpdate = false;
            if (((BarrelInventory)barrel.inventory).excess.isEmpty()) {
                RecipeHolder instantRecipe = BarrelRecipe.get(level, TFCRecipeTypes.BARREL_INSTANT, (net.dries007.tfc.common.recipes.input.BarrelInventory)barrel.inventory);
                if (instantRecipe == null) {
                    instantRecipe = BarrelRecipe.get(level, TFCRecipeTypes.BARREL_INSTANT_FLUID, (net.dries007.tfc.common.recipes.input.BarrelInventory)barrel.inventory);
                }
                if (instantRecipe != null) {
                    ((BarrelRecipe)instantRecipe.value()).assembleOutputs((net.dries007.tfc.common.recipes.input.BarrelInventory)barrel.inventory);
                    if (barrel.soundCooldownTicks == 0) {
                        Helpers.playSound(level, barrel.getBlockPos(), ((BarrelRecipe)instantRecipe.value()).getCompleteSound());
                        barrel.soundCooldownTicks = 5;
                        if (((BarrelRecipe)instantRecipe.value()).getCompleteSound() == SoundEvents.FIRE_EXTINGUISH && level instanceof ServerLevel) {
                            ServerLevel server = (ServerLevel)level;
                            double x = (double)pos.getX() + 0.5;
                            double y = pos.getY();
                            double z = (double)pos.getZ() + 0.5;
                            RandomSource random = level.getRandom();
                            server.sendParticles((ParticleOptions)((SimpleParticleType)TFCParticles.BUBBLE.get()), x + (double)random.nextFloat() * 0.375 - 0.1875, y + 0.9375, z + (double)random.nextFloat() * 0.375 - 0.1875, 6, 0.0, 0.0, 0.0, 1.0);
                            server.sendParticles((ParticleOptions)((SimpleParticleType)TFCParticles.STEAM.get()), x + (double)random.nextFloat() * 0.375 - 0.1875, y + 0.9375, z + (double)random.nextFloat() * 0.375 - 0.1875, 6, 0.0, 0.0, 0.0, 1.0);
                        }
                    }
                }
                barrel.markForSync();
            }
        }
        if (barrel.soundCooldownTicks > 0) {
            --barrel.soundCooldownTicks;
        }
        if (level.getGameTime() % 20L == 0L && !sealed && facing == Direction.UP) {
            Helpers.gatherAndConsumeItems(level, new AABB(0.25, 0.0625, 0.25, 0.75, 0.9375, 0.75).move(pos), (IItemHandler)barrel.inventory, 2, 2);
        }
        barrel.tickPouring(level, pos, sealed, facing);
        if (!sealed && facing == Direction.UP && level.getGameTime() % 4L == 0L && level.isRainingAt(pos.above())) {
            ((BarrelInventory)barrel.inventory).fill(new FluidStack((Fluid)Fluids.WATER, 1), IFluidHandler.FluidAction.EXECUTE);
            barrel.markForSync();
        }
    }

    public BarrelBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.BARREL.get(), pos, state, BarrelInventory::new);
        this.sidedFluidInventory = new SidedHandler<IFluidHandler>((IFluidHandler)this.inventory);
        if (TFCConfig.SERVER.barrelEnableAutomation.get().booleanValue()) {
            Direction facing = state.hasProperty(BarrelBlock.FACING) ? (Direction)state.getValue(BarrelBlock.FACING) : Direction.UP;
            boolean vertical = facing == Direction.UP;
            this.sidedInventory.on(new PartialItemHandler(this.inventory).insert(0).extract(1), (Predicate<Direction>)(vertical ? Direction.Plane.HORIZONTAL : d -> d.getAxis() != facing.getAxis() && d.getAxis().isHorizontal())).on(new PartialItemHandler(this.inventory).insert(2), facing).on(new PartialItemHandler(this.inventory).extract(2), facing.getOpposite());
            this.sidedFluidInventory.on((IFluidHandler)((Function<IFluidHandler, IFluidHandler>)PartialFluidHandler::insertOnly), vertical ? Direction.UP : facing.getOpposite()).on(PartialFluidHandler::extractOnly, vertical ? d -> d != Direction.UP : d -> d == facing);
        }
    }

    @Nullable
    public IFluidHandler getSidedFluidInventory(@Nullable Direction context) {
        return this.sidedFluidInventory.get(context);
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
        return BarrelContainer.create(this, player.getInventory(), containerId);
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        this.needsInstantRecipeUpdate = true;
        this.updateRecipe();
        this.setChanged();
    }

    @Override
    public void fluidTankChanged() {
        this.needsInstantRecipeUpdate = true;
        this.updateRecipe();
        this.setChanged();
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return switch (slot) {
            case 0 -> Helpers.mightHaveCapability(stack, Capabilities.FluidHandler.ITEM);
            case 2 -> {
                IItemSize size = ItemSizeManager.get(stack);
                if (size.getSize(stack).isSmallerThan(Size.HUGE) || size.getWeight(stack).isSmallerThan(Weight.VERY_HEAVY)) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    @Override
    public void onCalendarUpdate(long ticks) {
        assert (this.level != null);
        try (CalendarTransaction tr = Calendars.SERVER.transaction();){
            tr.add(-ticks);
            this.updateRecipe();
        }
        @Nullable SealedBarrelRecipe recipe = this.getRecipe();
        if (!((Boolean)this.getBlockState().getValue((Property)BarrelBlock.SEALED)).booleanValue() || recipe == null || recipe.isInfinite()) {
            return;
        }
        long currentTick = Calendars.SERVER.getTicks();
        for (long lastKnownTick = this.recipeTick + (long)recipe.getDuration(); lastKnownTick < currentTick; lastKnownTick += (long)recipe.getDuration()) {
            long offset = currentTick - lastKnownTick;
            assert (offset >= 0L);
            try (CalendarTransaction tr = Calendars.SERVER.transaction();){
                tr.add(-offset);
                if (recipe.matches((net.dries007.tfc.common.recipes.input.BarrelInventory)this.inventory)) {
                    recipe.assembleOutputs((net.dries007.tfc.common.recipes.input.BarrelInventory)this.inventory);
                }
                this.updateRecipe();
                this.markForSync();
            }
            @Nullable SealedBarrelRecipe knownRecipe = this.getRecipe();
            if (knownRecipe == null) {
                return;
            }
            knownRecipe.onSealed((net.dries007.tfc.common.recipes.input.BarrelInventory)this.inventory);
            if (!knownRecipe.isInfinite()) continue;
            return;
        }
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.putLong("lastUpdateTick", this.lastUpdateTick);
        nbt.putLong("sealedTick", this.sealedTick);
        nbt.putLong("recipeTick", this.recipeTick);
        super.saveAdditional(nbt, provider);
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        this.lastUpdateTick = nbt.getLong("lastUpdateTick");
        this.sealedTick = nbt.getLong("sealedTick");
        this.recipeTick = nbt.getLong("recipeTick");
        this.recipe.unload();
        super.loadAdditional(nbt, provider);
    }

    @Override
    protected void applyImplicitComponents(BlockEntity.DataComponentInput components) {
        BarrelComponent barrel = (BarrelComponent)components.getOrDefault(TFCComponents.BARREL, (Object)BarrelComponent.EMPTY);
        if (!barrel.isEmpty()) {
            Iterator<ItemStack> iter = barrel.itemContent().iterator();
            ((BarrelInventory)this.inventory).setStackInSlot(2, iter.next());
            while (iter.hasNext()) {
                ((BarrelInventory)this.inventory).excess.add(iter.next());
            }
            ((BarrelInventory)this.inventory).tank.setFluid(barrel.fluidContent().copy());
            this.sealedTick = barrel.sealedTick();
            this.recipeTick = barrel.recipeTick();
        }
        super.applyImplicitComponents(components);
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        if (((Boolean)this.getBlockState().getValue((Property)BarrelBlock.SEALED)).booleanValue()) {
            ImmutableList.Builder inventoryList = ImmutableList.builderWithExpectedSize((int)(1 + ((BarrelInventory)this.inventory).excess.size()));
            inventoryList.add((Object)((BarrelInventory)this.inventory).getStackInSlot(2).copy());
            Helpers.copyTo((ImmutableList.Builder<ItemStack>)inventoryList, ((BarrelInventory)this.inventory).excess);
            builder.set(TFCComponents.BARREL, (Object)new BarrelComponent((List<ItemStack>)inventoryList.build(), ((BarrelInventory)this.inventory).tank.getFluid().copy(), this.sealedTick, this.recipeTick));
        }
        super.collectImplicitComponents(builder);
    }

    @Override
    @Deprecated
    public long getLastCalendarUpdateTick() {
        return this.lastUpdateTick;
    }

    @Override
    @Deprecated
    public void setLastCalendarUpdateTick(long tick) {
        this.lastUpdateTick = tick;
    }

    @Override
    public int getRecipeDuration() {
        @Nullable SealedBarrelRecipe recipe = this.getRecipe();
        return recipe != null ? recipe.getDuration() : 0;
    }

    @Override
    public long getRemainingTime() {
        return this.getRemainingTicks();
    }

    @Override
    public void ejectInventory() {
        super.ejectInventory();
        assert (this.level != null);
        ((BarrelInventory)this.inventory).excess.stream().filter(item -> !item.isEmpty()).forEach(item -> Helpers.spawnItem(this.level, this.worldPosition, item));
        FluidStack fluid = ((BarrelInventory)this.inventory).tank.getFluid();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (!fluid.isEmpty()) {
                double fill = (double)((BarrelInventory)this.inventory).getFluidInTank(0).getAmount() / (double)((BarrelInventory)this.inventory).getTankCapacity(0);
                VoxelShape shape = this.getBlockState().getShape((BlockGetter)this.level, this.worldPosition);
                Helpers.playSound(this.level, this.worldPosition, SoundEvents.PLAYER_SPLASH);
                int i = 0;
                while ((double)i < Math.ceil(25.0 * fill)) {
                    RandomSource random = server.getRandom();
                    double xMax = shape.max(Direction.Axis.X);
                    double xMin = shape.min(Direction.Axis.X);
                    double zMax = shape.max(Direction.Axis.Z);
                    double zMin = shape.min(Direction.Axis.Z);
                    double dx = xMin + (xMax - xMin) * random.nextDouble();
                    double dy = shape.max(Direction.Axis.Y) * fill * random.nextDouble();
                    double dz = zMin + (zMax - zMin) * random.nextDouble();
                    server.sendParticles((ParticleOptions)new FluidParticleOption((ParticleType<FluidParticleOption>)((ParticleType)TFCParticles.BARREL_SPILL.get()), fluid.getFluid()), (double)this.worldPosition.getX() + dx, (double)this.worldPosition.getY() + dy, (double)this.worldPosition.getZ() + dz, 1, 0.0, 0.0, 0.0, 1.0);
                    ++i;
                }
            }
        }
    }

    public void tickPouring(Level level, BlockPos pos, boolean sealed, Direction facing) {
        IFluidHandler fluidHandler;
        BlockPos faucetPos;
        if (!sealed && !((BarrelInventory)this.inventory).tank.isEmpty() && facing != Direction.UP && level.getBlockState(faucetPos = pos.relative(facing)).isAir() && (fluidHandler = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, faucetPos.below(), (Object)Direction.UP)) != null && FluidHelpers.transferExact((IFluidHandler)((BarrelInventory)this.inventory).tank, fluidHandler, 1) && level.getGameTime() % 12L == 0L && level instanceof ServerLevel) {
            double dx;
            ServerLevel server = (ServerLevel)level;
            Fluid fluid = ((BarrelInventory)this.inventory).tank.getFluid().getFluid();
            double offset = 0.6;
            double d = facing.getStepX() > 0 ? 0.6 : (dx = facing.getStepX() < 0 ? -0.6 : 0.0);
            double dz = facing.getStepZ() > 0 ? 0.6 : (facing.getStepZ() < 0 ? -0.6 : 0.0);
            Helpers.playSound(level, pos, (SoundEvent)TFCSounds.BARREL_DRIP.get());
            server.sendParticles((ParticleOptions)new FluidParticleOption((ParticleType<FluidParticleOption>)((ParticleType)TFCParticles.BARREL_DRIP.get()), fluid), (double)((float)pos.getX() + 0.5f) + dx, (double)((float)pos.getY() + 0.125f), (double)((float)pos.getZ() + 0.5f) + dz, 1, 0.0, 0.0, 0.0, 1.0);
        }
    }

    public void onSeal() {
        assert (this.level != null);
        if (!this.level.isClientSide()) {
            Helpers.spawnItem(this.level, this.worldPosition, Helpers.removeStack((IItemHandler)this.inventory, 0));
            Helpers.spawnItem(this.level, this.worldPosition, Helpers.removeStack((IItemHandler)this.inventory, 1));
        }
        this.sealedTick = Calendars.get((LevelReader)this.level).getTicks();
        this.updateRecipe();
        @Nullable SealedBarrelRecipe recipe = this.getRecipe();
        if (recipe != null) {
            recipe.onSealed((net.dries007.tfc.common.recipes.input.BarrelInventory)this.inventory);
            this.recipeTick = this.sealedTick;
        }
        this.markForSync();
        Helpers.playSound(this.level, this.worldPosition, (SoundEvent)TFCSounds.CLOSE_BARREL.get());
    }

    public void onUnseal() {
        assert (this.level != null);
        this.sealedTick = 0L;
        this.recipeTick = 0L;
        @Nullable SealedBarrelRecipe recipe = this.getRecipe();
        if (recipe != null) {
            recipe.onUnsealed((net.dries007.tfc.common.recipes.input.BarrelInventory)this.inventory);
        }
        this.updateRecipe();
        this.markForSync();
        Helpers.playSound(this.level, this.worldPosition, (SoundEvent)TFCSounds.OPEN_BARREL.get());
    }

    @Override
    public boolean canModify() {
        return (Boolean)this.getBlockState().getValue((Property)BarrelBlock.SEALED) == false;
    }

    private void updateFluidIOSlots() {
        assert (this.level != null);
        ItemStack input = ((BarrelInventory)this.inventory).getStackInSlot(0);
        if (!input.isEmpty() && ((BarrelInventory)this.inventory).getStackInSlot(1).isEmpty()) {
            FluidHelpers.transferBetweenBlockEntityAndItem(input, this, this.level, this.worldPosition, (newOriginalStack, newContainerStack) -> {
                if (newContainerStack.isEmpty()) {
                    ((BarrelInventory)this.inventory).setStackInSlot(0, ItemStack.EMPTY);
                    ((BarrelInventory)this.inventory).setStackInSlot(1, newOriginalStack);
                } else {
                    ((BarrelInventory)this.inventory).setStackInSlot(0, newOriginalStack);
                    ((BarrelInventory)this.inventory).setStackInSlot(1, newContainerStack);
                }
            });
        }
    }

    private void updateRecipe() {
        assert (this.level != null);
        @Nullable SealedBarrelRecipe oldRecipe = RecipeHelpers.unbox(this.recipe.value());
        this.recipe.unload();
        @Nullable SealedBarrelRecipe newRecipe = this.getRecipe();
        if (oldRecipe != null && newRecipe != null && oldRecipe != newRecipe) {
            this.resetTickTimer(this.level);
        }
    }

    private void resetTickTimer(Level level) {
        this.recipeTick = Calendars.get((LevelReader)level).getTicks();
        this.markForSync();
    }

    @Nullable
    public SealedBarrelRecipe getRecipe() {
        assert (this.level != null);
        if (!this.recipe.isLoaded()) {
            this.recipe.load(((BarrelInventory)this.inventory).excess.isEmpty() ? BarrelRecipe.get(this.level, TFCRecipeTypes.BARREL_SEALED, (net.dries007.tfc.common.recipes.input.BarrelInventory)this.inventory) : null);
        }
        return RecipeHelpers.unbox(this.recipe.value());
    }

    @Nullable
    public Component getRecipeTooltip() {
        this.getRecipe();
        RecipeHolder<SealedBarrelRecipe> holder = this.recipe.value();
        return holder != null ? Component.translatable((String)("tfc.recipe.barrel." + holder.id().getNamespace() + "." + holder.id().getPath().replace('/', '.'))) : null;
    }

    public long getSealedTick() {
        return this.sealedTick;
    }

    public long getRecipeTick() {
        return this.recipeTick;
    }

    public long getRemainingTicks() {
        assert (this.level != null);
        @Nullable SealedBarrelRecipe recipe = this.getRecipe();
        return recipe != null ? (long)recipe.getDuration() - (Calendars.get((LevelReader)this.level).getTicks() - this.recipeTick) : 0L;
    }

    public static class BarrelInventory
    implements DelegateItemHandler,
    DelegateFluidHandler,
    NonEmptyInput,
    FluidTankCallback,
    net.dries007.tfc.common.recipes.input.BarrelInventory,
    INBTSerializable<CompoundTag> {
        public static final FluidContainerInfo INFO = new FluidContainerInfo(){

            @Override
            public boolean canContainFluid(Fluid input) {
                return Helpers.isFluid(input, TFCTags.Fluids.USABLE_IN_BARREL);
            }

            @Override
            public int fluidCapacity() {
                return TFCConfig.SERVER.barrelCapacity.get();
            }
        };
        private final BarrelInventoryCallback callback;
        private final InventoryItemHandler inventory;
        private final List<ItemStack> excess;
        private final InventoryFluidTank tank;
        private boolean mutable;

        BarrelInventory(InventoryBlockEntity<?> entity) {
            this((BarrelInventoryCallback)((Object)entity));
        }

        public BarrelInventory(BarrelInventoryCallback callback) {
            this.callback = callback;
            this.inventory = new InventoryItemHandler(callback, 3);
            this.excess = new ArrayList<ItemStack>();
            this.tank = new InventoryFluidTank(TFCConfig.SERVER.barrelCapacity.get(), stack -> Helpers.isFluid(stack.getFluid(), TFCTags.Fluids.USABLE_IN_BARREL), this);
        }

        @Override
        public void whileMutable(Runnable action) {
            try {
                this.mutable = true;
                action.run();
            }
            finally {
                this.mutable = false;
            }
        }

        @Override
        public void insertItemWithOverflow(ItemStack stack) {
            ItemStack remainder = this.inventory.insertItem(2, stack, false);
            if (!remainder.isEmpty()) {
                this.excess.add(remainder);
            }
        }

        @Override
        public IItemHandlerModifiable getItemHandler() {
            return this.inventory;
        }

        @Override
        public IFluidHandler getFluidHandler() {
            return this.tank;
        }

        @Override
        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return this.canModify() ? this.tank.fill(resource, action) : 0;
        }

        @Override
        @NotNull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return this.canModify() ? this.tank.drain(resource, action) : FluidStack.EMPTY;
        }

        @Override
        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return this.canModify() ? this.tank.drain(maxDrain, action) : FluidStack.EMPTY;
        }

        @Override
        @NotNull
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return this.canModify() ? this.inventory.insertItem(slot, stack, simulate) : stack;
        }

        @Override
        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.canModify() ? this.inventory.extractItem(slot, amount, simulate) : ItemStack.EMPTY;
        }

        @Override
        public boolean isItemValid(int slot, ItemStack stack) {
            return this.canModify() && DelegateItemHandler.super.isItemValid(slot, stack);
        }

        public CompoundTag serializeNBT(HolderLookup.Provider provider) {
            CompoundTag nbt = new CompoundTag();
            nbt.put("inventory", (Tag)this.inventory.serializeNBT(provider));
            nbt.put("tank", (Tag)this.tank.writeToNBT(provider, new CompoundTag()));
            nbt.put("excess", (Tag)Helpers.writeItemStacksToNbt(provider, this.excess));
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
            this.inventory.deserializeNBT(provider, nbt.getCompound("inventory"));
            this.tank.readFromNBT(provider, nbt.getCompound("tank"));
            Helpers.readItemStacksFromNbt(provider, this.excess, nbt.getList("excess", 10));
        }

        @Override
        public void fluidTankChanged() {
            this.callback.fluidTankChanged();
        }

        private boolean canModify() {
            return this.mutable || this.callback.canModify();
        }
    }
}

