/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TFCBlockEntity;
import net.dries007.tfc.common.blocks.BloomBlock;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BloomBlockEntity
extends TFCBlockEntity {
    public static final int TOTAL_LAYERS = 8;
    private ItemStack item = ItemStack.EMPTY;
    private int count = 0;
    private int maxCount;

    public BloomBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.BLOOM.get(), pos, state);
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (!this.item.isEmpty()) {
            tag.put("item", this.item.save(provider));
        }
        tag.putInt("count", this.count);
        tag.putInt("maxCount", this.maxCount);
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.item = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound("item"));
        this.count = tag.getInt("count");
        this.maxCount = tag.getInt("maxCount");
    }

    public void setBloom(ItemStack item, int count) {
        if (count > 0) {
            assert (this.level != null);
            this.item = item;
            this.count = count;
            this.maxCount = count;
            this.level.setBlockAndUpdate(this.worldPosition, this.getState());
        }
    }

    public boolean dropBloom() {
        assert (this.level != null);
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        BlockPos dropPos = this.worldPosition;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            cursor.setWithOffset((Vec3i)this.worldPosition, direction);
            if (!Helpers.isBlock(this.level.getBlockState((BlockPos)cursor), (Block)TFCBlocks.BLOOMERY.get())) continue;
            dropPos = cursor.immutable();
            break;
        }
        --this.count;
        ItemStack item = this.item.copy();
        item.setCount(1);
        Helpers.spawnItem(this.level, dropPos, item);
        return this.level.setBlock(this.worldPosition, this.getState(), this.level.isClientSide ? 11 : 3);
    }

    public BlockState getState() {
        assert (this.level != null);
        if (this.count <= 0) {
            return Blocks.AIR.defaultBlockState();
        }
        int layers = this.maxCount <= 8 ? this.count : Mth.clamp((int)(8 * this.count / this.maxCount), (int)1, (int)8);
        return (BlockState)this.getBlockState().setValue((Property)BloomBlock.LAYERS, (Comparable)Integer.valueOf(layers));
    }

    public ItemStack getItem() {
        return this.item;
    }

    public int getCount() {
        return this.count;
    }
}

