/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import java.util.Optional;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TFCBlockEntity;
import net.dries007.tfc.common.blocks.devices.ChannelBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Pair;

public class ChannelBlockEntity
extends TFCBlockEntity {
    private Optional<Pair<Direction, Byte>> flowSource = Optional.empty();
    private boolean isConnectedToAnotherChannel = false;
    private int numFlows = 0;
    private ResourceLocation fluid = ResourceLocation.fromNamespaceAndPath((String)"", (String)"");
    private static final byte NO_FLOW_BYTE = 99;

    protected ChannelBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.CHANNEL.get(), pos, state);
    }

    public boolean hasFlow() {
        return this.flowSource.isPresent();
    }

    public ResourceLocation getFluid() {
        return this.fluid;
    }

    public Pair<Direction, Byte> getFlowSource() {
        return this.flowSource.get();
    }

    public boolean isConnectedToAnotherChannel() {
        return this.isConnectedToAnotherChannel;
    }

    public int getNumberOfFlows() {
        return this.numFlows;
    }

    public void setLinkProperties(Pair<Direction, Byte> flowSource, boolean isConnectedToAnotherChannel, int numFlows, ResourceLocation fluid) {
        this.flowSource = Optional.of(flowSource);
        this.isConnectedToAnotherChannel = isConnectedToAnotherChannel;
        this.numFlows = numFlows;
        this.fluid = fluid;
        BlockState state = (BlockState)this.getBlockState().setValue((Property)ChannelBlock.WITH_METAL, (Comparable)Boolean.valueOf(this.hasFlow()));
        this.level.setBlock(this.worldPosition, state, 3);
        this.markForSync();
    }

    public void notifyBrokenLink(int linksBroken) {
        if (this.level == null) {
            return;
        }
        this.numFlows -= linksBroken;
        this.flowSource.ifPresent(fs -> this.level.getBlockEntity(this.worldPosition.relative((Direction)fs.getLeft(), (int)((Byte)fs.getRight()).byteValue()), (BlockEntityType)TFCBlockEntities.CHANNEL.get()).ifPresent(channel -> channel.notifyBrokenLink(linksBroken)));
        if (this.numFlows <= 0) {
            this.flowSource = Optional.empty();
            this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)ChannelBlock.WITH_METAL, (Comparable)Boolean.valueOf(false)), 3);
            this.markForSync();
        }
    }

    public boolean isLinkBroken() {
        if (this.flowSource.isEmpty()) {
            return true;
        }
        Direction expectedDirection = (Direction)this.flowSource.get().getLeft();
        byte expectedDistance = (Byte)this.flowSource.get().getRight();
        BlockPos expectedSourcePos = this.worldPosition.relative(expectedDirection, (int)expectedDistance);
        if (this.isConnectedToAnotherChannel) {
            Optional blockEntity = this.level.getBlockEntity(expectedSourcePos, (BlockEntityType)TFCBlockEntities.CHANNEL.get());
            if (blockEntity.isEmpty()) {
                return true;
            }
            for (byte i = 1; i < (Byte)this.flowSource.get().getRight(); i = (byte)(i + 1)) {
                BlockPos rel = this.worldPosition.relative((Direction)this.flowSource.get().getLeft(), (int)i);
                if (this.level.getBlockState(rel).isAir()) continue;
                return true;
            }
            return ((ChannelBlockEntity)((Object)blockEntity.get())).isLinkBroken();
        }
        Optional blockEntity = this.level.getBlockEntity(expectedSourcePos, (BlockEntityType)TFCBlockEntities.CRUCIBLE.get());
        return blockEntity.isEmpty();
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        this.numFlows = nbt.getByte("numFlowsOut");
        this.isConnectedToAnotherChannel = nbt.getBoolean("useLongRenderBox");
        byte flowSourceByte = nbt.getByte("flowSource");
        byte flowSourceDistance = nbt.contains("flowSourceDistance") ? nbt.getByte("flowSourceDistance") : (byte)1;
        this.flowSource = flowSourceByte != 99 ? Optional.of(Pair.of((Object)Helpers.DIRECTIONS[flowSourceByte], (Object)flowSourceDistance)) : Optional.empty();
        this.fluid = ResourceLocation.parse((String)nbt.getString("texture"));
        super.loadAdditional(nbt, provider);
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.putByte("numFlowsOut", (byte)this.numFlows);
        nbt.putBoolean("useLongRenderBox", this.isConnectedToAnotherChannel);
        nbt.putByte("flowSource", this.flowSource.map(directionBytePair -> (byte)((Direction)directionBytePair.getLeft()).ordinal()).orElse((byte)99).byteValue());
        nbt.putByte("flowSourceDistance", this.flowSource.isPresent() ? (Byte)this.flowSource.get().getRight() : (byte)1);
        nbt.putString("texture", this.fluid.toString());
        super.saveAdditional(nbt, provider);
    }
}

