/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TFCBlockEntity;
import net.dries007.tfc.common.blocks.crop.DoubleCropBlock;
import net.dries007.tfc.common.blocks.crop.ICropBlock;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendarTickable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class CropBlockEntity
extends TFCBlockEntity
implements ICalendarTickable {
    private float growth;
    private float nAbsorbed;
    private float pAbsorbed;
    private float kAbsorbed;
    private float yield;
    private float expiry;
    private long lastUpdateTick = Integer.MIN_VALUE;
    private long lastGrowthTick = Calendars.SERVER.getTicks();

    public static void serverTick(Level level, BlockPos pos, BlockState state, CropBlockEntity crop) {
        crop.checkForCalendarUpdate();
    }

    public static void serverTickBottomPartOnly(Level level, BlockPos pos, BlockState state, CropBlockEntity crop) {
        if (state.getValue(DoubleCropBlock.PART) == DoubleCropBlock.Part.BOTTOM) {
            crop.checkForCalendarUpdate();
        }
    }

    public CropBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TFCBlockEntities.CROP.get(), pos, state);
    }

    public CropBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void onCalendarUpdate(long ticks) {
        assert (this.level != null);
        BlockState state = this.level.getBlockState(this.worldPosition);
        Block block = state.getBlock();
        if (block instanceof ICropBlock) {
            ICropBlock crop = (ICropBlock)block;
            crop.growthTick(this.level, this.worldPosition, state, this);
        }
    }

    public float getGrowth() {
        return this.growth;
    }

    public float getYield() {
        return this.yield;
    }

    public float getNAbsorbed() {
        return this.nAbsorbed;
    }

    public float getPAbsorbed() {
        return this.pAbsorbed;
    }

    public float getKAbsorbed() {
        return this.kAbsorbed;
    }

    public float getExpiry() {
        return this.expiry;
    }

    public void setGrowth(float growth) {
        this.growth = growth;
        this.markForSync();
    }

    public void setYield(float yield) {
        this.yield = yield;
        this.markForSync();
    }

    public void setNAbsorbed(float n) {
        this.nAbsorbed = n;
        this.markForSync();
    }

    public void setPAbsorbed(float p) {
        this.pAbsorbed = p;
        this.markForSync();
    }

    public void setKAbsorbed(float k) {
        this.kAbsorbed = k;
        this.markForSync();
    }

    public void addNutrients(float n, float p, float k) {
        this.nAbsorbed += n;
        this.pAbsorbed += p;
        this.kAbsorbed += k;
        this.markForSync();
    }

    public void setExpiry(float expiry) {
        this.expiry = expiry;
        this.markForSync();
    }

    public long getLastGrowthTick() {
        return this.lastGrowthTick;
    }

    public void setLastGrowthTick(long lastGrowthTick) {
        this.lastGrowthTick = lastGrowthTick;
        this.markForSync();
    }

    @Override
    @Deprecated
    public long getLastCalendarUpdateTick() {
        return this.lastUpdateTick;
    }

    @Override
    @Deprecated
    public void setLastCalendarUpdateTick(long tick) {
        this.lastUpdateTick = tick;
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        this.growth = nbt.getFloat("growth");
        this.yield = nbt.getFloat("yield");
        this.expiry = nbt.getFloat("expiry");
        this.nAbsorbed = nbt.getFloat("n");
        this.pAbsorbed = nbt.getFloat("p");
        this.kAbsorbed = nbt.getFloat("k");
        this.lastUpdateTick = nbt.getLong("tick");
        this.lastGrowthTick = nbt.getLong("lastGrowthTick");
        super.loadAdditional(nbt, provider);
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.putFloat("growth", this.growth);
        nbt.putFloat("yield", this.yield);
        nbt.putFloat("expiry", this.expiry);
        nbt.putFloat("n", this.nAbsorbed);
        nbt.putFloat("p", this.pAbsorbed);
        nbt.putFloat("k", this.kAbsorbed);
        nbt.putLong("tick", this.lastUpdateTick);
        nbt.putLong("lastGrowthTick", this.lastGrowthTick);
        super.saveAdditional(nbt, provider);
    }
}

