/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import java.util.function.Consumer;
import net.dries007.tfc.common.blockentities.IFarmland;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TFCBlockEntity;
import net.dries007.tfc.common.blocks.soil.FarmlandBlock;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendar;
import net.dries007.tfc.util.calendar.ICalendarTickable;
import net.dries007.tfc.util.data.Fertilizer;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class FarmlandBlockEntity
extends TFCBlockEntity
implements IFarmland,
ICalendarTickable {
    private static final float MAX_ADDITIONAL_WATER = 15.0f;
    private long lastUpdateTick = Integer.MIN_VALUE;
    private long lastWaterTick = Calendars.SERVER.getTicks();
    private float nitrogen = 0.0f;
    private float phosphorous = 0.0f;
    private float potassium = 0.0f;
    private float additionalWater = 0.0f;

    public FarmlandBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TFCBlockEntities.FARMLAND.get(), pos, state);
    }

    protected FarmlandBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, FarmlandBlockEntity farmland) {
        farmland.checkForCalendarUpdate();
    }

    @Override
    public void waterTick() {
        assert (this.level != null);
        ICalendar calendar = Calendars.get((LevelReader)this.level);
        long firstCalendarTick = calendar.getCalendarTicks() + calendar.getFixedCalendarTicksFromTick(this.getLastWaterTick() - calendar.getTicks());
        long secondCalendarTick = calendar.getCalendarTicks() + calendar.getFixedCalendarTicksFromTick(Calendars.SERVER.getTicks() - calendar.getTicks());
        this.updateAdditionalWater(firstCalendarTick, secondCalendarTick);
        this.setLastWaterTick(Calendars.SERVER.getTicks());
    }

    @Override
    public void onCalendarUpdate(long ticks) {
        assert (this.level != null);
        BlockEntity entity = this.level.getBlockEntity(this.worldPosition);
        if (entity instanceof IFarmland) {
            this.waterTick();
        }
    }

    @Override
    @Deprecated
    public long getLastCalendarUpdateTick() {
        return this.lastUpdateTick;
    }

    @Override
    @Deprecated
    public void setLastCalendarUpdateTick(long tick) {
        this.lastUpdateTick = tick;
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        this.loadNutrientsWithoutSync(nbt);
        this.loadAdditionalWaterWithoutSync(nbt);
        this.lastUpdateTick = nbt.getLong("tick");
        this.lastWaterTick = nbt.getLong("waterTick");
        super.loadAdditional(nbt, provider);
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        this.saveNutrients(nbt);
        this.saveAdditionalWater(nbt);
        nbt.putLong("tick", this.lastUpdateTick);
        nbt.putLong("waterTick", this.lastWaterTick);
        super.saveAdditional(nbt, provider);
    }

    public void addHoeOverlayInfo(Level level, BlockPos pos, Consumer<Component> text, boolean includeHydration, boolean includeNutrients) {
        if (includeHydration) {
            ChunkData data = ChunkData.get((LevelReader)level, pos);
            int totalRainHydration = FarmlandBlock.getRainHydration(level, pos);
            int hydrationValue = FarmlandBlock.getHydrationFromRainHydration(level, pos, totalRainHydration);
            int minRainfallHydration = (int)data.getMinRainfallHydration(pos);
            int minHydrationValue = FarmlandBlock.getHydrationFromRainHydration(level, pos, minRainfallHydration);
            int maxRainfallHydration = (int)data.getMaxRainfallHydration(pos);
            int maxHydrationValue = FarmlandBlock.getHydrationFromRainHydration(level, pos, maxRainfallHydration);
            MutableComponent hydration = Component.translatable((String)"tfc.tooltip.farmland.hydration", (Object[])new Object[]{hydrationValue, minHydrationValue, maxHydrationValue});
            text.accept((Component)hydration);
        }
        if (includeNutrients) {
            this.addTooltipInfo(text);
        }
    }

    @Override
    public float getNutrient(NutrientType type) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.nitrogen;
            case 1 -> this.phosphorous;
            case 2 -> this.potassium;
        };
    }

    @Override
    public void setNutrient(NutrientType type, float value) {
        this.setNutrientWithoutSync(type, value);
        this.markForSync();
    }

    @Override
    public void addNutrients(Fertilizer fertilizer, float multiplier) {
        this.setNutrientWithoutSync(NutrientType.NITROGEN, this.getNutrient(NutrientType.NITROGEN) + fertilizer.nitrogen() * multiplier);
        this.setNutrientWithoutSync(NutrientType.PHOSPHOROUS, this.getNutrient(NutrientType.PHOSPHOROUS) + fertilizer.phosphorus() * multiplier);
        this.setNutrientWithoutSync(NutrientType.POTASSIUM, this.getNutrient(NutrientType.POTASSIUM) + fertilizer.potassium() * multiplier);
        this.markForSync();
    }

    @Override
    public void setNutrientWithoutSync(NutrientType type, float value) {
        value = Mth.clamp((float)value, (float)0.0f, (float)1.0f);
        switch (type.ordinal()) {
            case 0: {
                this.nitrogen = value;
                break;
            }
            case 1: {
                this.phosphorous = value;
                break;
            }
            case 2: {
                this.potassium = value;
            }
        }
    }

    @Override
    public float getAdditionalWater() {
        return this.additionalWater;
    }

    @Override
    public void setAdditionalWater(float additionalWater) {
        this.setAdditionalWaterWithoutSync(additionalWater);
        this.markForSync();
    }

    @Override
    public void setAdditionalWaterWithoutSync(float additionalWater) {
        this.additionalWater = Mth.clamp((float)additionalWater, (float)0.0f, (float)15.0f);
    }

    @Override
    public long getLastWaterTick() {
        return this.lastWaterTick;
    }

    @Override
    public void setLastWaterTick(long lastWaterTick) {
        this.lastWaterTick = lastWaterTick;
        this.markForSync();
    }

    public static enum NutrientType {
        NITROGEN,
        PHOSPHOROUS,
        POTASSIUM;

        public static final NutrientType[] VALUES;

        static {
            VALUES = NutrientType.values();
        }
    }
}

