/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickCounterBlockEntity;
import net.dries007.tfc.common.blocks.devices.LampBlock;
import net.dries007.tfc.common.capabilities.FluidTankCallback;
import net.dries007.tfc.common.capabilities.InventoryFluidTank;
import net.dries007.tfc.common.capabilities.SidedHandler;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.data.LampFuel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.Nullable;

public class LampBlockEntity
extends TickCounterBlockEntity
implements FluidTankCallback {
    protected FluidTank tank;
    private final SidedHandler<IFluidHandler> sidedFluidInventory;
    @Nullable
    private LampFuel cachedFuel;

    public LampBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.LAMP.get(), pos, state);
        this.tank = new InventoryFluidTank(TFCConfig.SERVER.lampCapacity.get(), stack -> LampFuel.get(stack.getFluid(), this.getBlockState()) != null, this);
        this.sidedFluidInventory = new SidedHandler<FluidTank>(this.tank);
    }

    @Override
    public void fluidTankChanged() {
        this.checkHasRanOut();
        this.markForSync();
    }

    @Nullable
    public LampFuel getFuel() {
        return LampFuel.get(this.tank.getFluid().getFluid(), this.getBlockState());
    }

    public void checkHasRanOut() {
        assert (this.level != null);
        BlockState state = this.getBlockState();
        if (!((Boolean)state.getValue((Property)LampBlock.LIT)).booleanValue()) {
            return;
        }
        @Nullable LampFuel fuel = this.getFuel();
        if (fuel == null) {
            if (this.cachedFuel == null || this.tank.isEmpty()) {
                this.resetCounter();
                this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue((Property)LampBlock.LIT, (Comparable)Boolean.valueOf(false)));
                return;
            }
            fuel = this.cachedFuel;
        } else {
            this.cachedFuel = fuel;
        }
        int usage = Mth.floor((double)((double)this.getTicksSinceUpdate() / (double)fuel.burnRate()));
        if (usage >= 1) {
            this.resetCounter();
            this.markForSync();
            FluidStack used = this.tank.drain(usage, IFluidHandler.FluidAction.EXECUTE);
            if (this.tank.isEmpty() || used.getAmount() < usage) {
                this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue((Property)LampBlock.LIT, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        this.tank.readFromNBT(provider, tag.getCompound("tank"));
        this.cachedFuel = this.getFuel();
        super.loadAdditional(tag, provider);
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        tag.put("tank", (Tag)this.tank.writeToNBT(provider, new CompoundTag()));
        super.saveAdditional(tag, provider);
    }

    @Nullable
    public IFluidHandler getSidedFluidInventory(@Nullable Direction context) {
        return this.sidedFluidInventory.get(context);
    }
}

