/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import java.util.List;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.blocks.devices.PowderkegBlock;
import net.dries007.tfc.common.blocks.devices.SealableDeviceBlock;
import net.dries007.tfc.common.capabilities.InventoryItemHandler;
import net.dries007.tfc.common.capabilities.PartialItemHandler;
import net.dries007.tfc.common.component.TFCComponents;
import net.dries007.tfc.common.component.item.ItemListComponent;
import net.dries007.tfc.common.container.PowderkegContainer;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.PowderKegExplosion;
import net.dries007.tfc.util.advancements.TFCAdvancements;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class PowderkegBlockEntity
extends TickableInventoryBlockEntity<PowderkegInventory> {
    public static final int SLOTS = 12;
    public static final int MAX_STRENGTH = 64;
    private int fuse = -1;
    private boolean isLit = false;
    @Nullable
    private Entity igniter;

    public static void serverTick(Level level, BlockPos pos, BlockState state, PowderkegBlockEntity powderkeg) {
        if (powderkeg.isLit) {
            --powderkeg.fuse;
            if (powderkeg.fuse <= 0) {
                level.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
                PowderkegBlockEntity.explode(powderkeg);
            }
        }
    }

    public static int getStrength(PowderkegBlockEntity powderkeg) {
        return PowderkegBlockEntity.getStrength((IItemHandler)powderkeg.inventory);
    }

    public static int getStrength(IItemHandler inventory) {
        int count = 0;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            count += inventory.getStackInSlot(i).getCount();
        }
        return PowderkegBlockEntity.getStrength(count);
    }

    public static int getStrength(ItemListComponent inventory) {
        List<ItemStack> contents = inventory.contents();
        int count = 0;
        for (ItemStack stack : contents) {
            count += stack.getCount();
        }
        return PowderkegBlockEntity.getStrength(count);
    }

    private static int getStrength(int itemCount) {
        return Math.min(64, Mth.floor((double)(TFCConfig.SERVER.powderKegStrengthModifier.get() * (double)itemCount / 12.0)));
    }

    private static void explode(PowderkegBlockEntity powderkeg) {
        assert (powderkeg.level != null);
        int x = powderkeg.worldPosition.getX();
        int y = powderkeg.worldPosition.getY();
        int z = powderkeg.worldPosition.getZ();
        int strength = PowderkegBlockEntity.getStrength(powderkeg);
        PowderKegExplosion explosion = new PowderKegExplosion(powderkeg.level, powderkeg.igniter, x, y, z, strength);
        explosion.explode();
        explosion.finalizeExplosion(true);
        explosion.sendExplosionPacketToClients();
    }

    public PowderkegBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.POWDERKEG.get(), pos, state, PowderkegInventory::new);
        if (TFCConfig.SERVER.powderKegEnableAutomation.get().booleanValue()) {
            this.sidedInventory.on(new PartialItemHandler(this.inventory).insertAll(), Direction.UP);
        }
    }

    @Override
    protected void applyImplicitComponents(BlockEntity.DataComponentInput components) {
        List<ItemStack> content = ((ItemListComponent)components.getOrDefault(TFCComponents.CONTENTS, (Object)ItemListComponent.EMPTY)).contents();
        Helpers.copyFrom(content, this.inventory);
        super.applyImplicitComponents(components);
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        if (((Boolean)this.getBlockState().getValue((Property)SealableDeviceBlock.SEALED)).booleanValue()) {
            builder.set(TFCComponents.CONTENTS, (Object)ItemListComponent.of((IItemHandler)this.inventory));
        }
        super.collectImplicitComponents(builder);
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
        return PowderkegContainer.create(this, player.getInventory(), containerId);
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return Helpers.isItem(stack, TFCTags.Items.POWDER_KEG_FUEL);
    }

    public void onSeal() {
        this.markForSync();
    }

    public void onUnseal() {
        this.markForSync();
    }

    public int getFuse() {
        return this.fuse;
    }

    public boolean isLit() {
        return this.isLit;
    }

    public void setLit(boolean lit, @Nullable Entity igniter) {
        if (!TFCConfig.SERVER.powderKegEnabled.get().booleanValue()) {
            if (igniter instanceof Player) {
                Player player = (Player)igniter;
                player.displayClientMessage((Component)Component.translatable((String)"tfc.tooltip.powderkeg.disabled"), true);
            }
            return;
        }
        this.isLit = lit;
        assert (this.level != null);
        this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.level.getBlockState(this.worldPosition).setValue((Property)PowderkegBlock.LIT, (Comparable)Boolean.valueOf(lit)));
        if (lit) {
            Helpers.playSound(this.level, this.worldPosition, SoundEvents.TNT_PRIMED);
            this.fuse = TFCConfig.SERVER.powderKegFuseTime.get();
            this.igniter = igniter;
            if (igniter instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)igniter;
                if (PowderkegBlockEntity.getStrength(this) >= 64) {
                    TFCAdvancements.FULL_POWDERKEG.trigger(serverPlayer);
                }
            }
        } else {
            Helpers.playSound(this.level, this.worldPosition, (SoundEvent)TFCSounds.ITEM_COOL.get());
            this.fuse = -1;
        }
        this.markForSync();
    }

    public static class PowderkegInventory
    extends InventoryItemHandler {
        private final PowderkegBlockEntity powderkeg;

        PowderkegInventory(InventoryBlockEntity<?> entity) {
            super(entity, 12);
            this.powderkeg = (PowderkegBlockEntity)entity;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return this.canModify() ? super.insertItem(slot, stack, simulate) : stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.canModify() ? super.extractItem(slot, amount, simulate) : ItemStack.EMPTY;
        }

        private boolean canModify() {
            return (Boolean)this.powderkeg.getBlockState().getValue((Property)PowderkegBlock.SEALED) == false;
        }
    }
}

