/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;

public class ThatchBedBlockEntity
extends InventoryBlockEntity<ItemStackHandler> {
    private BlockState headState;
    private BlockState footState;

    public ThatchBedBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.THATCH_BED.get(), pos, state, ThatchBedBlockEntity.defaultInventory(1));
        this.headState = this.footState = Blocks.AIR.defaultBlockState();
    }

    public void setBed(BlockState head, BlockState foot, ItemStack top) {
        assert (this.level != null);
        this.headState = head;
        this.footState = foot;
        ((ItemStackHandler)this.inventory).setStackInSlot(0, top);
    }

    public void destroyBed() {
        this.ejectInventory();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Helpers.dropWithContext(serverLevel, this.headState, this.worldPosition, ctx -> {}, true);
            Helpers.dropWithContext(serverLevel, this.footState, this.worldPosition, ctx -> {}, true);
        }
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        tag.put("HeadBlockState", (Tag)NbtUtils.writeBlockState((BlockState)this.headState));
        tag.put("FootBlockState", (Tag)NbtUtils.writeBlockState((BlockState)this.footState));
        super.saveAdditional(tag, provider);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        this.headState = NbtUtils.readBlockState((HolderGetter)provider.lookupOrThrow(Registries.BLOCK), (CompoundTag)tag.getCompound("HeadBlockState"));
        this.footState = NbtUtils.readBlockState((HolderGetter)provider.lookupOrThrow(Registries.BLOCK), (CompoundTag)tag.getCompound("FootBlockState"));
        super.loadAdditional(tag, provider);
    }
}

