/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickCounterBlockEntity;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TickingPlantBlockEntity
extends TickCounterBlockEntity {
    protected BlockPos stemPos;
    protected long lastPickedTick = Integer.MIN_VALUE;

    public static void reset(Level level, BlockPos pos) {
        level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.TICK_COUNTING_PLANT.get()).ifPresent(TickCounterBlockEntity::resetCounter);
    }

    public static void addTicks(Level level, BlockPos pos, long ticks) {
        level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.TICK_COUNTING_PLANT.get()).ifPresent(entity -> entity.increaseCounter(ticks));
    }

    public static void setStemPos(Level level, BlockPos pos, BlockPos stemPos) {
        level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.TICK_COUNTING_PLANT.get()).ifPresent(entity -> entity.setStemPos(stemPos));
    }

    public TickingPlantBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TFCBlockEntities.TICK_COUNTING_PLANT.get(), pos, state);
    }

    public TickingPlantBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.stemPos = pos;
        this.resetLastPickedCounter();
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        this.stemPos = nbt.contains("stemPos", 4) ? BlockPos.of((long)nbt.getLong("stemPos")) : this.worldPosition;
        this.lastPickedTick = nbt.getLong("lastPickedTick");
        super.loadAdditional(nbt, provider);
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.putLong("stemPos", this.stemPos.asLong());
        nbt.putLong("lastPickedTick", this.lastPickedTick);
        super.saveAdditional(nbt, provider);
    }

    public void setStemPos(BlockPos stemPos) {
        this.stemPos = stemPos;
        this.setChanged();
    }

    public BlockPos getStemPos() {
        return this.stemPos;
    }

    public void setLastPickedTick(long tick) {
        this.lastPickedTick = tick;
        this.setChanged();
    }

    public long getLastPickedTick() {
        return this.lastPickedTick;
    }

    public void resetLastPickedCounter() {
        this.lastPickedTick = Calendars.SERVER.getTicks();
        this.setChanged();
    }
}

