/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;

public class ToolRackBlockEntity
extends InventoryBlockEntity<ItemStackHandler> {
    public ToolRackBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.TOOL_RACK.get(), pos, state, ToolRackBlockEntity.defaultInventory(4));
    }

    public InteractionResult onRightClick(Player player, int slot) {
        boolean shouldInsert;
        assert (this.level != null);
        ItemStack heldItem = player.getMainHandItem();
        boolean shouldExtract = !((ItemStackHandler)this.inventory).getStackInSlot(slot).isEmpty();
        boolean bl = shouldInsert = !heldItem.isEmpty() && this.isItemValid(slot, heldItem);
        if (shouldExtract) {
            if (shouldInsert) {
                ItemStack extracted = ((ItemStackHandler)this.inventory).extractItem(slot, 1, false);
                if (!this.level.isClientSide) {
                    this.insertItem(slot, heldItem.split(1));
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)extracted, (int)player.getInventory().selected);
                }
                this.markForSync();
                return InteractionResult.sidedSuccess((boolean)this.level.isClientSide);
            }
            if (!this.level.isClientSide) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)((ItemStackHandler)this.inventory).extractItem(slot, 1, false), (int)player.getInventory().selected);
            }
            this.markForSync();
            return InteractionResult.sidedSuccess((boolean)this.level.isClientSide);
        }
        if (shouldInsert) {
            if (!this.level.isClientSide) {
                this.insertItem(slot, heldItem.split(1));
            }
            this.markForSync();
            return InteractionResult.sidedSuccess((boolean)this.level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return Helpers.isItem(stack, TFCTags.Items.TOOL_RACK_TOOLS);
    }

    @Override
    public int getSlotStackLimit(int slot) {
        return 1;
    }

    private void insertItem(int slot, ItemStack stack) {
        assert (this.level != null);
        ((ItemStackHandler)this.inventory).insertItem(slot, stack, false);
        this.level.playSound(null, this.worldPosition, (SoundEvent)TFCSounds.TOOL_RACK_PLACE.get(), SoundSource.BLOCKS, 1.0f, 1.0f + (this.level.random.nextFloat() - this.level.random.nextFloat()) / 16.0f);
    }
}

