/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities.rotation;

import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TFCBlockEntity;
import net.dries007.tfc.common.blockentities.rotation.RotatingBlockEntity;
import net.dries007.tfc.common.blocks.rotation.AxleBlock;
import net.dries007.tfc.util.rotation.AxleNode;
import net.dries007.tfc.util.rotation.NetworkAction;
import net.dries007.tfc.util.rotation.Node;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class AxleBlockEntity
extends TFCBlockEntity
implements RotatingBlockEntity {
    private final Node node;
    private boolean invalid;

    public AxleBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TFCBlockEntities.AXLE.get(), pos, state);
    }

    protected AxleBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        final Direction.Axis axis = (Direction.Axis)state.getValue((Property)AxleBlock.AXIS);
        this.invalid = false;
        this.node = new AxleNode(pos, Node.ofAxis(axis)){

            @Override
            protected void onInvalidConnection() {
                AxleBlockEntity.this.onInvalidConnection();
            }

            @Override
            public String toString() {
                return "Axle[pos=%s, axis=%s]".formatted(axis, this.pos());
            }
        };
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putBoolean("invalid", this.invalid);
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.invalid = tag.getBoolean("invalid");
    }

    @Override
    protected void onLoadAdditional() {
        this.performNetworkAction(NetworkAction.ADD);
    }

    @Override
    protected void onUnloadAdditional() {
        this.performNetworkAction(NetworkAction.REMOVE);
    }

    @Override
    public void markAsInvalidInNetwork() {
        this.invalid = true;
    }

    @Override
    public boolean isInvalidInNetwork() {
        return this.invalid;
    }

    @Override
    public Node getRotationNode() {
        return this.node;
    }

    private void onInvalidConnection() {
        if (this.level != null) {
            this.markAsInvalidInNetwork();
            this.level.scheduleTick(this.getBlockPos(), this.getBlockState().getBlock(), 4);
        }
    }
}

