/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities.rotation;

import java.util.Set;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.rotation.AxleBlockEntity;
import net.dries007.tfc.common.blocks.rotation.AxleBlock;
import net.dries007.tfc.common.blocks.rotation.ClutchBlock;
import net.dries007.tfc.util.rotation.NetworkAction;
import net.dries007.tfc.util.rotation.Node;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ClutchBlockEntity
extends AxleBlockEntity {
    public ClutchBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TFCBlockEntities.CLUTCH.get(), pos, state);
    }

    public ClutchBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.updateConnections();
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.updateConnections();
    }

    public void updateConnections() {
        BlockState state = this.getBlockState();
        Set<Direction> connections = this.getRotationNode().connections();
        if (((Boolean)state.getValue((Property)ClutchBlock.POWERED)).booleanValue()) {
            connections.clear();
        } else {
            connections.addAll(Node.ofAxis((Direction.Axis)state.getValue((Property)AxleBlock.AXIS)));
        }
        if (this.level != null) {
            this.performNetworkAction(NetworkAction.UPDATE);
            if (!this.level.isClientSide) {
                this.markForSync();
            }
        }
    }
}

