/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities.rotation;

import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TFCBlockEntity;
import net.dries007.tfc.common.blockentities.rotation.RotationSinkBlockEntity;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.rotation.CrankshaftBlock;
import net.dries007.tfc.util.rotation.NetworkAction;
import net.dries007.tfc.util.rotation.Node;
import net.dries007.tfc.util.rotation.Rotation;
import net.dries007.tfc.util.rotation.SinkNode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CrankshaftBlockEntity
extends TFCBlockEntity
implements RotationSinkBlockEntity {
    public static final float WHEEL_RADIUS = 0.25f;
    public static final float ARM_LENGTH = 0.75f;
    public static final float PISTON_LENGTH = 1.0f;
    private final Node node;

    public static ShaftMovement calculateShaftMovement(float rotationAngle) {
        int quadrant = Mth.clamp((int)((int)(rotationAngle / 1.5707964f)), (int)0, (int)3);
        float unitCircleAngle = quadrant == 0 || quadrant == 3 ? rotationAngle : (quadrant == 1 ? (float)Math.PI - rotationAngle : rotationAngle - (float)Math.PI);
        float lengthCB = 0.25f * Mth.sin((float)unitCircleAngle);
        float lengthOC = 0.25f * Mth.cos((float)unitCircleAngle);
        float lengthCH = Mth.sqrt((float)(0.5625f - lengthCB * lengthCB));
        float angleHCB = (float)Math.acos(lengthCH / 0.75f);
        float raiseAngle = quadrant == 2 || quadrant == 3 ? angleHCB : -angleHCB;
        float lengthEH = 1.5f - lengthCH + (quadrant == 1 || quadrant == 2 ? lengthOC : -lengthOC);
        return new ShaftMovement(lengthEH, raiseAngle);
    }

    public static float calculateRealRotationAngle(CrankshaftBlockEntity entity, Direction face, float partialTick) {
        float angle = entity.getRotationAngle(partialTick);
        if (face == Direction.NORTH || face == Direction.EAST) {
            angle = (float)Math.PI * 2 - angle;
        }
        if ((angle += (float)Math.PI) > (float)Math.PI * 2) {
            angle -= (float)Math.PI * 2;
        }
        return angle;
    }

    @Nullable
    public static CrankshaftBlockEntity getCrankShaftAt(LevelAccessor level, BlockPos pos, Direction direction) {
        BlockPos basePos;
        BlockState baseState;
        BlockPos shaftPos = pos.relative(direction);
        BlockState shaftState = level.getBlockState(shaftPos);
        if (CrankshaftBlockEntity.isPart(shaftState, CrankshaftBlock.Part.SHAFT, direction) && CrankshaftBlockEntity.isPart(baseState = level.getBlockState(basePos = pos.relative(direction, 2)), CrankshaftBlock.Part.BASE, direction)) {
            return level.getBlockEntity(basePos, (BlockEntityType)TFCBlockEntities.CRANKSHAFT.get()).orElse(null);
        }
        return null;
    }

    private static boolean isPart(BlockState state, CrankshaftBlock.Part part, Direction direction) {
        return state.getBlock() == TFCBlocks.CRANKSHAFT.get() && state.getValue(CrankshaftBlock.PART) == part && state.getValue(CrankshaftBlock.FACING) == direction.getOpposite();
    }

    public CrankshaftBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.CRANKSHAFT.get(), pos, state);
        Direction connection = ((Direction)state.getValue(CrankshaftBlock.FACING)).getCounterClockWise();
        this.node = new SinkNode(this, pos, connection){

            @Override
            public String toString() {
                return "Crankshaft[pos=%s]".formatted(this.pos());
            }
        };
    }

    @Override
    protected void onLoadAdditional() {
        if (this.getBlockState().getValue(CrankshaftBlock.PART) == CrankshaftBlock.Part.BASE) {
            this.performNetworkAction(NetworkAction.ADD);
        }
    }

    @Override
    protected void onUnloadAdditional() {
        if (this.getBlockState().getValue(CrankshaftBlock.PART) == CrankshaftBlock.Part.BASE) {
            this.performNetworkAction(NetworkAction.REMOVE);
        }
    }

    @Override
    public Node getRotationNode() {
        return this.node;
    }

    public float getExtensionLength(float partialTick) {
        Rotation rotation = this.node.rotation();
        if (rotation != null) {
            Direction face = (Direction)this.getBlockState().getValue(CrankshaftBlock.FACING);
            float rotationAngle = CrankshaftBlockEntity.calculateRealRotationAngle(this, face, partialTick);
            ShaftMovement movement = CrankshaftBlockEntity.calculateShaftMovement(rotationAngle);
            return Math.max(0.0f, 1.0f - movement.lengthEH);
        }
        return 0.0f;
    }

    public record ShaftMovement(float lengthEH, float raiseAngle) {
    }
}

