/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities.rotation;

import java.util.EnumSet;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickableBlockEntity;
import net.dries007.tfc.common.blockentities.rotation.RotatingBlockEntity;
import net.dries007.tfc.common.blocks.rotation.CreativeRotationBlock;
import net.dries007.tfc.util.rotation.NetworkAction;
import net.dries007.tfc.util.rotation.Node;
import net.dries007.tfc.util.rotation.Rotation;
import net.dries007.tfc.util.rotation.SourceNode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class CreativeRotationBlockEntity
extends TickableBlockEntity
implements RotatingBlockEntity {
    public static final float MAX_SPEED = 0.15707964f;
    public static final int MAX_STEPS = 8;
    public static final float LERP_SPEED = 0.019634955f;
    private final CreativeSourceNode node;
    private int step;
    private boolean invalid;

    public static void serverTick(Level level, BlockPos pos, BlockState state, CreativeRotationBlockEntity motor) {
        motor.checkForLastTickSync();
        CreativeRotationBlockEntity.clientTick(level, pos, state, motor);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, CreativeRotationBlockEntity motor) {
        Rotation.Tickable rotation = motor.node.rotation();
        rotation.tick();
        float target = Mth.abs((float)((float)motor.step * 0.019634955f));
        if (rotation.speed() != target) {
            rotation.setSpeed(target);
        }
    }

    public CreativeRotationBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TFCBlockEntities.CREATIVE_MOTOR.get(), pos, state);
    }

    protected CreativeRotationBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        Direction.Axis axis = (Direction.Axis)state.getValue(CreativeRotationBlock.AXIS);
        this.node = new CreativeSourceNode(pos, Node.ofAxis(axis), Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE), 0.0f);
    }

    @Override
    public void markAsInvalidInNetwork() {
        this.invalid = true;
    }

    @Override
    public boolean isInvalidInNetwork() {
        return this.invalid;
    }

    @Override
    public Node getRotationNode() {
        return this.node;
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("step", this.step);
        tag.putBoolean("invalid", this.invalid);
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.step = tag.getInt("step");
        this.invalid = tag.getBoolean("invalid");
    }

    @Override
    protected void onLoadAdditional() {
        this.performNetworkAction(NetworkAction.ADD_SOURCE);
    }

    @Override
    protected void onUnloadAdditional() {
        this.performNetworkAction(NetworkAction.REMOVE);
    }

    public void incrementSpeed() {
        this.step = Mth.clamp((int)(this.step + 1), (int)-8, (int)8);
        if (this.step == 1) {
            this.node.setDirection((Direction.Axis)this.getBlockState().getValue(CreativeRotationBlock.AXIS), Direction.AxisDirection.POSITIVE);
            this.performNetworkAction(NetworkAction.UPDATE);
        }
    }

    public void decrementSpeed() {
        this.step = Mth.clamp((int)(this.step - 1), (int)-8, (int)8);
        if (this.step == -1) {
            this.node.setDirection((Direction.Axis)this.getBlockState().getValue(CreativeRotationBlock.AXIS), Direction.AxisDirection.NEGATIVE);
            this.performNetworkAction(NetworkAction.UPDATE);
        }
    }

    private static class CreativeSourceNode
    extends SourceNode {
        protected CreativeSourceNode(BlockPos pos, EnumSet<Direction> connections, Direction rotationDirection, float speed) {
            super(pos, connections, rotationDirection, speed);
        }

        public void setDirection(Direction.Axis axis, Direction.AxisDirection direction) {
            this.rotation = Rotation.of(Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)direction), 0.0f);
        }

        @Override
        public String toString() {
            return "CreativeRotator[pos=%s, connections=%s]".formatted(this.pos(), this.connections());
        }
    }
}

